/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeRegistriesResponse;
import software.amazon.awssdk.services.ecrpublic.model.Registry;

public class DescribeRegistriesIterable
implements SdkIterable<DescribeRegistriesResponse> {
    private final EcrPublicClient client;
    private final DescribeRegistriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRegistriesIterable(EcrPublicClient client, DescribeRegistriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRegistriesResponseFetcher();
    }

    public Iterator<DescribeRegistriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Registry> registries() {
        Function<DescribeRegistriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.registries() != null) {
                return response.registries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRegistriesResponseFetcher
    implements SyncPageFetcher<DescribeRegistriesResponse> {
        private DescribeRegistriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRegistriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRegistriesResponse nextPage(DescribeRegistriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRegistriesIterable.this.client.describeRegistries(DescribeRegistriesIterable.this.firstRequest);
            }
            return DescribeRegistriesIterable.this.client.describeRegistries((DescribeRegistriesRequest)((Object)DescribeRegistriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

