/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageScanningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutImageScanningConfigurationResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, PutImageScanningConfigurationResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(PutImageScanningConfigurationResponse.getter(PutImageScanningConfigurationResponse::registryId)).setter(PutImageScanningConfigurationResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(PutImageScanningConfigurationResponse.getter(PutImageScanningConfigurationResponse::repositoryName)).setter(PutImageScanningConfigurationResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanningConfiguration").getter(PutImageScanningConfigurationResponse.getter(PutImageScanningConfigurationResponse::imageScanningConfiguration)).setter(PutImageScanningConfigurationResponse.setter(Builder::imageScanningConfiguration)).constructor(ImageScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final ImageScanningConfiguration imageScanningConfiguration;

    private PutImageScanningConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageScanningConfiguration imageScanningConfiguration() {
        return this.imageScanningConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageScanningConfigurationResponse)) {
            return false;
        }
        PutImageScanningConfigurationResponse other = (PutImageScanningConfigurationResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageScanningConfiguration(), other.imageScanningConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutImageScanningConfigurationResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageScanningConfiguration", (Object)this.imageScanningConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageScanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageScanningConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutImageScanningConfigurationResponse, T> g) {
        return obj -> g.apply((PutImageScanningConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private ImageScanningConfiguration imageScanningConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageScanningConfigurationResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageScanningConfiguration(model.imageScanningConfiguration);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return this.imageScanningConfiguration != null ? this.imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        @Override
        public PutImageScanningConfigurationResponse build() {
            return new PutImageScanningConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutImageScanningConfigurationResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageScanningConfiguration(ImageScanningConfiguration var1);

        default public Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return this.imageScanningConfiguration((ImageScanningConfiguration)((ImageScanningConfiguration.Builder)ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)).build());
        }
    }
}

