/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class VpcIpv6CidrBlockAssociationSetCopier {
    static List<VpcIpv6CidrBlockAssociation> copy(
            Collection<? extends VpcIpv6CidrBlockAssociation> vpcIpv6CidrBlockAssociationSetParam) {
        List<VpcIpv6CidrBlockAssociation> list;
        if (vpcIpv6CidrBlockAssociationSetParam == null || vpcIpv6CidrBlockAssociationSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcIpv6CidrBlockAssociation> modifiableList = new ArrayList<>();
            vpcIpv6CidrBlockAssociationSetParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcIpv6CidrBlockAssociation> copyFromBuilder(
            Collection<? extends VpcIpv6CidrBlockAssociation.Builder> vpcIpv6CidrBlockAssociationSetParam) {
        List<VpcIpv6CidrBlockAssociation> list;
        if (vpcIpv6CidrBlockAssociationSetParam == null || vpcIpv6CidrBlockAssociationSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcIpv6CidrBlockAssociation> modifiableList = new ArrayList<>();
            vpcIpv6CidrBlockAssociationSetParam.forEach(entry -> {
                VpcIpv6CidrBlockAssociation member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<VpcIpv6CidrBlockAssociation.Builder> copyToBuilder(
            Collection<? extends VpcIpv6CidrBlockAssociation> vpcIpv6CidrBlockAssociationSetParam) {
        List<VpcIpv6CidrBlockAssociation.Builder> list;
        if (vpcIpv6CidrBlockAssociationSetParam == null || vpcIpv6CidrBlockAssociationSetParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<VpcIpv6CidrBlockAssociation.Builder> modifiableList = new ArrayList<>();
            vpcIpv6CidrBlockAssociationSetParam.forEach(entry -> {
                VpcIpv6CidrBlockAssociation.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
