/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifySnapshotTierRequest extends Ec2Request implements
        ToCopyableBuilder<ModifySnapshotTierRequest.Builder, ModifySnapshotTierRequest> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId")
            .getter(getter(ModifySnapshotTierRequest::snapshotId))
            .setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId")
                    .unmarshallLocationName("SnapshotId").build()).build();

    private static final SdkField<String> STORAGE_TIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StorageTier")
            .getter(getter(ModifySnapshotTierRequest::storageTierAsString))
            .setter(setter(Builder::storageTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageTier")
                    .unmarshallLocationName("StorageTier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            STORAGE_TIER_FIELD));

    private final String snapshotId;

    private final String storageTier;

    private ModifySnapshotTierRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.storageTier = builder.storageTier;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The name of the storage tier. You must specify <code>archive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageTier} will
     * return {@link TargetStorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTierAsString}.
     * </p>
     * 
     * @return The name of the storage tier. You must specify <code>archive</code>.
     * @see TargetStorageTier
     */
    public final TargetStorageTier storageTier() {
        return TargetStorageTier.fromValue(storageTier);
    }

    /**
     * <p>
     * The name of the storage tier. You must specify <code>archive</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageTier} will
     * return {@link TargetStorageTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTierAsString}.
     * </p>
     * 
     * @return The name of the storage tier. You must specify <code>archive</code>.
     * @see TargetStorageTier
     */
    public final String storageTierAsString() {
        return storageTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(storageTierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotTierRequest)) {
            return false;
        }
        ModifySnapshotTierRequest other = (ModifySnapshotTierRequest) obj;
        return Objects.equals(snapshotId(), other.snapshotId())
                && Objects.equals(storageTierAsString(), other.storageTierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifySnapshotTierRequest").add("SnapshotId", snapshotId())
                .add("StorageTier", storageTierAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "StorageTier":
            return Optional.ofNullable(clazz.cast(storageTierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotTierRequest, T> g) {
        return obj -> g.apply((ModifySnapshotTierRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifySnapshotTierRequest> {
        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The name of the storage tier. You must specify <code>archive</code>.
         * </p>
         * 
         * @param storageTier
         *        The name of the storage tier. You must specify <code>archive</code>.
         * @see TargetStorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStorageTier
         */
        Builder storageTier(String storageTier);

        /**
         * <p>
         * The name of the storage tier. You must specify <code>archive</code>.
         * </p>
         * 
         * @param storageTier
         *        The name of the storage tier. You must specify <code>archive</code>.
         * @see TargetStorageTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStorageTier
         */
        Builder storageTier(TargetStorageTier storageTier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String snapshotId;

        private String storageTier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotTierRequest model) {
            super(model);
            snapshotId(model.snapshotId);
            storageTier(model.storageTier);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStorageTier() {
            return storageTier;
        }

        public final void setStorageTier(String storageTier) {
            this.storageTier = storageTier;
        }

        @Override
        public final Builder storageTier(String storageTier) {
            this.storageTier = storageTier;
            return this;
        }

        @Override
        public final Builder storageTier(TargetStorageTier storageTier) {
            this.storageTier(storageTier == null ? null : storageTier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotTierRequest build() {
            return new ModifySnapshotTierRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
