/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a transit gateway route table announcement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayRouteTableAnnouncement implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayRouteTableAnnouncement.Builder, TransitGatewayRouteTableAnnouncement> {
    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableAnnouncementId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::transitGatewayRouteTableAnnouncementId))
            .setter(setter(Builder::transitGatewayRouteTableAnnouncementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("TransitGatewayRouteTableAnnouncementId")
                    .unmarshallLocationName("transitGatewayRouteTableAnnouncementId").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::transitGatewayId))
            .setter(setter(Builder::transitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId")
                    .unmarshallLocationName("transitGatewayId").build()).build();

    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CoreNetworkId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::coreNetworkId))
            .setter(setter(Builder::coreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreNetworkId")
                    .unmarshallLocationName("coreNetworkId").build()).build();

    private static final SdkField<String> PEER_TRANSIT_GATEWAY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerTransitGatewayId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::peerTransitGatewayId))
            .setter(setter(Builder::peerTransitGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerTransitGatewayId")
                    .unmarshallLocationName("peerTransitGatewayId").build()).build();

    private static final SdkField<String> PEER_CORE_NETWORK_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerCoreNetworkId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::peerCoreNetworkId))
            .setter(setter(Builder::peerCoreNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerCoreNetworkId")
                    .unmarshallLocationName("peerCoreNetworkId").build()).build();

    private static final SdkField<String> PEERING_ATTACHMENT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeeringAttachmentId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::peeringAttachmentId))
            .setter(setter(Builder::peeringAttachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeeringAttachmentId")
                    .unmarshallLocationName("peeringAttachmentId").build()).build();

    private static final SdkField<String> ANNOUNCEMENT_DIRECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnnouncementDirection")
            .getter(getter(TransitGatewayRouteTableAnnouncement::announcementDirectionAsString))
            .setter(setter(Builder::announcementDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnouncementDirection")
                    .unmarshallLocationName("announcementDirection").build()).build();

    private static final SdkField<String> TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayRouteTableId")
            .getter(getter(TransitGatewayRouteTableAnnouncement::transitGatewayRouteTableId))
            .setter(setter(Builder::transitGatewayRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayRouteTableId")
                    .unmarshallLocationName("transitGatewayRouteTableId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(TransitGatewayRouteTableAnnouncement::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(TransitGatewayRouteTableAnnouncement::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime")
                    .unmarshallLocationName("creationTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(TransitGatewayRouteTableAnnouncement::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSIT_GATEWAY_ROUTE_TABLE_ANNOUNCEMENT_ID_FIELD, TRANSIT_GATEWAY_ID_FIELD, CORE_NETWORK_ID_FIELD,
            PEER_TRANSIT_GATEWAY_ID_FIELD, PEER_CORE_NETWORK_ID_FIELD, PEERING_ATTACHMENT_ID_FIELD, ANNOUNCEMENT_DIRECTION_FIELD,
            TRANSIT_GATEWAY_ROUTE_TABLE_ID_FIELD, STATE_FIELD, CREATION_TIME_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayRouteTableAnnouncementId;

    private final String transitGatewayId;

    private final String coreNetworkId;

    private final String peerTransitGatewayId;

    private final String peerCoreNetworkId;

    private final String peeringAttachmentId;

    private final String announcementDirection;

    private final String transitGatewayRouteTableId;

    private final String state;

    private final Instant creationTime;

    private final List<Tag> tags;

    private TransitGatewayRouteTableAnnouncement(BuilderImpl builder) {
        this.transitGatewayRouteTableAnnouncementId = builder.transitGatewayRouteTableAnnouncementId;
        this.transitGatewayId = builder.transitGatewayId;
        this.coreNetworkId = builder.coreNetworkId;
        this.peerTransitGatewayId = builder.peerTransitGatewayId;
        this.peerCoreNetworkId = builder.peerCoreNetworkId;
        this.peeringAttachmentId = builder.peeringAttachmentId;
        this.announcementDirection = builder.announcementDirection;
        this.transitGatewayRouteTableId = builder.transitGatewayRouteTableId;
        this.state = builder.state;
        this.creationTime = builder.creationTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the transit gateway route table announcement.
     * </p>
     * 
     * @return The ID of the transit gateway route table announcement.
     */
    public final String transitGatewayRouteTableAnnouncementId() {
        return transitGatewayRouteTableAnnouncementId;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String transitGatewayId() {
        return transitGatewayId;
    }

    /**
     * <p>
     * The ID of the core network for the transit gateway route table announcement.
     * </p>
     * 
     * @return The ID of the core network for the transit gateway route table announcement.
     */
    public final String coreNetworkId() {
        return coreNetworkId;
    }

    /**
     * <p>
     * The ID of the peer transit gateway.
     * </p>
     * 
     * @return The ID of the peer transit gateway.
     */
    public final String peerTransitGatewayId() {
        return peerTransitGatewayId;
    }

    /**
     * <p>
     * The ID of the core network ID for the peer.
     * </p>
     * 
     * @return The ID of the core network ID for the peer.
     */
    public final String peerCoreNetworkId() {
        return peerCoreNetworkId;
    }

    /**
     * <p>
     * The ID of the peering attachment.
     * </p>
     * 
     * @return The ID of the peering attachment.
     */
    public final String peeringAttachmentId() {
        return peeringAttachmentId;
    }

    /**
     * <p>
     * The direction for the route table announcement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #announcementDirection} will return
     * {@link TransitGatewayRouteTableAnnouncementDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #announcementDirectionAsString}.
     * </p>
     * 
     * @return The direction for the route table announcement.
     * @see TransitGatewayRouteTableAnnouncementDirection
     */
    public final TransitGatewayRouteTableAnnouncementDirection announcementDirection() {
        return TransitGatewayRouteTableAnnouncementDirection.fromValue(announcementDirection);
    }

    /**
     * <p>
     * The direction for the route table announcement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #announcementDirection} will return
     * {@link TransitGatewayRouteTableAnnouncementDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #announcementDirectionAsString}.
     * </p>
     * 
     * @return The direction for the route table announcement.
     * @see TransitGatewayRouteTableAnnouncementDirection
     */
    public final String announcementDirectionAsString() {
        return announcementDirection;
    }

    /**
     * <p>
     * The ID of the transit gateway route table.
     * </p>
     * 
     * @return The ID of the transit gateway route table.
     */
    public final String transitGatewayRouteTableId() {
        return transitGatewayRouteTableId;
    }

    /**
     * <p>
     * The state of the transit gateway announcement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteTableAnnouncementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway announcement.
     * @see TransitGatewayRouteTableAnnouncementState
     */
    public final TransitGatewayRouteTableAnnouncementState state() {
        return TransitGatewayRouteTableAnnouncementState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transit gateway announcement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link TransitGatewayRouteTableAnnouncementState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transit gateway announcement.
     * @see TransitGatewayRouteTableAnnouncementState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the transit gateway route table announcement was created.
     * </p>
     * 
     * @return The timestamp when the transit gateway route table announcement was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pairs associated with the route table announcement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs associated with the route table announcement.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableAnnouncementId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(peerTransitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(peerCoreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(peeringAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(announcementDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayRouteTableAnnouncement)) {
            return false;
        }
        TransitGatewayRouteTableAnnouncement other = (TransitGatewayRouteTableAnnouncement) obj;
        return Objects.equals(transitGatewayRouteTableAnnouncementId(), other.transitGatewayRouteTableAnnouncementId())
                && Objects.equals(transitGatewayId(), other.transitGatewayId())
                && Objects.equals(coreNetworkId(), other.coreNetworkId())
                && Objects.equals(peerTransitGatewayId(), other.peerTransitGatewayId())
                && Objects.equals(peerCoreNetworkId(), other.peerCoreNetworkId())
                && Objects.equals(peeringAttachmentId(), other.peeringAttachmentId())
                && Objects.equals(announcementDirectionAsString(), other.announcementDirectionAsString())
                && Objects.equals(transitGatewayRouteTableId(), other.transitGatewayRouteTableId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(creationTime(), other.creationTime())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayRouteTableAnnouncement")
                .add("TransitGatewayRouteTableAnnouncementId", transitGatewayRouteTableAnnouncementId())
                .add("TransitGatewayId", transitGatewayId()).add("CoreNetworkId", coreNetworkId())
                .add("PeerTransitGatewayId", peerTransitGatewayId()).add("PeerCoreNetworkId", peerCoreNetworkId())
                .add("PeeringAttachmentId", peeringAttachmentId()).add("AnnouncementDirection", announcementDirectionAsString())
                .add("TransitGatewayRouteTableId", transitGatewayRouteTableId()).add("State", stateAsString())
                .add("CreationTime", creationTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayRouteTableAnnouncementId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableAnnouncementId()));
        case "TransitGatewayId":
            return Optional.ofNullable(clazz.cast(transitGatewayId()));
        case "CoreNetworkId":
            return Optional.ofNullable(clazz.cast(coreNetworkId()));
        case "PeerTransitGatewayId":
            return Optional.ofNullable(clazz.cast(peerTransitGatewayId()));
        case "PeerCoreNetworkId":
            return Optional.ofNullable(clazz.cast(peerCoreNetworkId()));
        case "PeeringAttachmentId":
            return Optional.ofNullable(clazz.cast(peeringAttachmentId()));
        case "AnnouncementDirection":
            return Optional.ofNullable(clazz.cast(announcementDirectionAsString()));
        case "TransitGatewayRouteTableId":
            return Optional.ofNullable(clazz.cast(transitGatewayRouteTableId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayRouteTableAnnouncement, T> g) {
        return obj -> g.apply((TransitGatewayRouteTableAnnouncement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayRouteTableAnnouncement> {
        /**
         * <p>
         * The ID of the transit gateway route table announcement.
         * </p>
         * 
         * @param transitGatewayRouteTableAnnouncementId
         *        The ID of the transit gateway route table announcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId);

        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param transitGatewayId
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayId(String transitGatewayId);

        /**
         * <p>
         * The ID of the core network for the transit gateway route table announcement.
         * </p>
         * 
         * @param coreNetworkId
         *        The ID of the core network for the transit gateway route table announcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreNetworkId(String coreNetworkId);

        /**
         * <p>
         * The ID of the peer transit gateway.
         * </p>
         * 
         * @param peerTransitGatewayId
         *        The ID of the peer transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerTransitGatewayId(String peerTransitGatewayId);

        /**
         * <p>
         * The ID of the core network ID for the peer.
         * </p>
         * 
         * @param peerCoreNetworkId
         *        The ID of the core network ID for the peer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerCoreNetworkId(String peerCoreNetworkId);

        /**
         * <p>
         * The ID of the peering attachment.
         * </p>
         * 
         * @param peeringAttachmentId
         *        The ID of the peering attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peeringAttachmentId(String peeringAttachmentId);

        /**
         * <p>
         * The direction for the route table announcement.
         * </p>
         * 
         * @param announcementDirection
         *        The direction for the route table announcement.
         * @see TransitGatewayRouteTableAnnouncementDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableAnnouncementDirection
         */
        Builder announcementDirection(String announcementDirection);

        /**
         * <p>
         * The direction for the route table announcement.
         * </p>
         * 
         * @param announcementDirection
         *        The direction for the route table announcement.
         * @see TransitGatewayRouteTableAnnouncementDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableAnnouncementDirection
         */
        Builder announcementDirection(TransitGatewayRouteTableAnnouncementDirection announcementDirection);

        /**
         * <p>
         * The ID of the transit gateway route table.
         * </p>
         * 
         * @param transitGatewayRouteTableId
         *        The ID of the transit gateway route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayRouteTableId(String transitGatewayRouteTableId);

        /**
         * <p>
         * The state of the transit gateway announcement.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway announcement.
         * @see TransitGatewayRouteTableAnnouncementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableAnnouncementState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transit gateway announcement.
         * </p>
         * 
         * @param state
         *        The state of the transit gateway announcement.
         * @see TransitGatewayRouteTableAnnouncementState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransitGatewayRouteTableAnnouncementState
         */
        Builder state(TransitGatewayRouteTableAnnouncementState state);

        /**
         * <p>
         * The timestamp when the transit gateway route table announcement was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp when the transit gateway route table announcement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The key-value pairs associated with the route table announcement.
         * </p>
         * 
         * @param tags
         *        The key-value pairs associated with the route table announcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The key-value pairs associated with the route table announcement.
         * </p>
         * 
         * @param tags
         *        The key-value pairs associated with the route table announcement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The key-value pairs associated with the route table announcement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayRouteTableAnnouncementId;

        private String transitGatewayId;

        private String coreNetworkId;

        private String peerTransitGatewayId;

        private String peerCoreNetworkId;

        private String peeringAttachmentId;

        private String announcementDirection;

        private String transitGatewayRouteTableId;

        private String state;

        private Instant creationTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayRouteTableAnnouncement model) {
            transitGatewayRouteTableAnnouncementId(model.transitGatewayRouteTableAnnouncementId);
            transitGatewayId(model.transitGatewayId);
            coreNetworkId(model.coreNetworkId);
            peerTransitGatewayId(model.peerTransitGatewayId);
            peerCoreNetworkId(model.peerCoreNetworkId);
            peeringAttachmentId(model.peeringAttachmentId);
            announcementDirection(model.announcementDirection);
            transitGatewayRouteTableId(model.transitGatewayRouteTableId);
            state(model.state);
            creationTime(model.creationTime);
            tags(model.tags);
        }

        public final String getTransitGatewayRouteTableAnnouncementId() {
            return transitGatewayRouteTableAnnouncementId;
        }

        public final void setTransitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
        }

        @Override
        public final Builder transitGatewayRouteTableAnnouncementId(String transitGatewayRouteTableAnnouncementId) {
            this.transitGatewayRouteTableAnnouncementId = transitGatewayRouteTableAnnouncementId;
            return this;
        }

        public final String getTransitGatewayId() {
            return transitGatewayId;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final String getCoreNetworkId() {
            return coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final String getPeerTransitGatewayId() {
            return peerTransitGatewayId;
        }

        public final void setPeerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
        }

        @Override
        public final Builder peerTransitGatewayId(String peerTransitGatewayId) {
            this.peerTransitGatewayId = peerTransitGatewayId;
            return this;
        }

        public final String getPeerCoreNetworkId() {
            return peerCoreNetworkId;
        }

        public final void setPeerCoreNetworkId(String peerCoreNetworkId) {
            this.peerCoreNetworkId = peerCoreNetworkId;
        }

        @Override
        public final Builder peerCoreNetworkId(String peerCoreNetworkId) {
            this.peerCoreNetworkId = peerCoreNetworkId;
            return this;
        }

        public final String getPeeringAttachmentId() {
            return peeringAttachmentId;
        }

        public final void setPeeringAttachmentId(String peeringAttachmentId) {
            this.peeringAttachmentId = peeringAttachmentId;
        }

        @Override
        public final Builder peeringAttachmentId(String peeringAttachmentId) {
            this.peeringAttachmentId = peeringAttachmentId;
            return this;
        }

        public final String getAnnouncementDirection() {
            return announcementDirection;
        }

        public final void setAnnouncementDirection(String announcementDirection) {
            this.announcementDirection = announcementDirection;
        }

        @Override
        public final Builder announcementDirection(String announcementDirection) {
            this.announcementDirection = announcementDirection;
            return this;
        }

        @Override
        public final Builder announcementDirection(TransitGatewayRouteTableAnnouncementDirection announcementDirection) {
            this.announcementDirection(announcementDirection == null ? null : announcementDirection.toString());
            return this;
        }

        public final String getTransitGatewayRouteTableId() {
            return transitGatewayRouteTableId;
        }

        public final void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
        }

        @Override
        public final Builder transitGatewayRouteTableId(String transitGatewayRouteTableId) {
            this.transitGatewayRouteTableId = transitGatewayRouteTableId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayRouteTableAnnouncementState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayRouteTableAnnouncement build() {
            return new TransitGatewayRouteTableAnnouncement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
