/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Connect peer details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitGatewayConnectPeerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitGatewayConnectPeerConfiguration.Builder, TransitGatewayConnectPeerConfiguration> {
    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayAddress")
            .getter(getter(TransitGatewayConnectPeerConfiguration::transitGatewayAddress))
            .setter(setter(Builder::transitGatewayAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress")
                    .unmarshallLocationName("transitGatewayAddress").build()).build();

    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PeerAddress")
            .getter(getter(TransitGatewayConnectPeerConfiguration::peerAddress))
            .setter(setter(Builder::peerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress")
                    .unmarshallLocationName("peerAddress").build()).build();

    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InsideCidrBlocks")
            .getter(getter(TransitGatewayConnectPeerConfiguration::insideCidrBlocks))
            .setter(setter(Builder::insideCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks")
                    .unmarshallLocationName("insideCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(TransitGatewayConnectPeerConfiguration::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<List<TransitGatewayAttachmentBgpConfiguration>> BGP_CONFIGURATIONS_FIELD = SdkField
            .<List<TransitGatewayAttachmentBgpConfiguration>> builder(MarshallingType.LIST)
            .memberName("BgpConfigurations")
            .getter(getter(TransitGatewayConnectPeerConfiguration::bgpConfigurations))
            .setter(setter(Builder::bgpConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpConfigurations")
                    .unmarshallLocationName("bgpConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TransitGatewayAttachmentBgpConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitGatewayAttachmentBgpConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ADDRESS_FIELD,
            PEER_ADDRESS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, PROTOCOL_FIELD, BGP_CONFIGURATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String transitGatewayAddress;

    private final String peerAddress;

    private final List<String> insideCidrBlocks;

    private final String protocol;

    private final List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations;

    private TransitGatewayConnectPeerConfiguration(BuilderImpl builder) {
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.protocol = builder.protocol;
        this.bgpConfigurations = builder.bgpConfigurations;
    }

    /**
     * <p>
     * The Connect peer IP address on the transit gateway side of the tunnel.
     * </p>
     * 
     * @return The Connect peer IP address on the transit gateway side of the tunnel.
     */
    public final String transitGatewayAddress() {
        return transitGatewayAddress;
    }

    /**
     * <p>
     * The Connect peer IP address on the appliance side of the tunnel.
     * </p>
     * 
     * @return The Connect peer IP address on the appliance side of the tunnel.
     */
    public final String peerAddress() {
        return peerAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the InsideCidrBlocks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInsideCidrBlocks() {
        return insideCidrBlocks != null && !(insideCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The range of interior BGP peer IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInsideCidrBlocks} method.
     * </p>
     * 
     * @return The range of interior BGP peer IP addresses.
     */
    public final List<String> insideCidrBlocks() {
        return insideCidrBlocks;
    }

    /**
     * <p>
     * The tunnel protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The tunnel protocol.
     * @see ProtocolValue
     */
    public final ProtocolValue protocol() {
        return ProtocolValue.fromValue(protocol);
    }

    /**
     * <p>
     * The tunnel protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The tunnel protocol.
     * @see ProtocolValue
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the BgpConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBgpConfigurations() {
        return bgpConfigurations != null && !(bgpConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The BGP configuration details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBgpConfigurations} method.
     * </p>
     * 
     * @return The BGP configuration details.
     */
    public final List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations() {
        return bgpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasInsideCidrBlocks() ? insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBgpConfigurations() ? bgpConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConnectPeerConfiguration)) {
            return false;
        }
        TransitGatewayConnectPeerConfiguration other = (TransitGatewayConnectPeerConfiguration) obj;
        return Objects.equals(transitGatewayAddress(), other.transitGatewayAddress())
                && Objects.equals(peerAddress(), other.peerAddress()) && hasInsideCidrBlocks() == other.hasInsideCidrBlocks()
                && Objects.equals(insideCidrBlocks(), other.insideCidrBlocks())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasBgpConfigurations() == other.hasBgpConfigurations()
                && Objects.equals(bgpConfigurations(), other.bgpConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitGatewayConnectPeerConfiguration").add("TransitGatewayAddress", transitGatewayAddress())
                .add("PeerAddress", peerAddress()).add("InsideCidrBlocks", hasInsideCidrBlocks() ? insideCidrBlocks() : null)
                .add("Protocol", protocolAsString())
                .add("BgpConfigurations", hasBgpConfigurations() ? bgpConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransitGatewayAddress":
            return Optional.ofNullable(clazz.cast(transitGatewayAddress()));
        case "PeerAddress":
            return Optional.ofNullable(clazz.cast(peerAddress()));
        case "InsideCidrBlocks":
            return Optional.ofNullable(clazz.cast(insideCidrBlocks()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "BgpConfigurations":
            return Optional.ofNullable(clazz.cast(bgpConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConnectPeerConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayConnectPeerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitGatewayConnectPeerConfiguration> {
        /**
         * <p>
         * The Connect peer IP address on the transit gateway side of the tunnel.
         * </p>
         * 
         * @param transitGatewayAddress
         *        The Connect peer IP address on the transit gateway side of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayAddress(String transitGatewayAddress);

        /**
         * <p>
         * The Connect peer IP address on the appliance side of the tunnel.
         * </p>
         * 
         * @param peerAddress
         *        The Connect peer IP address on the appliance side of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerAddress(String peerAddress);

        /**
         * <p>
         * The range of interior BGP peer IP addresses.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The range of interior BGP peer IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(Collection<String> insideCidrBlocks);

        /**
         * <p>
         * The range of interior BGP peer IP addresses.
         * </p>
         * 
         * @param insideCidrBlocks
         *        The range of interior BGP peer IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insideCidrBlocks(String... insideCidrBlocks);

        /**
         * <p>
         * The tunnel protocol.
         * </p>
         * 
         * @param protocol
         *        The tunnel protocol.
         * @see ProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolValue
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The tunnel protocol.
         * </p>
         * 
         * @param protocol
         *        The tunnel protocol.
         * @see ProtocolValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolValue
         */
        Builder protocol(ProtocolValue protocol);

        /**
         * <p>
         * The BGP configuration details.
         * </p>
         * 
         * @param bgpConfigurations
         *        The BGP configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations);

        /**
         * <p>
         * The BGP configuration details.
         * </p>
         * 
         * @param bgpConfigurations
         *        The BGP configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpConfigurations(TransitGatewayAttachmentBgpConfiguration... bgpConfigurations);

        /**
         * <p>
         * The BGP configuration details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #bgpConfigurations(List<TransitGatewayAttachmentBgpConfiguration>)}.
         * 
         * @param bgpConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentBgpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bgpConfigurations(java.util.Collection<TransitGatewayAttachmentBgpConfiguration>)
         */
        Builder bgpConfigurations(Consumer<TransitGatewayAttachmentBgpConfiguration.Builder>... bgpConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String transitGatewayAddress;

        private String peerAddress;

        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private List<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConnectPeerConfiguration model) {
            transitGatewayAddress(model.transitGatewayAddress);
            peerAddress(model.peerAddress);
            insideCidrBlocks(model.insideCidrBlocks);
            protocol(model.protocol);
            bgpConfigurations(model.bgpConfigurations);
        }

        public final String getTransitGatewayAddress() {
            return transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String... insideCidrBlocks) {
            insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolValue protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final List<TransitGatewayAttachmentBgpConfiguration.Builder> getBgpConfigurations() {
            List<TransitGatewayAttachmentBgpConfiguration.Builder> result = TransitGatewayAttachmentBgpConfigurationListCopier
                    .copyToBuilder(this.bgpConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration.BuilderImpl> bgpConfigurations) {
            this.bgpConfigurations = TransitGatewayAttachmentBgpConfigurationListCopier.copyFromBuilder(bgpConfigurations);
        }

        @Override
        public final Builder bgpConfigurations(Collection<TransitGatewayAttachmentBgpConfiguration> bgpConfigurations) {
            this.bgpConfigurations = TransitGatewayAttachmentBgpConfigurationListCopier.copy(bgpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(TransitGatewayAttachmentBgpConfiguration... bgpConfigurations) {
            bgpConfigurations(Arrays.asList(bgpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bgpConfigurations(Consumer<TransitGatewayAttachmentBgpConfiguration.Builder>... bgpConfigurations) {
            bgpConfigurations(Stream.of(bgpConfigurations)
                    .map(c -> TransitGatewayAttachmentBgpConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public TransitGatewayConnectPeerConfiguration build() {
            return new TransitGatewayConnectPeerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
