/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProvisionIpamPoolCidrRequest extends Ec2Request implements
        ToCopyableBuilder<ProvisionIpamPoolCidrRequest.Builder, ProvisionIpamPoolCidrRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(ProvisionIpamPoolCidrRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("DryRun").build()).build();

    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPoolId")
            .getter(getter(ProvisionIpamPoolCidrRequest::ipamPoolId))
            .setter(setter(Builder::ipamPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId")
                    .unmarshallLocationName("IpamPoolId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Cidr")
            .getter(getter(ProvisionIpamPoolCidrRequest::cidr))
            .setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr")
                    .unmarshallLocationName("Cidr").build()).build();

    private static final SdkField<IpamCidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField
            .<IpamCidrAuthorizationContext> builder(MarshallingType.SDK_POJO)
            .memberName("CidrAuthorizationContext")
            .getter(getter(ProvisionIpamPoolCidrRequest::cidrAuthorizationContext))
            .setter(setter(Builder::cidrAuthorizationContext))
            .constructor(IpamCidrAuthorizationContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext")
                    .unmarshallLocationName("CidrAuthorizationContext").build()).build();

    private static final SdkField<Integer> NETMASK_LENGTH_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetmaskLength")
            .getter(getter(ProvisionIpamPoolCidrRequest::netmaskLength))
            .setter(setter(Builder::netmaskLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetmaskLength")
                    .unmarshallLocationName("NetmaskLength").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ProvisionIpamPoolCidrRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            IPAM_POOL_ID_FIELD, CIDR_FIELD, CIDR_AUTHORIZATION_CONTEXT_FIELD, NETMASK_LENGTH_FIELD, CLIENT_TOKEN_FIELD));

    private final Boolean dryRun;

    private final String ipamPoolId;

    private final String cidr;

    private final IpamCidrAuthorizationContext cidrAuthorizationContext;

    private final Integer netmaskLength;

    private final String clientToken;

    private ProvisionIpamPoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.ipamPoolId = builder.ipamPoolId;
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
        this.netmaskLength = builder.netmaskLength;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A check for whether you have the required permissions for the action without actually making the request and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return A check for whether you have the required permissions for the action without actually making the request
     *         and provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the IPAM pool to which you want to assign a CIDR.
     * </p>
     * 
     * @return The ID of the IPAM pool to which you want to assign a CIDR.
     */
    public final String ipamPoolId() {
        return ipamPoolId;
    }

    /**
     * <p>
     * The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or "Cidr" is required. This value will be
     * null if you specify "NetmaskLength" and will be filled in during the provisioning process.
     * </p>
     * 
     * @return The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or "Cidr" is required. This value
     *         will be null if you specify "NetmaskLength" and will be filled in during the provisioning process.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
     * BYOIP. This option applies to public pools only.
     * </p>
     * 
     * @return A signed document that proves that you are authorized to bring a specified IP address range to Amazon
     *         using BYOIP. This option applies to public pools only.
     */
    public final IpamCidrAuthorizationContext cidrAuthorizationContext() {
        return cidrAuthorizationContext;
    }

    /**
     * <p>
     * The netmask length of the CIDR you'd like to provision to a pool. Can be used for provisioning Amazon-provided
     * IPv6 CIDRs to top-level pools and for provisioning CIDRs to pools with source pools. Cannot be used to provision
     * BYOIP CIDRs to top-level pools. Either "NetmaskLength" or "Cidr" is required.
     * </p>
     * 
     * @return The netmask length of the CIDR you'd like to provision to a pool. Can be used for provisioning
     *         Amazon-provided IPv6 CIDRs to top-level pools and for provisioning CIDRs to pools with source pools.
     *         Cannot be used to provision BYOIP CIDRs to top-level pools. Either "NetmaskLength" or "Cidr" is required.
     */
    public final Integer netmaskLength() {
        return netmaskLength;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAuthorizationContext());
        hashCode = 31 * hashCode + Objects.hashCode(netmaskLength());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamPoolCidrRequest)) {
            return false;
        }
        ProvisionIpamPoolCidrRequest other = (ProvisionIpamPoolCidrRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(ipamPoolId(), other.ipamPoolId())
                && Objects.equals(cidr(), other.cidr())
                && Objects.equals(cidrAuthorizationContext(), other.cidrAuthorizationContext())
                && Objects.equals(netmaskLength(), other.netmaskLength()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProvisionIpamPoolCidrRequest").add("DryRun", dryRun()).add("IpamPoolId", ipamPoolId())
                .add("Cidr", cidr()).add("CidrAuthorizationContext", cidrAuthorizationContext())
                .add("NetmaskLength", netmaskLength()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "IpamPoolId":
            return Optional.ofNullable(clazz.cast(ipamPoolId()));
        case "Cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "CidrAuthorizationContext":
            return Optional.ofNullable(clazz.cast(cidrAuthorizationContext()));
        case "NetmaskLength":
            return Optional.ofNullable(clazz.cast(netmaskLength()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamPoolCidrRequest, T> g) {
        return obj -> g.apply((ProvisionIpamPoolCidrRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ProvisionIpamPoolCidrRequest> {
        /**
         * <p>
         * A check for whether you have the required permissions for the action without actually making the request and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        A check for whether you have the required permissions for the action without actually making the
         *        request and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the IPAM pool to which you want to assign a CIDR.
         * </p>
         * 
         * @param ipamPoolId
         *        The ID of the IPAM pool to which you want to assign a CIDR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPoolId(String ipamPoolId);

        /**
         * <p>
         * The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or "Cidr" is required. This value will
         * be null if you specify "NetmaskLength" and will be filled in during the provisioning process.
         * </p>
         * 
         * @param cidr
         *        The CIDR you want to assign to the IPAM pool. Either "NetmaskLength" or "Cidr" is required. This value
         *        will be null if you specify "NetmaskLength" and will be filled in during the provisioning process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
         * BYOIP. This option applies to public pools only.
         * </p>
         * 
         * @param cidrAuthorizationContext
         *        A signed document that proves that you are authorized to bring a specified IP address range to Amazon
         *        using BYOIP. This option applies to public pools only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAuthorizationContext(IpamCidrAuthorizationContext cidrAuthorizationContext);

        /**
         * <p>
         * A signed document that proves that you are authorized to bring a specified IP address range to Amazon using
         * BYOIP. This option applies to public pools only.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpamCidrAuthorizationContext.Builder}
         * avoiding the need to create one manually via {@link IpamCidrAuthorizationContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpamCidrAuthorizationContext.Builder#build()} is called
         * immediately and its result is passed to {@link #cidrAuthorizationContext(IpamCidrAuthorizationContext)}.
         * 
         * @param cidrAuthorizationContext
         *        a consumer that will call methods on {@link IpamCidrAuthorizationContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrAuthorizationContext(IpamCidrAuthorizationContext)
         */
        default Builder cidrAuthorizationContext(Consumer<IpamCidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return cidrAuthorizationContext(IpamCidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext)
                    .build());
        }

        /**
         * <p>
         * The netmask length of the CIDR you'd like to provision to a pool. Can be used for provisioning
         * Amazon-provided IPv6 CIDRs to top-level pools and for provisioning CIDRs to pools with source pools. Cannot
         * be used to provision BYOIP CIDRs to top-level pools. Either "NetmaskLength" or "Cidr" is required.
         * </p>
         * 
         * @param netmaskLength
         *        The netmask length of the CIDR you'd like to provision to a pool. Can be used for provisioning
         *        Amazon-provided IPv6 CIDRs to top-level pools and for provisioning CIDRs to pools with source pools.
         *        Cannot be used to provision BYOIP CIDRs to top-level pools. Either "NetmaskLength" or "Cidr" is
         *        required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder netmaskLength(Integer netmaskLength);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String ipamPoolId;

        private String cidr;

        private IpamCidrAuthorizationContext cidrAuthorizationContext;

        private Integer netmaskLength;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamPoolCidrRequest model) {
            super(model);
            dryRun(model.dryRun);
            ipamPoolId(model.ipamPoolId);
            cidr(model.cidr);
            cidrAuthorizationContext(model.cidrAuthorizationContext);
            netmaskLength(model.netmaskLength);
            clientToken(model.clientToken);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getIpamPoolId() {
            return ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final IpamCidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return cidrAuthorizationContext != null ? cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(IpamCidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(IpamCidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        public final Integer getNetmaskLength() {
            return netmaskLength;
        }

        public final void setNetmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
        }

        @Override
        public final Builder netmaskLength(Integer netmaskLength) {
            this.netmaskLength = netmaskLength;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionIpamPoolCidrRequest build() {
            return new ProvisionIpamPoolCidrRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
