/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInsightsPath implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInsightsPath.Builder, NetworkInsightsPath> {
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathId")
            .getter(getter(NetworkInsightsPath::networkInsightsPathId))
            .setter(setter(Builder::networkInsightsPathId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId")
                    .unmarshallLocationName("networkInsightsPathId").build()).build();

    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkInsightsPathArn")
            .getter(getter(NetworkInsightsPath::networkInsightsPathArn))
            .setter(setter(Builder::networkInsightsPathArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathArn")
                    .unmarshallLocationName("networkInsightsPathArn").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(NetworkInsightsPath::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate")
                    .unmarshallLocationName("createdDate").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Source")
            .getter(getter(NetworkInsightsPath::source))
            .setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source")
                    .unmarshallLocationName("source").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Destination")
            .getter(getter(NetworkInsightsPath::destination))
            .setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination")
                    .unmarshallLocationName("destination").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceArn")
            .getter(getter(NetworkInsightsPath::sourceArn))
            .setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn")
                    .unmarshallLocationName("sourceArn").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationArn")
            .getter(getter(NetworkInsightsPath::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationArn")
                    .unmarshallLocationName("destinationArn").build()).build();

    private static final SdkField<String> SOURCE_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceIp")
            .getter(getter(NetworkInsightsPath::sourceIp))
            .setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp")
                    .unmarshallLocationName("sourceIp").build()).build();

    private static final SdkField<String> DESTINATION_IP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationIp")
            .getter(getter(NetworkInsightsPath::destinationIp))
            .setter(setter(Builder::destinationIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationIp")
                    .unmarshallLocationName("destinationIp").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Protocol")
            .getter(getter(NetworkInsightsPath::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol")
                    .unmarshallLocationName("protocol").build()).build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DestinationPort")
            .getter(getter(NetworkInsightsPath::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort")
                    .unmarshallLocationName("destinationPort").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(NetworkInsightsPath::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<PathFilter> FILTER_AT_SOURCE_FIELD = SdkField
            .<PathFilter> builder(MarshallingType.SDK_POJO)
            .memberName("FilterAtSource")
            .getter(getter(NetworkInsightsPath::filterAtSource))
            .setter(setter(Builder::filterAtSource))
            .constructor(PathFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAtSource")
                    .unmarshallLocationName("filterAtSource").build()).build();

    private static final SdkField<PathFilter> FILTER_AT_DESTINATION_FIELD = SdkField
            .<PathFilter> builder(MarshallingType.SDK_POJO)
            .memberName("FilterAtDestination")
            .getter(getter(NetworkInsightsPath::filterAtDestination))
            .setter(setter(Builder::filterAtDestination))
            .constructor(PathFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAtDestination")
                    .unmarshallLocationName("filterAtDestination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NETWORK_INSIGHTS_PATH_ID_FIELD, NETWORK_INSIGHTS_PATH_ARN_FIELD, CREATED_DATE_FIELD, SOURCE_FIELD, DESTINATION_FIELD,
            SOURCE_ARN_FIELD, DESTINATION_ARN_FIELD, SOURCE_IP_FIELD, DESTINATION_IP_FIELD, PROTOCOL_FIELD,
            DESTINATION_PORT_FIELD, TAGS_FIELD, FILTER_AT_SOURCE_FIELD, FILTER_AT_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkInsightsPathId;

    private final String networkInsightsPathArn;

    private final Instant createdDate;

    private final String source;

    private final String destination;

    private final String sourceArn;

    private final String destinationArn;

    private final String sourceIp;

    private final String destinationIp;

    private final String protocol;

    private final Integer destinationPort;

    private final List<Tag> tags;

    private final PathFilter filterAtSource;

    private final PathFilter filterAtDestination;

    private NetworkInsightsPath(BuilderImpl builder) {
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.networkInsightsPathArn = builder.networkInsightsPathArn;
        this.createdDate = builder.createdDate;
        this.source = builder.source;
        this.destination = builder.destination;
        this.sourceArn = builder.sourceArn;
        this.destinationArn = builder.destinationArn;
        this.sourceIp = builder.sourceIp;
        this.destinationIp = builder.destinationIp;
        this.protocol = builder.protocol;
        this.destinationPort = builder.destinationPort;
        this.tags = builder.tags;
        this.filterAtSource = builder.filterAtSource;
        this.filterAtDestination = builder.filterAtDestination;
    }

    /**
     * <p>
     * The ID of the path.
     * </p>
     * 
     * @return The ID of the path.
     */
    public final String networkInsightsPathId() {
        return networkInsightsPathId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the path.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the path.
     */
    public final String networkInsightsPathArn() {
        return networkInsightsPathArn;
    }

    /**
     * <p>
     * The time stamp when the path was created.
     * </p>
     * 
     * @return The time stamp when the path was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The ID of the source.
     * </p>
     * 
     * @return The ID of the source.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The ID of the destination.
     * </p>
     * 
     * @return The ID of the destination.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The IP address of the source.
     * </p>
     * 
     * @return The IP address of the source.
     */
    public final String sourceIp() {
        return sourceIp;
    }

    /**
     * <p>
     * The IP address of the destination.
     * </p>
     * 
     * @return The IP address of the destination.
     */
    public final String destinationIp() {
        return destinationIp;
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see Protocol
     */
    public final Protocol protocol() {
        return Protocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link Protocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol.
     * @see Protocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The destination port.
     * </p>
     * 
     * @return The destination port.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the path.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Scopes the analysis to network paths that match specific filters at the source.
     * </p>
     * 
     * @return Scopes the analysis to network paths that match specific filters at the source.
     */
    public final PathFilter filterAtSource() {
        return filterAtSource;
    }

    /**
     * <p>
     * Scopes the analysis to network paths that match specific filters at the destination.
     * </p>
     * 
     * @return Scopes the analysis to network paths that match specific filters at the destination.
     */
    public final PathFilter filterAtDestination() {
        return filterAtDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInsightsPathArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceIp());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIp());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterAtSource());
        hashCode = 31 * hashCode + Objects.hashCode(filterAtDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInsightsPath)) {
            return false;
        }
        NetworkInsightsPath other = (NetworkInsightsPath) obj;
        return Objects.equals(networkInsightsPathId(), other.networkInsightsPathId())
                && Objects.equals(networkInsightsPathArn(), other.networkInsightsPathArn())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(source(), other.source())
                && Objects.equals(destination(), other.destination()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(sourceIp(), other.sourceIp())
                && Objects.equals(destinationIp(), other.destinationIp())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(destinationPort(), other.destinationPort()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(filterAtSource(), other.filterAtSource())
                && Objects.equals(filterAtDestination(), other.filterAtDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInsightsPath").add("NetworkInsightsPathId", networkInsightsPathId())
                .add("NetworkInsightsPathArn", networkInsightsPathArn()).add("CreatedDate", createdDate())
                .add("Source", source()).add("Destination", destination()).add("SourceArn", sourceArn())
                .add("DestinationArn", destinationArn()).add("SourceIp", sourceIp()).add("DestinationIp", destinationIp())
                .add("Protocol", protocolAsString()).add("DestinationPort", destinationPort())
                .add("Tags", hasTags() ? tags() : null).add("FilterAtSource", filterAtSource())
                .add("FilterAtDestination", filterAtDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInsightsPathId":
            return Optional.ofNullable(clazz.cast(networkInsightsPathId()));
        case "NetworkInsightsPathArn":
            return Optional.ofNullable(clazz.cast(networkInsightsPathArn()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "SourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "DestinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIp()));
        case "DestinationIp":
            return Optional.ofNullable(clazz.cast(destinationIp()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "DestinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "FilterAtSource":
            return Optional.ofNullable(clazz.cast(filterAtSource()));
        case "FilterAtDestination":
            return Optional.ofNullable(clazz.cast(filterAtDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInsightsPath, T> g) {
        return obj -> g.apply((NetworkInsightsPath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInsightsPath> {
        /**
         * <p>
         * The ID of the path.
         * </p>
         * 
         * @param networkInsightsPathId
         *        The ID of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathId(String networkInsightsPathId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the path.
         * </p>
         * 
         * @param networkInsightsPathArn
         *        The Amazon Resource Name (ARN) of the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInsightsPathArn(String networkInsightsPathArn);

        /**
         * <p>
         * The time stamp when the path was created.
         * </p>
         * 
         * @param createdDate
         *        The time stamp when the path was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The ID of the source.
         * </p>
         * 
         * @param source
         *        The ID of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The ID of the destination.
         * </p>
         * 
         * @param destination
         *        The ID of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The IP address of the source.
         * </p>
         * 
         * @param sourceIp
         *        The IP address of the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIp(String sourceIp);

        /**
         * <p>
         * The IP address of the destination.
         * </p>
         * 
         * @param destinationIp
         *        The IP address of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIp(String destinationIp);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol.
         * </p>
         * 
         * @param protocol
         *        The protocol.
         * @see Protocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Protocol
         */
        Builder protocol(Protocol protocol);

        /**
         * <p>
         * The destination port.
         * </p>
         * 
         * @param destinationPort
         *        The destination port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The tags associated with the path.
         * </p>
         * 
         * @param tags
         *        The tags associated with the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the path.
         * </p>
         * 
         * @param tags
         *        The tags associated with the path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the path.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the source.
         * </p>
         * 
         * @param filterAtSource
         *        Scopes the analysis to network paths that match specific filters at the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAtSource(PathFilter filterAtSource);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathFilter.Builder} avoiding the need to
         * create one manually via {@link PathFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filterAtSource(PathFilter)}.
         * 
         * @param filterAtSource
         *        a consumer that will call methods on {@link PathFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAtSource(PathFilter)
         */
        default Builder filterAtSource(Consumer<PathFilter.Builder> filterAtSource) {
            return filterAtSource(PathFilter.builder().applyMutation(filterAtSource).build());
        }

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the destination.
         * </p>
         * 
         * @param filterAtDestination
         *        Scopes the analysis to network paths that match specific filters at the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterAtDestination(PathFilter filterAtDestination);

        /**
         * <p>
         * Scopes the analysis to network paths that match specific filters at the destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathFilter.Builder} avoiding the need to
         * create one manually via {@link PathFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #filterAtDestination(PathFilter)}.
         * 
         * @param filterAtDestination
         *        a consumer that will call methods on {@link PathFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterAtDestination(PathFilter)
         */
        default Builder filterAtDestination(Consumer<PathFilter.Builder> filterAtDestination) {
            return filterAtDestination(PathFilter.builder().applyMutation(filterAtDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String networkInsightsPathId;

        private String networkInsightsPathArn;

        private Instant createdDate;

        private String source;

        private String destination;

        private String sourceArn;

        private String destinationArn;

        private String sourceIp;

        private String destinationIp;

        private String protocol;

        private Integer destinationPort;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private PathFilter filterAtSource;

        private PathFilter filterAtDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInsightsPath model) {
            networkInsightsPathId(model.networkInsightsPathId);
            networkInsightsPathArn(model.networkInsightsPathArn);
            createdDate(model.createdDate);
            source(model.source);
            destination(model.destination);
            sourceArn(model.sourceArn);
            destinationArn(model.destinationArn);
            sourceIp(model.sourceIp);
            destinationIp(model.destinationIp);
            protocol(model.protocol);
            destinationPort(model.destinationPort);
            tags(model.tags);
            filterAtSource(model.filterAtSource);
            filterAtDestination(model.filterAtDestination);
        }

        public final String getNetworkInsightsPathId() {
            return networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final String getNetworkInsightsPathArn() {
            return networkInsightsPathArn;
        }

        public final void setNetworkInsightsPathArn(String networkInsightsPathArn) {
            this.networkInsightsPathArn = networkInsightsPathArn;
        }

        @Override
        public final Builder networkInsightsPathArn(String networkInsightsPathArn) {
            this.networkInsightsPathArn = networkInsightsPathArn;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        public final String getDestinationIp() {
            return destinationIp;
        }

        public final void setDestinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
        }

        @Override
        public final Builder destinationIp(String destinationIp) {
            this.destinationIp = destinationIp;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final PathFilter.Builder getFilterAtSource() {
            return filterAtSource != null ? filterAtSource.toBuilder() : null;
        }

        public final void setFilterAtSource(PathFilter.BuilderImpl filterAtSource) {
            this.filterAtSource = filterAtSource != null ? filterAtSource.build() : null;
        }

        @Override
        public final Builder filterAtSource(PathFilter filterAtSource) {
            this.filterAtSource = filterAtSource;
            return this;
        }

        public final PathFilter.Builder getFilterAtDestination() {
            return filterAtDestination != null ? filterAtDestination.toBuilder() : null;
        }

        public final void setFilterAtDestination(PathFilter.BuilderImpl filterAtDestination) {
            this.filterAtDestination = filterAtDestination != null ? filterAtDestination.build() : null;
        }

        @Override
        public final Builder filterAtDestination(PathFilter filterAtDestination) {
            this.filterAtDestination = filterAtDestination;
            return this;
        }

        @Override
        public NetworkInsightsPath build() {
            return new NetworkInsightsPath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
