/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHostReservationOfferingsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeHostReservationOfferingsResponse.Builder, DescribeHostReservationOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeHostReservationOfferingsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<HostOffering>> OFFERING_SET_FIELD = SdkField
            .<List<HostOffering>> builder(MarshallingType.LIST)
            .memberName("OfferingSet")
            .getter(getter(DescribeHostReservationOfferingsResponse::offeringSet))
            .setter(setter(Builder::offeringSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingSet")
                    .unmarshallLocationName("offeringSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<HostOffering> builder(MarshallingType.SDK_POJO)
                                            .constructor(HostOffering::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            OFFERING_SET_FIELD));

    private final String nextToken;

    private final List<HostOffering> offeringSet;

    private DescribeHostReservationOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.offeringSet = builder.offeringSet;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OfferingSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOfferingSet() {
        return offeringSet != null && !(offeringSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the offerings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOfferingSet} method.
     * </p>
     * 
     * @return Information about the offerings.
     */
    public final List<HostOffering> offeringSet() {
        return offeringSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOfferingSet() ? offeringSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsResponse)) {
            return false;
        }
        DescribeHostReservationOfferingsResponse other = (DescribeHostReservationOfferingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasOfferingSet() == other.hasOfferingSet()
                && Objects.equals(offeringSet(), other.offeringSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHostReservationOfferingsResponse").add("NextToken", nextToken())
                .add("OfferingSet", hasOfferingSet() ? offeringSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OfferingSet":
            return Optional.ofNullable(clazz.cast(offeringSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostReservationOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeHostReservationOfferingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the offerings.
         * </p>
         * 
         * @param offeringSet
         *        Information about the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringSet(Collection<HostOffering> offeringSet);

        /**
         * <p>
         * Information about the offerings.
         * </p>
         * 
         * @param offeringSet
         *        Information about the offerings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringSet(HostOffering... offeringSet);

        /**
         * <p>
         * Information about the offerings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.HostOffering.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.HostOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.HostOffering.Builder#build()} is called immediately and its
         * result is passed to {@link #offeringSet(List<HostOffering>)}.
         * 
         * @param offeringSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.HostOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offeringSet(java.util.Collection<HostOffering>)
         */
        Builder offeringSet(Consumer<HostOffering.Builder>... offeringSet);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<HostOffering> offeringSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            offeringSet(model.offeringSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HostOffering.Builder> getOfferingSet() {
            List<HostOffering.Builder> result = HostOfferingSetCopier.copyToBuilder(this.offeringSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOfferingSet(Collection<HostOffering.BuilderImpl> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copyFromBuilder(offeringSet);
        }

        @Override
        public final Builder offeringSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(HostOffering... offeringSet) {
            offeringSet(Arrays.asList(offeringSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(Consumer<HostOffering.Builder>... offeringSet) {
            offeringSet(Stream.of(offeringSet).map(c -> HostOffering.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeHostReservationOfferingsResponse build() {
            return new DescribeHostReservationOfferingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
