/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template version that could not be deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLaunchTemplateVersionsResponseErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteLaunchTemplateVersionsResponseErrorItem.Builder, DeleteLaunchTemplateVersionsResponseErrorItem> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LaunchTemplateId")
            .getter(getter(DeleteLaunchTemplateVersionsResponseErrorItem::launchTemplateId))
            .setter(setter(Builder::launchTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId")
                    .unmarshallLocationName("launchTemplateId").build()).build();

    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LaunchTemplateName")
            .getter(getter(DeleteLaunchTemplateVersionsResponseErrorItem::launchTemplateName))
            .setter(setter(Builder::launchTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName")
                    .unmarshallLocationName("launchTemplateName").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber")
            .getter(getter(DeleteLaunchTemplateVersionsResponseErrorItem::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionNumber")
                    .unmarshallLocationName("versionNumber").build()).build();

    private static final SdkField<ResponseError> RESPONSE_ERROR_FIELD = SdkField
            .<ResponseError> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseError")
            .getter(getter(DeleteLaunchTemplateVersionsResponseErrorItem::responseError))
            .setter(setter(Builder::responseError))
            .constructor(ResponseError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseError")
                    .unmarshallLocationName("responseError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD,
            LAUNCH_TEMPLATE_NAME_FIELD, VERSION_NUMBER_FIELD, RESPONSE_ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchTemplateId;

    private final String launchTemplateName;

    private final Long versionNumber;

    private final ResponseError responseError;

    private DeleteLaunchTemplateVersionsResponseErrorItem(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionNumber = builder.versionNumber;
        this.responseError = builder.responseError;
    }

    /**
     * <p>
     * The ID of the launch template.
     * </p>
     * 
     * @return The ID of the launch template.
     */
    public final String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template.
     * </p>
     * 
     * @return The name of the launch template.
     */
    public final String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version number of the launch template.
     * </p>
     * 
     * @return The version number of the launch template.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * Information about the error.
     * </p>
     * 
     * @return Information about the error.
     */
    public final ResponseError responseError() {
        return responseError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(responseError());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateVersionsResponseErrorItem)) {
            return false;
        }
        DeleteLaunchTemplateVersionsResponseErrorItem other = (DeleteLaunchTemplateVersionsResponseErrorItem) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName())
                && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(responseError(), other.responseError());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteLaunchTemplateVersionsResponseErrorItem").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("VersionNumber", versionNumber())
                .add("ResponseError", responseError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "ResponseError":
            return Optional.ofNullable(clazz.cast(responseError()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLaunchTemplateVersionsResponseErrorItem, T> g) {
        return obj -> g.apply((DeleteLaunchTemplateVersionsResponseErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponseErrorItem> {
        /**
         * <p>
         * The ID of the launch template.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version number of the launch template.
         * </p>
         * 
         * @param versionNumber
         *        The version number of the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * Information about the error.
         * </p>
         * 
         * @param responseError
         *        Information about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseError(ResponseError responseError);

        /**
         * <p>
         * Information about the error.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseError.Builder} avoiding the need
         * to create one manually via {@link ResponseError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseError.Builder#build()} is called immediately and its
         * result is passed to {@link #responseError(ResponseError)}.
         * 
         * @param responseError
         *        a consumer that will call methods on {@link ResponseError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseError(ResponseError)
         */
        default Builder responseError(Consumer<ResponseError.Builder> responseError) {
            return responseError(ResponseError.builder().applyMutation(responseError).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private Long versionNumber;

        private ResponseError responseError;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateVersionsResponseErrorItem model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            versionNumber(model.versionNumber);
            responseError(model.responseError);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final ResponseError.Builder getResponseError() {
            return responseError != null ? responseError.toBuilder() : null;
        }

        public final void setResponseError(ResponseError.BuilderImpl responseError) {
            this.responseError = responseError != null ? responseError.build() : null;
        }

        @Override
        public final Builder responseError(ResponseError responseError) {
            this.responseError = responseError;
            return this;
        }

        @Override
        public DeleteLaunchTemplateVersionsResponseErrorItem build() {
            return new DeleteLaunchTemplateVersionsResponseErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
