/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamScope;
import software.amazon.awssdk.services.ec2.model.IpamScopeSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamScopesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamScopesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamScopesResponse.getter(DescribeIpamScopesResponse::nextToken)).setter(DescribeIpamScopesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamScope>> IPAM_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamScopes").getter(DescribeIpamScopesResponse.getter(DescribeIpamScopesResponse::ipamScopes)).setter(DescribeIpamScopesResponse.setter(Builder::ipamScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamScopeSet").unmarshallLocationName("ipamScopeSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_SCOPES_FIELD));
    private final String nextToken;
    private final List<IpamScope> ipamScopes;

    private DescribeIpamScopesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamScopes = builder.ipamScopes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamScopes() {
        return this.ipamScopes != null && !(this.ipamScopes instanceof SdkAutoConstructList);
    }

    public final List<IpamScope> ipamScopes() {
        return this.ipamScopes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamScopes() ? this.ipamScopes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamScopesResponse)) {
            return false;
        }
        DescribeIpamScopesResponse other = (DescribeIpamScopesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamScopes() == other.hasIpamScopes() && Objects.equals(this.ipamScopes(), other.ipamScopes());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamScopesResponse").add("NextToken", (Object)this.nextToken()).add("IpamScopes", this.hasIpamScopes() ? this.ipamScopes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamScopes": {
                return Optional.ofNullable(clazz.cast(this.ipamScopes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamScopesResponse, T> g) {
        return obj -> g.apply((DescribeIpamScopesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamScope> ipamScopes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamScopesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamScopes(model.ipamScopes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamScope.Builder> getIpamScopes() {
            List<IpamScope.Builder> result = IpamScopeSetCopier.copyToBuilder(this.ipamScopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamScopes(Collection<IpamScope.BuilderImpl> ipamScopes) {
            this.ipamScopes = IpamScopeSetCopier.copyFromBuilder(ipamScopes);
        }

        @Override
        public final Builder ipamScopes(Collection<IpamScope> ipamScopes) {
            this.ipamScopes = IpamScopeSetCopier.copy(ipamScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamScopes(IpamScope ... ipamScopes) {
            this.ipamScopes(Arrays.asList(ipamScopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamScopes(Consumer<IpamScope.Builder> ... ipamScopes) {
            this.ipamScopes(Stream.of(ipamScopes).map(c -> (IpamScope)((IpamScope.Builder)IpamScope.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamScopesResponse build() {
            return new DescribeIpamScopesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamScopesResponse> {
        public Builder nextToken(String var1);

        public Builder ipamScopes(Collection<IpamScope> var1);

        public Builder ipamScopes(IpamScope ... var1);

        public Builder ipamScopes(Consumer<IpamScope.Builder> ... var1);
    }
}

