/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreSnapshotTierResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, RestoreSnapshotTierResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(RestoreSnapshotTierResponse.getter(RestoreSnapshotTierResponse::snapshotId)).setter(RestoreSnapshotTierResponse.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<Instant> RESTORE_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RestoreStartTime").getter(RestoreSnapshotTierResponse.getter(RestoreSnapshotTierResponse::restoreStartTime)).setter(RestoreSnapshotTierResponse.setter(Builder::restoreStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreStartTime").unmarshallLocationName("restoreStartTime").build()}).build();
    private static final SdkField<Integer> RESTORE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RestoreDuration").getter(RestoreSnapshotTierResponse.getter(RestoreSnapshotTierResponse::restoreDuration)).setter(RestoreSnapshotTierResponse.setter(Builder::restoreDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreDuration").unmarshallLocationName("restoreDuration").build()}).build();
    private static final SdkField<Boolean> IS_PERMANENT_RESTORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPermanentRestore").getter(RestoreSnapshotTierResponse.getter(RestoreSnapshotTierResponse::isPermanentRestore)).setter(RestoreSnapshotTierResponse.setter(Builder::isPermanentRestore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPermanentRestore").unmarshallLocationName("isPermanentRestore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, RESTORE_START_TIME_FIELD, RESTORE_DURATION_FIELD, IS_PERMANENT_RESTORE_FIELD));
    private final String snapshotId;
    private final Instant restoreStartTime;
    private final Integer restoreDuration;
    private final Boolean isPermanentRestore;

    private RestoreSnapshotTierResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.restoreStartTime = builder.restoreStartTime;
        this.restoreDuration = builder.restoreDuration;
        this.isPermanentRestore = builder.isPermanentRestore;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final Instant restoreStartTime() {
        return this.restoreStartTime;
    }

    public final Integer restoreDuration() {
        return this.restoreDuration;
    }

    public final Boolean isPermanentRestore() {
        return this.isPermanentRestore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPermanentRestore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSnapshotTierResponse)) {
            return false;
        }
        RestoreSnapshotTierResponse other = (RestoreSnapshotTierResponse)((Object)obj);
        return Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.restoreStartTime(), other.restoreStartTime()) && Objects.equals(this.restoreDuration(), other.restoreDuration()) && Objects.equals(this.isPermanentRestore(), other.isPermanentRestore());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreSnapshotTierResponse").add("SnapshotId", (Object)this.snapshotId()).add("RestoreStartTime", (Object)this.restoreStartTime()).add("RestoreDuration", (Object)this.restoreDuration()).add("IsPermanentRestore", (Object)this.isPermanentRestore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "RestoreStartTime": {
                return Optional.ofNullable(clazz.cast(this.restoreStartTime()));
            }
            case "RestoreDuration": {
                return Optional.ofNullable(clazz.cast(this.restoreDuration()));
            }
            case "IsPermanentRestore": {
                return Optional.ofNullable(clazz.cast(this.isPermanentRestore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreSnapshotTierResponse, T> g) {
        return obj -> g.apply((RestoreSnapshotTierResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String snapshotId;
        private Instant restoreStartTime;
        private Integer restoreDuration;
        private Boolean isPermanentRestore;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSnapshotTierResponse model) {
            super(model);
            this.snapshotId(model.snapshotId);
            this.restoreStartTime(model.restoreStartTime);
            this.restoreDuration(model.restoreDuration);
            this.isPermanentRestore(model.isPermanentRestore);
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Instant getRestoreStartTime() {
            return this.restoreStartTime;
        }

        public final void setRestoreStartTime(Instant restoreStartTime) {
            this.restoreStartTime = restoreStartTime;
        }

        @Override
        public final Builder restoreStartTime(Instant restoreStartTime) {
            this.restoreStartTime = restoreStartTime;
            return this;
        }

        public final Integer getRestoreDuration() {
            return this.restoreDuration;
        }

        public final void setRestoreDuration(Integer restoreDuration) {
            this.restoreDuration = restoreDuration;
        }

        @Override
        public final Builder restoreDuration(Integer restoreDuration) {
            this.restoreDuration = restoreDuration;
            return this;
        }

        public final Boolean getIsPermanentRestore() {
            return this.isPermanentRestore;
        }

        public final void setIsPermanentRestore(Boolean isPermanentRestore) {
            this.isPermanentRestore = isPermanentRestore;
        }

        @Override
        public final Builder isPermanentRestore(Boolean isPermanentRestore) {
            this.isPermanentRestore = isPermanentRestore;
            return this;
        }

        @Override
        public RestoreSnapshotTierResponse build() {
            return new RestoreSnapshotTierResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreSnapshotTierResponse> {
        public Builder snapshotId(String var1);

        public Builder restoreStartTime(Instant var1);

        public Builder restoreDuration(Integer var1);

        public Builder isPermanentRestore(Boolean var1);
    }
}

