/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpnTunnelOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpnTunnelOptionsRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(ModifyVpnTunnelOptionsRequest.getter(ModifyVpnTunnelOptionsRequest::vpnConnectionId)).setter(ModifyVpnTunnelOptionsRequest.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build()}).build();
    private static final SdkField<String> VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnTunnelOutsideIpAddress").getter(ModifyVpnTunnelOptionsRequest.getter(ModifyVpnTunnelOptionsRequest::vpnTunnelOutsideIpAddress)).setter(ModifyVpnTunnelOptionsRequest.setter(Builder::vpnTunnelOutsideIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnTunnelOutsideIpAddress").unmarshallLocationName("VpnTunnelOutsideIpAddress").build()}).build();
    private static final SdkField<ModifyVpnTunnelOptionsSpecification> TUNNEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TunnelOptions").getter(ModifyVpnTunnelOptionsRequest.getter(ModifyVpnTunnelOptionsRequest::tunnelOptions)).setter(ModifyVpnTunnelOptionsRequest.setter(Builder::tunnelOptions)).constructor(ModifyVpnTunnelOptionsSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions").unmarshallLocationName("TunnelOptions").build()}).build();
    private static final SdkField<Boolean> SKIP_TUNNEL_REPLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipTunnelReplacement").getter(ModifyVpnTunnelOptionsRequest.getter(ModifyVpnTunnelOptionsRequest::skipTunnelReplacement)).setter(ModifyVpnTunnelOptionsRequest.setter(Builder::skipTunnelReplacement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipTunnelReplacement").unmarshallLocationName("SkipTunnelReplacement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, VPN_TUNNEL_OUTSIDE_IP_ADDRESS_FIELD, TUNNEL_OPTIONS_FIELD, SKIP_TUNNEL_REPLACEMENT_FIELD));
    private final String vpnConnectionId;
    private final String vpnTunnelOutsideIpAddress;
    private final ModifyVpnTunnelOptionsSpecification tunnelOptions;
    private final Boolean skipTunnelReplacement;

    private ModifyVpnTunnelOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnTunnelOutsideIpAddress = builder.vpnTunnelOutsideIpAddress;
        this.tunnelOptions = builder.tunnelOptions;
        this.skipTunnelReplacement = builder.skipTunnelReplacement;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final String vpnTunnelOutsideIpAddress() {
        return this.vpnTunnelOutsideIpAddress;
    }

    public final ModifyVpnTunnelOptionsSpecification tunnelOptions() {
        return this.tunnelOptions;
    }

    public final Boolean skipTunnelReplacement() {
        return this.skipTunnelReplacement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnTunnelOutsideIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipTunnelReplacement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnTunnelOptionsRequest)) {
            return false;
        }
        ModifyVpnTunnelOptionsRequest other = (ModifyVpnTunnelOptionsRequest)((Object)obj);
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.vpnTunnelOutsideIpAddress(), other.vpnTunnelOutsideIpAddress()) && Objects.equals(this.tunnelOptions(), other.tunnelOptions()) && Objects.equals(this.skipTunnelReplacement(), other.skipTunnelReplacement());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpnTunnelOptionsRequest").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("VpnTunnelOutsideIpAddress", (Object)this.vpnTunnelOutsideIpAddress()).add("TunnelOptions", (Object)(this.tunnelOptions() == null ? null : "*** Sensitive Data Redacted ***")).add("SkipTunnelReplacement", (Object)this.skipTunnelReplacement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "VpnTunnelOutsideIpAddress": {
                return Optional.ofNullable(clazz.cast(this.vpnTunnelOutsideIpAddress()));
            }
            case "TunnelOptions": {
                return Optional.ofNullable(clazz.cast(this.tunnelOptions()));
            }
            case "SkipTunnelReplacement": {
                return Optional.ofNullable(clazz.cast(this.skipTunnelReplacement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnTunnelOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpnTunnelOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String vpnTunnelOutsideIpAddress;
        private ModifyVpnTunnelOptionsSpecification tunnelOptions;
        private Boolean skipTunnelReplacement;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnTunnelOptionsRequest model) {
            super(model);
            this.vpnConnectionId(model.vpnConnectionId);
            this.vpnTunnelOutsideIpAddress(model.vpnTunnelOutsideIpAddress);
            this.tunnelOptions(model.tunnelOptions);
            this.skipTunnelReplacement(model.skipTunnelReplacement);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getVpnTunnelOutsideIpAddress() {
            return this.vpnTunnelOutsideIpAddress;
        }

        public final void setVpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
        }

        @Override
        public final Builder vpnTunnelOutsideIpAddress(String vpnTunnelOutsideIpAddress) {
            this.vpnTunnelOutsideIpAddress = vpnTunnelOutsideIpAddress;
            return this;
        }

        public final ModifyVpnTunnelOptionsSpecification.Builder getTunnelOptions() {
            return this.tunnelOptions != null ? this.tunnelOptions.toBuilder() : null;
        }

        public final void setTunnelOptions(ModifyVpnTunnelOptionsSpecification.BuilderImpl tunnelOptions) {
            this.tunnelOptions = tunnelOptions != null ? tunnelOptions.build() : null;
        }

        @Override
        public final Builder tunnelOptions(ModifyVpnTunnelOptionsSpecification tunnelOptions) {
            this.tunnelOptions = tunnelOptions;
            return this;
        }

        public final Boolean getSkipTunnelReplacement() {
            return this.skipTunnelReplacement;
        }

        public final void setSkipTunnelReplacement(Boolean skipTunnelReplacement) {
            this.skipTunnelReplacement = skipTunnelReplacement;
        }

        @Override
        public final Builder skipTunnelReplacement(Boolean skipTunnelReplacement) {
            this.skipTunnelReplacement = skipTunnelReplacement;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnTunnelOptionsRequest build() {
            return new ModifyVpnTunnelOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpnTunnelOptionsRequest> {
        public Builder vpnConnectionId(String var1);

        public Builder vpnTunnelOutsideIpAddress(String var1);

        public Builder tunnelOptions(ModifyVpnTunnelOptionsSpecification var1);

        default public Builder tunnelOptions(Consumer<ModifyVpnTunnelOptionsSpecification.Builder> tunnelOptions) {
            return this.tunnelOptions((ModifyVpnTunnelOptionsSpecification)((ModifyVpnTunnelOptionsSpecification.Builder)ModifyVpnTunnelOptionsSpecification.builder().applyMutation(tunnelOptions)).build());
        }

        public Builder skipTunnelReplacement(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

