/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInsightsAnalysisIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNetworkInsightsAnalysesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeNetworkInsightsAnalysesRequest> {
    private static final SdkField<List<String>> NETWORK_INSIGHTS_ANALYSIS_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInsightsAnalysisIds").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::networkInsightsAnalysisIds)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::networkInsightsAnalysisIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAnalysisId").unmarshallLocationName("NetworkInsightsAnalysisId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsPathId").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::networkInsightsPathId)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::networkInsightsPathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsPathId").unmarshallLocationName("NetworkInsightsPathId").build()}).build();
    private static final SdkField<Instant> ANALYSIS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnalysisStartTime").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::analysisStartTime)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::analysisStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartTime").unmarshallLocationName("AnalysisStartTime").build()}).build();
    private static final SdkField<Instant> ANALYSIS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("AnalysisEndTime").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::analysisEndTime)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::analysisEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisEndTime").unmarshallLocationName("AnalysisEndTime").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::filters)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::maxResults)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeNetworkInsightsAnalysesRequest.getter(DescribeNetworkInsightsAnalysesRequest::nextToken)).setter(DescribeNetworkInsightsAnalysesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ANALYSIS_IDS_FIELD, NETWORK_INSIGHTS_PATH_ID_FIELD, ANALYSIS_START_TIME_FIELD, ANALYSIS_END_TIME_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> networkInsightsAnalysisIds;
    private final String networkInsightsPathId;
    private final Instant analysisStartTime;
    private final Instant analysisEndTime;
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeNetworkInsightsAnalysesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInsightsAnalysisIds = builder.networkInsightsAnalysisIds;
        this.networkInsightsPathId = builder.networkInsightsPathId;
        this.analysisStartTime = builder.analysisStartTime;
        this.analysisEndTime = builder.analysisEndTime;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInsightsAnalysisIds() {
        return this.networkInsightsAnalysisIds != null && !(this.networkInsightsAnalysisIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInsightsAnalysisIds() {
        return this.networkInsightsAnalysisIds;
    }

    public final String networkInsightsPathId() {
        return this.networkInsightsPathId;
    }

    public final Instant analysisStartTime() {
        return this.analysisStartTime;
    }

    public final Instant analysisEndTime() {
        return this.analysisEndTime;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInsightsAnalysisIds() ? this.networkInsightsAnalysisIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsPathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInsightsAnalysesRequest)) {
            return false;
        }
        DescribeNetworkInsightsAnalysesRequest other = (DescribeNetworkInsightsAnalysesRequest)((Object)obj);
        return this.hasNetworkInsightsAnalysisIds() == other.hasNetworkInsightsAnalysisIds() && Objects.equals(this.networkInsightsAnalysisIds(), other.networkInsightsAnalysisIds()) && Objects.equals(this.networkInsightsPathId(), other.networkInsightsPathId()) && Objects.equals(this.analysisStartTime(), other.analysisStartTime()) && Objects.equals(this.analysisEndTime(), other.analysisEndTime()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeNetworkInsightsAnalysesRequest").add("NetworkInsightsAnalysisIds", this.hasNetworkInsightsAnalysisIds() ? this.networkInsightsAnalysisIds() : null).add("NetworkInsightsPathId", (Object)this.networkInsightsPathId()).add("AnalysisStartTime", (Object)this.analysisStartTime()).add("AnalysisEndTime", (Object)this.analysisEndTime()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAnalysisIds": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAnalysisIds()));
            }
            case "NetworkInsightsPathId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsPathId()));
            }
            case "AnalysisStartTime": {
                return Optional.ofNullable(clazz.cast(this.analysisStartTime()));
            }
            case "AnalysisEndTime": {
                return Optional.ofNullable(clazz.cast(this.analysisEndTime()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeNetworkInsightsAnalysesRequest, T> g) {
        return obj -> g.apply((DescribeNetworkInsightsAnalysesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> networkInsightsAnalysisIds = DefaultSdkAutoConstructList.getInstance();
        private String networkInsightsPathId;
        private Instant analysisStartTime;
        private Instant analysisEndTime;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInsightsAnalysesRequest model) {
            super(model);
            this.networkInsightsAnalysisIds(model.networkInsightsAnalysisIds);
            this.networkInsightsPathId(model.networkInsightsPathId);
            this.analysisStartTime(model.analysisStartTime);
            this.analysisEndTime(model.analysisEndTime);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getNetworkInsightsAnalysisIds() {
            if (this.networkInsightsAnalysisIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInsightsAnalysisIds;
        }

        public final void setNetworkInsightsAnalysisIds(Collection<String> networkInsightsAnalysisIds) {
            this.networkInsightsAnalysisIds = NetworkInsightsAnalysisIdListCopier.copy(networkInsightsAnalysisIds);
        }

        @Override
        public final Builder networkInsightsAnalysisIds(Collection<String> networkInsightsAnalysisIds) {
            this.networkInsightsAnalysisIds = NetworkInsightsAnalysisIdListCopier.copy(networkInsightsAnalysisIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInsightsAnalysisIds(String ... networkInsightsAnalysisIds) {
            this.networkInsightsAnalysisIds(Arrays.asList(networkInsightsAnalysisIds));
            return this;
        }

        public final String getNetworkInsightsPathId() {
            return this.networkInsightsPathId;
        }

        public final void setNetworkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
        }

        @Override
        public final Builder networkInsightsPathId(String networkInsightsPathId) {
            this.networkInsightsPathId = networkInsightsPathId;
            return this;
        }

        public final Instant getAnalysisStartTime() {
            return this.analysisStartTime;
        }

        public final void setAnalysisStartTime(Instant analysisStartTime) {
            this.analysisStartTime = analysisStartTime;
        }

        @Override
        public final Builder analysisStartTime(Instant analysisStartTime) {
            this.analysisStartTime = analysisStartTime;
            return this;
        }

        public final Instant getAnalysisEndTime() {
            return this.analysisEndTime;
        }

        public final void setAnalysisEndTime(Instant analysisEndTime) {
            this.analysisEndTime = analysisEndTime;
        }

        @Override
        public final Builder analysisEndTime(Instant analysisEndTime) {
            this.analysisEndTime = analysisEndTime;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInsightsAnalysesRequest build() {
            return new DescribeNetworkInsightsAnalysesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeNetworkInsightsAnalysesRequest> {
        public Builder networkInsightsAnalysisIds(Collection<String> var1);

        public Builder networkInsightsAnalysisIds(String ... var1);

        public Builder networkInsightsPathId(String var1);

        public Builder analysisStartTime(Instant var1);

        public Builder analysisEndTime(Instant var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

