/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.BootModeType;
import software.amazon.awssdk.services.ec2.model.BootModeTypeListCopier;
import software.amazon.awssdk.services.ec2.model.EbsInfo;
import software.amazon.awssdk.services.ec2.model.FpgaInfo;
import software.amazon.awssdk.services.ec2.model.GpuInfo;
import software.amazon.awssdk.services.ec2.model.InferenceAcceleratorInfo;
import software.amazon.awssdk.services.ec2.model.InstanceStorageInfo;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor;
import software.amazon.awssdk.services.ec2.model.MemoryInfo;
import software.amazon.awssdk.services.ec2.model.NetworkInfo;
import software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport;
import software.amazon.awssdk.services.ec2.model.NitroTpmInfo;
import software.amazon.awssdk.services.ec2.model.NitroTpmSupport;
import software.amazon.awssdk.services.ec2.model.PlacementGroupInfo;
import software.amazon.awssdk.services.ec2.model.ProcessorInfo;
import software.amazon.awssdk.services.ec2.model.RootDeviceType;
import software.amazon.awssdk.services.ec2.model.RootDeviceTypeListCopier;
import software.amazon.awssdk.services.ec2.model.UsageClassType;
import software.amazon.awssdk.services.ec2.model.UsageClassTypeListCopier;
import software.amazon.awssdk.services.ec2.model.VCpuInfo;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.services.ec2.model.VirtualizationTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeInfo> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTypeInfo.getter(InstanceTypeInfo::instanceTypeAsString)).setter(InstanceTypeInfo.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CurrentGeneration").getter(InstanceTypeInfo.getter(InstanceTypeInfo::currentGeneration)).setter(InstanceTypeInfo.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").unmarshallLocationName("currentGeneration").build()}).build();
    private static final SdkField<Boolean> FREE_TIER_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FreeTierEligible").getter(InstanceTypeInfo.getter(InstanceTypeInfo::freeTierEligible)).setter(InstanceTypeInfo.setter(Builder::freeTierEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeTierEligible").unmarshallLocationName("freeTierEligible").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_USAGE_CLASSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedUsageClasses").getter(InstanceTypeInfo.getter(InstanceTypeInfo::supportedUsageClassesAsStrings)).setter(InstanceTypeInfo.setter(Builder::supportedUsageClassesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedUsageClasses").unmarshallLocationName("supportedUsageClasses").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_ROOT_DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedRootDeviceTypes").getter(InstanceTypeInfo.getter(InstanceTypeInfo::supportedRootDeviceTypesAsStrings)).setter(InstanceTypeInfo.setter(Builder::supportedRootDeviceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedRootDeviceTypes").unmarshallLocationName("supportedRootDeviceTypes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_VIRTUALIZATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedVirtualizationTypes").getter(InstanceTypeInfo.getter(InstanceTypeInfo::supportedVirtualizationTypesAsStrings)).setter(InstanceTypeInfo.setter(Builder::supportedVirtualizationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedVirtualizationTypes").unmarshallLocationName("supportedVirtualizationTypes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> BARE_METAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BareMetal").getter(InstanceTypeInfo.getter(InstanceTypeInfo::bareMetal)).setter(InstanceTypeInfo.setter(Builder::bareMetal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BareMetal").unmarshallLocationName("bareMetal").build()}).build();
    private static final SdkField<String> HYPERVISOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hypervisor").getter(InstanceTypeInfo.getter(InstanceTypeInfo::hypervisorAsString)).setter(InstanceTypeInfo.setter(Builder::hypervisor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").unmarshallLocationName("hypervisor").build()}).build();
    private static final SdkField<ProcessorInfo> PROCESSOR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProcessorInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::processorInfo)).setter(InstanceTypeInfo.setter(Builder::processorInfo)).constructor(ProcessorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorInfo").unmarshallLocationName("processorInfo").build()}).build();
    private static final SdkField<VCpuInfo> V_CPU_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VCpuInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::vCpuInfo)).setter(InstanceTypeInfo.setter(Builder::vCpuInfo)).constructor(VCpuInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpuInfo").unmarshallLocationName("vCpuInfo").build()}).build();
    private static final SdkField<MemoryInfo> MEMORY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemoryInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::memoryInfo)).setter(InstanceTypeInfo.setter(Builder::memoryInfo)).constructor(MemoryInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo").unmarshallLocationName("memoryInfo").build()}).build();
    private static final SdkField<Boolean> INSTANCE_STORAGE_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("InstanceStorageSupported").getter(InstanceTypeInfo.getter(InstanceTypeInfo::instanceStorageSupported)).setter(InstanceTypeInfo.setter(Builder::instanceStorageSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageSupported").unmarshallLocationName("instanceStorageSupported").build()}).build();
    private static final SdkField<InstanceStorageInfo> INSTANCE_STORAGE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceStorageInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::instanceStorageInfo)).setter(InstanceTypeInfo.setter(Builder::instanceStorageInfo)).constructor(InstanceStorageInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageInfo").unmarshallLocationName("instanceStorageInfo").build()}).build();
    private static final SdkField<EbsInfo> EBS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EbsInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::ebsInfo)).setter(InstanceTypeInfo.setter(Builder::ebsInfo)).constructor(EbsInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsInfo").unmarshallLocationName("ebsInfo").build()}).build();
    private static final SdkField<NetworkInfo> NETWORK_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::networkInfo)).setter(InstanceTypeInfo.setter(Builder::networkInfo)).constructor(NetworkInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInfo").unmarshallLocationName("networkInfo").build()}).build();
    private static final SdkField<GpuInfo> GPU_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GpuInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::gpuInfo)).setter(InstanceTypeInfo.setter(Builder::gpuInfo)).constructor(GpuInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GpuInfo").unmarshallLocationName("gpuInfo").build()}).build();
    private static final SdkField<FpgaInfo> FPGA_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FpgaInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::fpgaInfo)).setter(InstanceTypeInfo.setter(Builder::fpgaInfo)).constructor(FpgaInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FpgaInfo").unmarshallLocationName("fpgaInfo").build()}).build();
    private static final SdkField<PlacementGroupInfo> PLACEMENT_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlacementGroupInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::placementGroupInfo)).setter(InstanceTypeInfo.setter(Builder::placementGroupInfo)).constructor(PlacementGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroupInfo").unmarshallLocationName("placementGroupInfo").build()}).build();
    private static final SdkField<InferenceAcceleratorInfo> INFERENCE_ACCELERATOR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InferenceAcceleratorInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::inferenceAcceleratorInfo)).setter(InstanceTypeInfo.setter(Builder::inferenceAcceleratorInfo)).constructor(InferenceAcceleratorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceAcceleratorInfo").unmarshallLocationName("inferenceAcceleratorInfo").build()}).build();
    private static final SdkField<Boolean> HIBERNATION_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HibernationSupported").getter(InstanceTypeInfo.getter(InstanceTypeInfo::hibernationSupported)).setter(InstanceTypeInfo.setter(Builder::hibernationSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationSupported").unmarshallLocationName("hibernationSupported").build()}).build();
    private static final SdkField<Boolean> BURSTABLE_PERFORMANCE_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BurstablePerformanceSupported").getter(InstanceTypeInfo.getter(InstanceTypeInfo::burstablePerformanceSupported)).setter(InstanceTypeInfo.setter(Builder::burstablePerformanceSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurstablePerformanceSupported").unmarshallLocationName("burstablePerformanceSupported").build()}).build();
    private static final SdkField<Boolean> DEDICATED_HOSTS_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedHostsSupported").getter(InstanceTypeInfo.getter(InstanceTypeInfo::dedicatedHostsSupported)).setter(InstanceTypeInfo.setter(Builder::dedicatedHostsSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedHostsSupported").unmarshallLocationName("dedicatedHostsSupported").build()}).build();
    private static final SdkField<Boolean> AUTO_RECOVERY_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoRecoverySupported").getter(InstanceTypeInfo.getter(InstanceTypeInfo::autoRecoverySupported)).setter(InstanceTypeInfo.setter(Builder::autoRecoverySupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecoverySupported").unmarshallLocationName("autoRecoverySupported").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_BOOT_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedBootModes").getter(InstanceTypeInfo.getter(InstanceTypeInfo::supportedBootModesAsStrings)).setter(InstanceTypeInfo.setter(Builder::supportedBootModesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedBootModes").unmarshallLocationName("supportedBootModes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NITRO_ENCLAVES_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NitroEnclavesSupport").getter(InstanceTypeInfo.getter(InstanceTypeInfo::nitroEnclavesSupportAsString)).setter(InstanceTypeInfo.setter(Builder::nitroEnclavesSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NitroEnclavesSupport").unmarshallLocationName("nitroEnclavesSupport").build()}).build();
    private static final SdkField<String> NITRO_TPM_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NitroTpmSupport").getter(InstanceTypeInfo.getter(InstanceTypeInfo::nitroTpmSupportAsString)).setter(InstanceTypeInfo.setter(Builder::nitroTpmSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NitroTpmSupport").unmarshallLocationName("nitroTpmSupport").build()}).build();
    private static final SdkField<NitroTpmInfo> NITRO_TPM_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NitroTpmInfo").getter(InstanceTypeInfo.getter(InstanceTypeInfo::nitroTpmInfo)).setter(InstanceTypeInfo.setter(Builder::nitroTpmInfo)).constructor(NitroTpmInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NitroTpmInfo").unmarshallLocationName("nitroTpmInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, CURRENT_GENERATION_FIELD, FREE_TIER_ELIGIBLE_FIELD, SUPPORTED_USAGE_CLASSES_FIELD, SUPPORTED_ROOT_DEVICE_TYPES_FIELD, SUPPORTED_VIRTUALIZATION_TYPES_FIELD, BARE_METAL_FIELD, HYPERVISOR_FIELD, PROCESSOR_INFO_FIELD, V_CPU_INFO_FIELD, MEMORY_INFO_FIELD, INSTANCE_STORAGE_SUPPORTED_FIELD, INSTANCE_STORAGE_INFO_FIELD, EBS_INFO_FIELD, NETWORK_INFO_FIELD, GPU_INFO_FIELD, FPGA_INFO_FIELD, PLACEMENT_GROUP_INFO_FIELD, INFERENCE_ACCELERATOR_INFO_FIELD, HIBERNATION_SUPPORTED_FIELD, BURSTABLE_PERFORMANCE_SUPPORTED_FIELD, DEDICATED_HOSTS_SUPPORTED_FIELD, AUTO_RECOVERY_SUPPORTED_FIELD, SUPPORTED_BOOT_MODES_FIELD, NITRO_ENCLAVES_SUPPORT_FIELD, NITRO_TPM_SUPPORT_FIELD, NITRO_TPM_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Boolean currentGeneration;
    private final Boolean freeTierEligible;
    private final List<String> supportedUsageClasses;
    private final List<String> supportedRootDeviceTypes;
    private final List<String> supportedVirtualizationTypes;
    private final Boolean bareMetal;
    private final String hypervisor;
    private final ProcessorInfo processorInfo;
    private final VCpuInfo vCpuInfo;
    private final MemoryInfo memoryInfo;
    private final Boolean instanceStorageSupported;
    private final InstanceStorageInfo instanceStorageInfo;
    private final EbsInfo ebsInfo;
    private final NetworkInfo networkInfo;
    private final GpuInfo gpuInfo;
    private final FpgaInfo fpgaInfo;
    private final PlacementGroupInfo placementGroupInfo;
    private final InferenceAcceleratorInfo inferenceAcceleratorInfo;
    private final Boolean hibernationSupported;
    private final Boolean burstablePerformanceSupported;
    private final Boolean dedicatedHostsSupported;
    private final Boolean autoRecoverySupported;
    private final List<String> supportedBootModes;
    private final String nitroEnclavesSupport;
    private final String nitroTpmSupport;
    private final NitroTpmInfo nitroTpmInfo;

    private InstanceTypeInfo(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.currentGeneration = builder.currentGeneration;
        this.freeTierEligible = builder.freeTierEligible;
        this.supportedUsageClasses = builder.supportedUsageClasses;
        this.supportedRootDeviceTypes = builder.supportedRootDeviceTypes;
        this.supportedVirtualizationTypes = builder.supportedVirtualizationTypes;
        this.bareMetal = builder.bareMetal;
        this.hypervisor = builder.hypervisor;
        this.processorInfo = builder.processorInfo;
        this.vCpuInfo = builder.vCpuInfo;
        this.memoryInfo = builder.memoryInfo;
        this.instanceStorageSupported = builder.instanceStorageSupported;
        this.instanceStorageInfo = builder.instanceStorageInfo;
        this.ebsInfo = builder.ebsInfo;
        this.networkInfo = builder.networkInfo;
        this.gpuInfo = builder.gpuInfo;
        this.fpgaInfo = builder.fpgaInfo;
        this.placementGroupInfo = builder.placementGroupInfo;
        this.inferenceAcceleratorInfo = builder.inferenceAcceleratorInfo;
        this.hibernationSupported = builder.hibernationSupported;
        this.burstablePerformanceSupported = builder.burstablePerformanceSupported;
        this.dedicatedHostsSupported = builder.dedicatedHostsSupported;
        this.autoRecoverySupported = builder.autoRecoverySupported;
        this.supportedBootModes = builder.supportedBootModes;
        this.nitroEnclavesSupport = builder.nitroEnclavesSupport;
        this.nitroTpmSupport = builder.nitroTpmSupport;
        this.nitroTpmInfo = builder.nitroTpmInfo;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public final Boolean freeTierEligible() {
        return this.freeTierEligible;
    }

    public final List<UsageClassType> supportedUsageClasses() {
        return UsageClassTypeListCopier.copyStringToEnum(this.supportedUsageClasses);
    }

    public final boolean hasSupportedUsageClasses() {
        return this.supportedUsageClasses != null && !(this.supportedUsageClasses instanceof SdkAutoConstructList);
    }

    public final List<String> supportedUsageClassesAsStrings() {
        return this.supportedUsageClasses;
    }

    public final List<RootDeviceType> supportedRootDeviceTypes() {
        return RootDeviceTypeListCopier.copyStringToEnum(this.supportedRootDeviceTypes);
    }

    public final boolean hasSupportedRootDeviceTypes() {
        return this.supportedRootDeviceTypes != null && !(this.supportedRootDeviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedRootDeviceTypesAsStrings() {
        return this.supportedRootDeviceTypes;
    }

    public final List<VirtualizationType> supportedVirtualizationTypes() {
        return VirtualizationTypeListCopier.copyStringToEnum(this.supportedVirtualizationTypes);
    }

    public final boolean hasSupportedVirtualizationTypes() {
        return this.supportedVirtualizationTypes != null && !(this.supportedVirtualizationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedVirtualizationTypesAsStrings() {
        return this.supportedVirtualizationTypes;
    }

    public final Boolean bareMetal() {
        return this.bareMetal;
    }

    public final InstanceTypeHypervisor hypervisor() {
        return InstanceTypeHypervisor.fromValue(this.hypervisor);
    }

    public final String hypervisorAsString() {
        return this.hypervisor;
    }

    public final ProcessorInfo processorInfo() {
        return this.processorInfo;
    }

    public final VCpuInfo vCpuInfo() {
        return this.vCpuInfo;
    }

    public final MemoryInfo memoryInfo() {
        return this.memoryInfo;
    }

    public final Boolean instanceStorageSupported() {
        return this.instanceStorageSupported;
    }

    public final InstanceStorageInfo instanceStorageInfo() {
        return this.instanceStorageInfo;
    }

    public final EbsInfo ebsInfo() {
        return this.ebsInfo;
    }

    public final NetworkInfo networkInfo() {
        return this.networkInfo;
    }

    public final GpuInfo gpuInfo() {
        return this.gpuInfo;
    }

    public final FpgaInfo fpgaInfo() {
        return this.fpgaInfo;
    }

    public final PlacementGroupInfo placementGroupInfo() {
        return this.placementGroupInfo;
    }

    public final InferenceAcceleratorInfo inferenceAcceleratorInfo() {
        return this.inferenceAcceleratorInfo;
    }

    public final Boolean hibernationSupported() {
        return this.hibernationSupported;
    }

    public final Boolean burstablePerformanceSupported() {
        return this.burstablePerformanceSupported;
    }

    public final Boolean dedicatedHostsSupported() {
        return this.dedicatedHostsSupported;
    }

    public final Boolean autoRecoverySupported() {
        return this.autoRecoverySupported;
    }

    public final List<BootModeType> supportedBootModes() {
        return BootModeTypeListCopier.copyStringToEnum(this.supportedBootModes);
    }

    public final boolean hasSupportedBootModes() {
        return this.supportedBootModes != null && !(this.supportedBootModes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedBootModesAsStrings() {
        return this.supportedBootModes;
    }

    public final NitroEnclavesSupport nitroEnclavesSupport() {
        return NitroEnclavesSupport.fromValue(this.nitroEnclavesSupport);
    }

    public final String nitroEnclavesSupportAsString() {
        return this.nitroEnclavesSupport;
    }

    public final NitroTpmSupport nitroTpmSupport() {
        return NitroTpmSupport.fromValue(this.nitroTpmSupport);
    }

    public final String nitroTpmSupportAsString() {
        return this.nitroTpmSupport;
    }

    public final NitroTpmInfo nitroTpmInfo() {
        return this.nitroTpmInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTierEligible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedUsageClasses() ? this.supportedUsageClassesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedRootDeviceTypes() ? this.supportedRootDeviceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedVirtualizationTypes() ? this.supportedVirtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.bareMetal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStorageSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStorageInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.gpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceAcceleratorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.burstablePerformanceSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedHostsSupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRecoverySupported());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedBootModes() ? this.supportedBootModesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nitroEnclavesSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nitroTpmSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nitroTpmInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeInfo)) {
            return false;
        }
        InstanceTypeInfo other = (InstanceTypeInfo)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.freeTierEligible(), other.freeTierEligible()) && this.hasSupportedUsageClasses() == other.hasSupportedUsageClasses() && Objects.equals(this.supportedUsageClassesAsStrings(), other.supportedUsageClassesAsStrings()) && this.hasSupportedRootDeviceTypes() == other.hasSupportedRootDeviceTypes() && Objects.equals(this.supportedRootDeviceTypesAsStrings(), other.supportedRootDeviceTypesAsStrings()) && this.hasSupportedVirtualizationTypes() == other.hasSupportedVirtualizationTypes() && Objects.equals(this.supportedVirtualizationTypesAsStrings(), other.supportedVirtualizationTypesAsStrings()) && Objects.equals(this.bareMetal(), other.bareMetal()) && Objects.equals(this.hypervisorAsString(), other.hypervisorAsString()) && Objects.equals(this.processorInfo(), other.processorInfo()) && Objects.equals(this.vCpuInfo(), other.vCpuInfo()) && Objects.equals(this.memoryInfo(), other.memoryInfo()) && Objects.equals(this.instanceStorageSupported(), other.instanceStorageSupported()) && Objects.equals(this.instanceStorageInfo(), other.instanceStorageInfo()) && Objects.equals(this.ebsInfo(), other.ebsInfo()) && Objects.equals(this.networkInfo(), other.networkInfo()) && Objects.equals(this.gpuInfo(), other.gpuInfo()) && Objects.equals(this.fpgaInfo(), other.fpgaInfo()) && Objects.equals(this.placementGroupInfo(), other.placementGroupInfo()) && Objects.equals(this.inferenceAcceleratorInfo(), other.inferenceAcceleratorInfo()) && Objects.equals(this.hibernationSupported(), other.hibernationSupported()) && Objects.equals(this.burstablePerformanceSupported(), other.burstablePerformanceSupported()) && Objects.equals(this.dedicatedHostsSupported(), other.dedicatedHostsSupported()) && Objects.equals(this.autoRecoverySupported(), other.autoRecoverySupported()) && this.hasSupportedBootModes() == other.hasSupportedBootModes() && Objects.equals(this.supportedBootModesAsStrings(), other.supportedBootModesAsStrings()) && Objects.equals(this.nitroEnclavesSupportAsString(), other.nitroEnclavesSupportAsString()) && Objects.equals(this.nitroTpmSupportAsString(), other.nitroTpmSupportAsString()) && Objects.equals(this.nitroTpmInfo(), other.nitroTpmInfo());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTypeInfo").add("InstanceType", (Object)this.instanceTypeAsString()).add("CurrentGeneration", (Object)this.currentGeneration()).add("FreeTierEligible", (Object)this.freeTierEligible()).add("SupportedUsageClasses", this.hasSupportedUsageClasses() ? this.supportedUsageClassesAsStrings() : null).add("SupportedRootDeviceTypes", this.hasSupportedRootDeviceTypes() ? this.supportedRootDeviceTypesAsStrings() : null).add("SupportedVirtualizationTypes", this.hasSupportedVirtualizationTypes() ? this.supportedVirtualizationTypesAsStrings() : null).add("BareMetal", (Object)this.bareMetal()).add("Hypervisor", (Object)this.hypervisorAsString()).add("ProcessorInfo", (Object)this.processorInfo()).add("VCpuInfo", (Object)this.vCpuInfo()).add("MemoryInfo", (Object)this.memoryInfo()).add("InstanceStorageSupported", (Object)this.instanceStorageSupported()).add("InstanceStorageInfo", (Object)this.instanceStorageInfo()).add("EbsInfo", (Object)this.ebsInfo()).add("NetworkInfo", (Object)this.networkInfo()).add("GpuInfo", (Object)this.gpuInfo()).add("FpgaInfo", (Object)this.fpgaInfo()).add("PlacementGroupInfo", (Object)this.placementGroupInfo()).add("InferenceAcceleratorInfo", (Object)this.inferenceAcceleratorInfo()).add("HibernationSupported", (Object)this.hibernationSupported()).add("BurstablePerformanceSupported", (Object)this.burstablePerformanceSupported()).add("DedicatedHostsSupported", (Object)this.dedicatedHostsSupported()).add("AutoRecoverySupported", (Object)this.autoRecoverySupported()).add("SupportedBootModes", this.hasSupportedBootModes() ? this.supportedBootModesAsStrings() : null).add("NitroEnclavesSupport", (Object)this.nitroEnclavesSupportAsString()).add("NitroTpmSupport", (Object)this.nitroTpmSupportAsString()).add("NitroTpmInfo", (Object)this.nitroTpmInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "FreeTierEligible": {
                return Optional.ofNullable(clazz.cast(this.freeTierEligible()));
            }
            case "SupportedUsageClasses": {
                return Optional.ofNullable(clazz.cast(this.supportedUsageClassesAsStrings()));
            }
            case "SupportedRootDeviceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedRootDeviceTypesAsStrings()));
            }
            case "SupportedVirtualizationTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedVirtualizationTypesAsStrings()));
            }
            case "BareMetal": {
                return Optional.ofNullable(clazz.cast(this.bareMetal()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisorAsString()));
            }
            case "ProcessorInfo": {
                return Optional.ofNullable(clazz.cast(this.processorInfo()));
            }
            case "VCpuInfo": {
                return Optional.ofNullable(clazz.cast(this.vCpuInfo()));
            }
            case "MemoryInfo": {
                return Optional.ofNullable(clazz.cast(this.memoryInfo()));
            }
            case "InstanceStorageSupported": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageSupported()));
            }
            case "InstanceStorageInfo": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageInfo()));
            }
            case "EbsInfo": {
                return Optional.ofNullable(clazz.cast(this.ebsInfo()));
            }
            case "NetworkInfo": {
                return Optional.ofNullable(clazz.cast(this.networkInfo()));
            }
            case "GpuInfo": {
                return Optional.ofNullable(clazz.cast(this.gpuInfo()));
            }
            case "FpgaInfo": {
                return Optional.ofNullable(clazz.cast(this.fpgaInfo()));
            }
            case "PlacementGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.placementGroupInfo()));
            }
            case "InferenceAcceleratorInfo": {
                return Optional.ofNullable(clazz.cast(this.inferenceAcceleratorInfo()));
            }
            case "HibernationSupported": {
                return Optional.ofNullable(clazz.cast(this.hibernationSupported()));
            }
            case "BurstablePerformanceSupported": {
                return Optional.ofNullable(clazz.cast(this.burstablePerformanceSupported()));
            }
            case "DedicatedHostsSupported": {
                return Optional.ofNullable(clazz.cast(this.dedicatedHostsSupported()));
            }
            case "AutoRecoverySupported": {
                return Optional.ofNullable(clazz.cast(this.autoRecoverySupported()));
            }
            case "SupportedBootModes": {
                return Optional.ofNullable(clazz.cast(this.supportedBootModesAsStrings()));
            }
            case "NitroEnclavesSupport": {
                return Optional.ofNullable(clazz.cast(this.nitroEnclavesSupportAsString()));
            }
            case "NitroTpmSupport": {
                return Optional.ofNullable(clazz.cast(this.nitroTpmSupportAsString()));
            }
            case "NitroTpmInfo": {
                return Optional.ofNullable(clazz.cast(this.nitroTpmInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeInfo, T> g) {
        return obj -> g.apply((InstanceTypeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Boolean currentGeneration;
        private Boolean freeTierEligible;
        private List<String> supportedUsageClasses = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedRootDeviceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedVirtualizationTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean bareMetal;
        private String hypervisor;
        private ProcessorInfo processorInfo;
        private VCpuInfo vCpuInfo;
        private MemoryInfo memoryInfo;
        private Boolean instanceStorageSupported;
        private InstanceStorageInfo instanceStorageInfo;
        private EbsInfo ebsInfo;
        private NetworkInfo networkInfo;
        private GpuInfo gpuInfo;
        private FpgaInfo fpgaInfo;
        private PlacementGroupInfo placementGroupInfo;
        private InferenceAcceleratorInfo inferenceAcceleratorInfo;
        private Boolean hibernationSupported;
        private Boolean burstablePerformanceSupported;
        private Boolean dedicatedHostsSupported;
        private Boolean autoRecoverySupported;
        private List<String> supportedBootModes = DefaultSdkAutoConstructList.getInstance();
        private String nitroEnclavesSupport;
        private String nitroTpmSupport;
        private NitroTpmInfo nitroTpmInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeInfo model) {
            this.instanceType(model.instanceType);
            this.currentGeneration(model.currentGeneration);
            this.freeTierEligible(model.freeTierEligible);
            this.supportedUsageClassesWithStrings(model.supportedUsageClasses);
            this.supportedRootDeviceTypesWithStrings(model.supportedRootDeviceTypes);
            this.supportedVirtualizationTypesWithStrings(model.supportedVirtualizationTypes);
            this.bareMetal(model.bareMetal);
            this.hypervisor(model.hypervisor);
            this.processorInfo(model.processorInfo);
            this.vCpuInfo(model.vCpuInfo);
            this.memoryInfo(model.memoryInfo);
            this.instanceStorageSupported(model.instanceStorageSupported);
            this.instanceStorageInfo(model.instanceStorageInfo);
            this.ebsInfo(model.ebsInfo);
            this.networkInfo(model.networkInfo);
            this.gpuInfo(model.gpuInfo);
            this.fpgaInfo(model.fpgaInfo);
            this.placementGroupInfo(model.placementGroupInfo);
            this.inferenceAcceleratorInfo(model.inferenceAcceleratorInfo);
            this.hibernationSupported(model.hibernationSupported);
            this.burstablePerformanceSupported(model.burstablePerformanceSupported);
            this.dedicatedHostsSupported(model.dedicatedHostsSupported);
            this.autoRecoverySupported(model.autoRecoverySupported);
            this.supportedBootModesWithStrings(model.supportedBootModes);
            this.nitroEnclavesSupport(model.nitroEnclavesSupport);
            this.nitroTpmSupport(model.nitroTpmSupport);
            this.nitroTpmInfo(model.nitroTpmInfo);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final Boolean getFreeTierEligible() {
            return this.freeTierEligible;
        }

        public final void setFreeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
        }

        @Override
        public final Builder freeTierEligible(Boolean freeTierEligible) {
            this.freeTierEligible = freeTierEligible;
            return this;
        }

        public final Collection<String> getSupportedUsageClasses() {
            if (this.supportedUsageClasses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedUsageClasses;
        }

        public final void setSupportedUsageClasses(Collection<String> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copy(supportedUsageClasses);
        }

        @Override
        public final Builder supportedUsageClassesWithStrings(Collection<String> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copy(supportedUsageClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUsageClassesWithStrings(String ... supportedUsageClasses) {
            this.supportedUsageClassesWithStrings(Arrays.asList(supportedUsageClasses));
            return this;
        }

        @Override
        public final Builder supportedUsageClasses(Collection<UsageClassType> supportedUsageClasses) {
            this.supportedUsageClasses = UsageClassTypeListCopier.copyEnumToString(supportedUsageClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedUsageClasses(UsageClassType ... supportedUsageClasses) {
            this.supportedUsageClasses(Arrays.asList(supportedUsageClasses));
            return this;
        }

        public final Collection<String> getSupportedRootDeviceTypes() {
            if (this.supportedRootDeviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedRootDeviceTypes;
        }

        public final void setSupportedRootDeviceTypes(Collection<String> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copy(supportedRootDeviceTypes);
        }

        @Override
        public final Builder supportedRootDeviceTypesWithStrings(Collection<String> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copy(supportedRootDeviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRootDeviceTypesWithStrings(String ... supportedRootDeviceTypes) {
            this.supportedRootDeviceTypesWithStrings(Arrays.asList(supportedRootDeviceTypes));
            return this;
        }

        @Override
        public final Builder supportedRootDeviceTypes(Collection<RootDeviceType> supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes = RootDeviceTypeListCopier.copyEnumToString(supportedRootDeviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedRootDeviceTypes(RootDeviceType ... supportedRootDeviceTypes) {
            this.supportedRootDeviceTypes(Arrays.asList(supportedRootDeviceTypes));
            return this;
        }

        public final Collection<String> getSupportedVirtualizationTypes() {
            if (this.supportedVirtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedVirtualizationTypes;
        }

        public final void setSupportedVirtualizationTypes(Collection<String> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copy(supportedVirtualizationTypes);
        }

        @Override
        public final Builder supportedVirtualizationTypesWithStrings(Collection<String> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copy(supportedVirtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVirtualizationTypesWithStrings(String ... supportedVirtualizationTypes) {
            this.supportedVirtualizationTypesWithStrings(Arrays.asList(supportedVirtualizationTypes));
            return this;
        }

        @Override
        public final Builder supportedVirtualizationTypes(Collection<VirtualizationType> supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes = VirtualizationTypeListCopier.copyEnumToString(supportedVirtualizationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedVirtualizationTypes(VirtualizationType ... supportedVirtualizationTypes) {
            this.supportedVirtualizationTypes(Arrays.asList(supportedVirtualizationTypes));
            return this;
        }

        public final Boolean getBareMetal() {
            return this.bareMetal;
        }

        public final void setBareMetal(Boolean bareMetal) {
            this.bareMetal = bareMetal;
        }

        @Override
        public final Builder bareMetal(Boolean bareMetal) {
            this.bareMetal = bareMetal;
            return this;
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public final Builder hypervisor(InstanceTypeHypervisor hypervisor) {
            this.hypervisor(hypervisor == null ? null : hypervisor.toString());
            return this;
        }

        public final ProcessorInfo.Builder getProcessorInfo() {
            return this.processorInfo != null ? this.processorInfo.toBuilder() : null;
        }

        public final void setProcessorInfo(ProcessorInfo.BuilderImpl processorInfo) {
            this.processorInfo = processorInfo != null ? processorInfo.build() : null;
        }

        @Override
        public final Builder processorInfo(ProcessorInfo processorInfo) {
            this.processorInfo = processorInfo;
            return this;
        }

        public final VCpuInfo.Builder getVCpuInfo() {
            return this.vCpuInfo != null ? this.vCpuInfo.toBuilder() : null;
        }

        public final void setVCpuInfo(VCpuInfo.BuilderImpl vCpuInfo) {
            this.vCpuInfo = vCpuInfo != null ? vCpuInfo.build() : null;
        }

        @Override
        public final Builder vCpuInfo(VCpuInfo vCpuInfo) {
            this.vCpuInfo = vCpuInfo;
            return this;
        }

        public final MemoryInfo.Builder getMemoryInfo() {
            return this.memoryInfo != null ? this.memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(MemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(MemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        public final Boolean getInstanceStorageSupported() {
            return this.instanceStorageSupported;
        }

        public final void setInstanceStorageSupported(Boolean instanceStorageSupported) {
            this.instanceStorageSupported = instanceStorageSupported;
        }

        @Override
        public final Builder instanceStorageSupported(Boolean instanceStorageSupported) {
            this.instanceStorageSupported = instanceStorageSupported;
            return this;
        }

        public final InstanceStorageInfo.Builder getInstanceStorageInfo() {
            return this.instanceStorageInfo != null ? this.instanceStorageInfo.toBuilder() : null;
        }

        public final void setInstanceStorageInfo(InstanceStorageInfo.BuilderImpl instanceStorageInfo) {
            this.instanceStorageInfo = instanceStorageInfo != null ? instanceStorageInfo.build() : null;
        }

        @Override
        public final Builder instanceStorageInfo(InstanceStorageInfo instanceStorageInfo) {
            this.instanceStorageInfo = instanceStorageInfo;
            return this;
        }

        public final EbsInfo.Builder getEbsInfo() {
            return this.ebsInfo != null ? this.ebsInfo.toBuilder() : null;
        }

        public final void setEbsInfo(EbsInfo.BuilderImpl ebsInfo) {
            this.ebsInfo = ebsInfo != null ? ebsInfo.build() : null;
        }

        @Override
        public final Builder ebsInfo(EbsInfo ebsInfo) {
            this.ebsInfo = ebsInfo;
            return this;
        }

        public final NetworkInfo.Builder getNetworkInfo() {
            return this.networkInfo != null ? this.networkInfo.toBuilder() : null;
        }

        public final void setNetworkInfo(NetworkInfo.BuilderImpl networkInfo) {
            this.networkInfo = networkInfo != null ? networkInfo.build() : null;
        }

        @Override
        public final Builder networkInfo(NetworkInfo networkInfo) {
            this.networkInfo = networkInfo;
            return this;
        }

        public final GpuInfo.Builder getGpuInfo() {
            return this.gpuInfo != null ? this.gpuInfo.toBuilder() : null;
        }

        public final void setGpuInfo(GpuInfo.BuilderImpl gpuInfo) {
            this.gpuInfo = gpuInfo != null ? gpuInfo.build() : null;
        }

        @Override
        public final Builder gpuInfo(GpuInfo gpuInfo) {
            this.gpuInfo = gpuInfo;
            return this;
        }

        public final FpgaInfo.Builder getFpgaInfo() {
            return this.fpgaInfo != null ? this.fpgaInfo.toBuilder() : null;
        }

        public final void setFpgaInfo(FpgaInfo.BuilderImpl fpgaInfo) {
            this.fpgaInfo = fpgaInfo != null ? fpgaInfo.build() : null;
        }

        @Override
        public final Builder fpgaInfo(FpgaInfo fpgaInfo) {
            this.fpgaInfo = fpgaInfo;
            return this;
        }

        public final PlacementGroupInfo.Builder getPlacementGroupInfo() {
            return this.placementGroupInfo != null ? this.placementGroupInfo.toBuilder() : null;
        }

        public final void setPlacementGroupInfo(PlacementGroupInfo.BuilderImpl placementGroupInfo) {
            this.placementGroupInfo = placementGroupInfo != null ? placementGroupInfo.build() : null;
        }

        @Override
        public final Builder placementGroupInfo(PlacementGroupInfo placementGroupInfo) {
            this.placementGroupInfo = placementGroupInfo;
            return this;
        }

        public final InferenceAcceleratorInfo.Builder getInferenceAcceleratorInfo() {
            return this.inferenceAcceleratorInfo != null ? this.inferenceAcceleratorInfo.toBuilder() : null;
        }

        public final void setInferenceAcceleratorInfo(InferenceAcceleratorInfo.BuilderImpl inferenceAcceleratorInfo) {
            this.inferenceAcceleratorInfo = inferenceAcceleratorInfo != null ? inferenceAcceleratorInfo.build() : null;
        }

        @Override
        public final Builder inferenceAcceleratorInfo(InferenceAcceleratorInfo inferenceAcceleratorInfo) {
            this.inferenceAcceleratorInfo = inferenceAcceleratorInfo;
            return this;
        }

        public final Boolean getHibernationSupported() {
            return this.hibernationSupported;
        }

        public final void setHibernationSupported(Boolean hibernationSupported) {
            this.hibernationSupported = hibernationSupported;
        }

        @Override
        public final Builder hibernationSupported(Boolean hibernationSupported) {
            this.hibernationSupported = hibernationSupported;
            return this;
        }

        public final Boolean getBurstablePerformanceSupported() {
            return this.burstablePerformanceSupported;
        }

        public final void setBurstablePerformanceSupported(Boolean burstablePerformanceSupported) {
            this.burstablePerformanceSupported = burstablePerformanceSupported;
        }

        @Override
        public final Builder burstablePerformanceSupported(Boolean burstablePerformanceSupported) {
            this.burstablePerformanceSupported = burstablePerformanceSupported;
            return this;
        }

        public final Boolean getDedicatedHostsSupported() {
            return this.dedicatedHostsSupported;
        }

        public final void setDedicatedHostsSupported(Boolean dedicatedHostsSupported) {
            this.dedicatedHostsSupported = dedicatedHostsSupported;
        }

        @Override
        public final Builder dedicatedHostsSupported(Boolean dedicatedHostsSupported) {
            this.dedicatedHostsSupported = dedicatedHostsSupported;
            return this;
        }

        public final Boolean getAutoRecoverySupported() {
            return this.autoRecoverySupported;
        }

        public final void setAutoRecoverySupported(Boolean autoRecoverySupported) {
            this.autoRecoverySupported = autoRecoverySupported;
        }

        @Override
        public final Builder autoRecoverySupported(Boolean autoRecoverySupported) {
            this.autoRecoverySupported = autoRecoverySupported;
            return this;
        }

        public final Collection<String> getSupportedBootModes() {
            if (this.supportedBootModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedBootModes;
        }

        public final void setSupportedBootModes(Collection<String> supportedBootModes) {
            this.supportedBootModes = BootModeTypeListCopier.copy(supportedBootModes);
        }

        @Override
        public final Builder supportedBootModesWithStrings(Collection<String> supportedBootModes) {
            this.supportedBootModes = BootModeTypeListCopier.copy(supportedBootModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedBootModesWithStrings(String ... supportedBootModes) {
            this.supportedBootModesWithStrings(Arrays.asList(supportedBootModes));
            return this;
        }

        @Override
        public final Builder supportedBootModes(Collection<BootModeType> supportedBootModes) {
            this.supportedBootModes = BootModeTypeListCopier.copyEnumToString(supportedBootModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedBootModes(BootModeType ... supportedBootModes) {
            this.supportedBootModes(Arrays.asList(supportedBootModes));
            return this;
        }

        public final String getNitroEnclavesSupport() {
            return this.nitroEnclavesSupport;
        }

        public final void setNitroEnclavesSupport(String nitroEnclavesSupport) {
            this.nitroEnclavesSupport = nitroEnclavesSupport;
        }

        @Override
        public final Builder nitroEnclavesSupport(String nitroEnclavesSupport) {
            this.nitroEnclavesSupport = nitroEnclavesSupport;
            return this;
        }

        @Override
        public final Builder nitroEnclavesSupport(NitroEnclavesSupport nitroEnclavesSupport) {
            this.nitroEnclavesSupport(nitroEnclavesSupport == null ? null : nitroEnclavesSupport.toString());
            return this;
        }

        public final String getNitroTpmSupport() {
            return this.nitroTpmSupport;
        }

        public final void setNitroTpmSupport(String nitroTpmSupport) {
            this.nitroTpmSupport = nitroTpmSupport;
        }

        @Override
        public final Builder nitroTpmSupport(String nitroTpmSupport) {
            this.nitroTpmSupport = nitroTpmSupport;
            return this;
        }

        @Override
        public final Builder nitroTpmSupport(NitroTpmSupport nitroTpmSupport) {
            this.nitroTpmSupport(nitroTpmSupport == null ? null : nitroTpmSupport.toString());
            return this;
        }

        public final NitroTpmInfo.Builder getNitroTpmInfo() {
            return this.nitroTpmInfo != null ? this.nitroTpmInfo.toBuilder() : null;
        }

        public final void setNitroTpmInfo(NitroTpmInfo.BuilderImpl nitroTpmInfo) {
            this.nitroTpmInfo = nitroTpmInfo != null ? nitroTpmInfo.build() : null;
        }

        @Override
        public final Builder nitroTpmInfo(NitroTpmInfo nitroTpmInfo) {
            this.nitroTpmInfo = nitroTpmInfo;
            return this;
        }

        public InstanceTypeInfo build() {
            return new InstanceTypeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeInfo> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder currentGeneration(Boolean var1);

        public Builder freeTierEligible(Boolean var1);

        public Builder supportedUsageClassesWithStrings(Collection<String> var1);

        public Builder supportedUsageClassesWithStrings(String ... var1);

        public Builder supportedUsageClasses(Collection<UsageClassType> var1);

        public Builder supportedUsageClasses(UsageClassType ... var1);

        public Builder supportedRootDeviceTypesWithStrings(Collection<String> var1);

        public Builder supportedRootDeviceTypesWithStrings(String ... var1);

        public Builder supportedRootDeviceTypes(Collection<RootDeviceType> var1);

        public Builder supportedRootDeviceTypes(RootDeviceType ... var1);

        public Builder supportedVirtualizationTypesWithStrings(Collection<String> var1);

        public Builder supportedVirtualizationTypesWithStrings(String ... var1);

        public Builder supportedVirtualizationTypes(Collection<VirtualizationType> var1);

        public Builder supportedVirtualizationTypes(VirtualizationType ... var1);

        public Builder bareMetal(Boolean var1);

        public Builder hypervisor(String var1);

        public Builder hypervisor(InstanceTypeHypervisor var1);

        public Builder processorInfo(ProcessorInfo var1);

        default public Builder processorInfo(Consumer<ProcessorInfo.Builder> processorInfo) {
            return this.processorInfo((ProcessorInfo)((ProcessorInfo.Builder)ProcessorInfo.builder().applyMutation(processorInfo)).build());
        }

        public Builder vCpuInfo(VCpuInfo var1);

        default public Builder vCpuInfo(Consumer<VCpuInfo.Builder> vCpuInfo) {
            return this.vCpuInfo((VCpuInfo)((VCpuInfo.Builder)VCpuInfo.builder().applyMutation(vCpuInfo)).build());
        }

        public Builder memoryInfo(MemoryInfo var1);

        default public Builder memoryInfo(Consumer<MemoryInfo.Builder> memoryInfo) {
            return this.memoryInfo((MemoryInfo)((MemoryInfo.Builder)MemoryInfo.builder().applyMutation(memoryInfo)).build());
        }

        public Builder instanceStorageSupported(Boolean var1);

        public Builder instanceStorageInfo(InstanceStorageInfo var1);

        default public Builder instanceStorageInfo(Consumer<InstanceStorageInfo.Builder> instanceStorageInfo) {
            return this.instanceStorageInfo((InstanceStorageInfo)((InstanceStorageInfo.Builder)InstanceStorageInfo.builder().applyMutation(instanceStorageInfo)).build());
        }

        public Builder ebsInfo(EbsInfo var1);

        default public Builder ebsInfo(Consumer<EbsInfo.Builder> ebsInfo) {
            return this.ebsInfo((EbsInfo)((EbsInfo.Builder)EbsInfo.builder().applyMutation(ebsInfo)).build());
        }

        public Builder networkInfo(NetworkInfo var1);

        default public Builder networkInfo(Consumer<NetworkInfo.Builder> networkInfo) {
            return this.networkInfo((NetworkInfo)((NetworkInfo.Builder)NetworkInfo.builder().applyMutation(networkInfo)).build());
        }

        public Builder gpuInfo(GpuInfo var1);

        default public Builder gpuInfo(Consumer<GpuInfo.Builder> gpuInfo) {
            return this.gpuInfo((GpuInfo)((GpuInfo.Builder)GpuInfo.builder().applyMutation(gpuInfo)).build());
        }

        public Builder fpgaInfo(FpgaInfo var1);

        default public Builder fpgaInfo(Consumer<FpgaInfo.Builder> fpgaInfo) {
            return this.fpgaInfo((FpgaInfo)((FpgaInfo.Builder)FpgaInfo.builder().applyMutation(fpgaInfo)).build());
        }

        public Builder placementGroupInfo(PlacementGroupInfo var1);

        default public Builder placementGroupInfo(Consumer<PlacementGroupInfo.Builder> placementGroupInfo) {
            return this.placementGroupInfo((PlacementGroupInfo)((PlacementGroupInfo.Builder)PlacementGroupInfo.builder().applyMutation(placementGroupInfo)).build());
        }

        public Builder inferenceAcceleratorInfo(InferenceAcceleratorInfo var1);

        default public Builder inferenceAcceleratorInfo(Consumer<InferenceAcceleratorInfo.Builder> inferenceAcceleratorInfo) {
            return this.inferenceAcceleratorInfo((InferenceAcceleratorInfo)((InferenceAcceleratorInfo.Builder)InferenceAcceleratorInfo.builder().applyMutation(inferenceAcceleratorInfo)).build());
        }

        public Builder hibernationSupported(Boolean var1);

        public Builder burstablePerformanceSupported(Boolean var1);

        public Builder dedicatedHostsSupported(Boolean var1);

        public Builder autoRecoverySupported(Boolean var1);

        public Builder supportedBootModesWithStrings(Collection<String> var1);

        public Builder supportedBootModesWithStrings(String ... var1);

        public Builder supportedBootModes(Collection<BootModeType> var1);

        public Builder supportedBootModes(BootModeType ... var1);

        public Builder nitroEnclavesSupport(String var1);

        public Builder nitroEnclavesSupport(NitroEnclavesSupport var1);

        public Builder nitroTpmSupport(String var1);

        public Builder nitroTpmSupport(NitroTpmSupport var1);

        public Builder nitroTpmInfo(NitroTpmInfo var1);

        default public Builder nitroTpmInfo(Consumer<NitroTpmInfo.Builder> nitroTpmInfo) {
            return this.nitroTpmInfo((NitroTpmInfo)((NitroTpmInfo.Builder)NitroTpmInfo.builder().applyMutation(nitroTpmInfo)).build());
        }
    }
}

