/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConsoleScreenshotRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, GetConsoleScreenshotRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetConsoleScreenshotRequest.getter(GetConsoleScreenshotRequest::instanceId)).setter(GetConsoleScreenshotRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<Boolean> WAKE_UP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WakeUp").getter(GetConsoleScreenshotRequest.getter(GetConsoleScreenshotRequest::wakeUp)).setter(GetConsoleScreenshotRequest.setter(Builder::wakeUp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WakeUp").unmarshallLocationName("WakeUp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, WAKE_UP_FIELD));
    private final String instanceId;
    private final Boolean wakeUp;

    private GetConsoleScreenshotRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.wakeUp = builder.wakeUp;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Boolean wakeUp() {
        return this.wakeUp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wakeUp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleScreenshotRequest)) {
            return false;
        }
        GetConsoleScreenshotRequest other = (GetConsoleScreenshotRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.wakeUp(), other.wakeUp());
    }

    public final String toString() {
        return ToString.builder((String)"GetConsoleScreenshotRequest").add("InstanceId", (Object)this.instanceId()).add("WakeUp", (Object)this.wakeUp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "WakeUp": {
                return Optional.ofNullable(clazz.cast(this.wakeUp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetConsoleScreenshotRequest, T> g) {
        return obj -> g.apply((GetConsoleScreenshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceId;
        private Boolean wakeUp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleScreenshotRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.wakeUp(model.wakeUp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Boolean getWakeUp() {
            return this.wakeUp;
        }

        public final void setWakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
        }

        @Override
        public final Builder wakeUp(Boolean wakeUp) {
            this.wakeUp = wakeUp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetConsoleScreenshotRequest build() {
            return new GetConsoleScreenshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConsoleScreenshotRequest> {
        public Builder instanceId(String var1);

        public Builder wakeUp(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

