/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;

public class DescribeSpotInstanceRequestsIterable
implements SdkIterable<DescribeSpotInstanceRequestsResponse> {
    private final Ec2Client client;
    private final DescribeSpotInstanceRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSpotInstanceRequestsIterable(Ec2Client client, DescribeSpotInstanceRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSpotInstanceRequestsResponseFetcher();
    }

    public Iterator<DescribeSpotInstanceRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SpotInstanceRequest> spotInstanceRequests() {
        Function<DescribeSpotInstanceRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.spotInstanceRequests() != null) {
                return response.spotInstanceRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSpotInstanceRequestsResponseFetcher
    implements SyncPageFetcher<DescribeSpotInstanceRequestsResponse> {
        private DescribeSpotInstanceRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSpotInstanceRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSpotInstanceRequestsResponse nextPage(DescribeSpotInstanceRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSpotInstanceRequestsIterable.this.client.describeSpotInstanceRequests(DescribeSpotInstanceRequestsIterable.this.firstRequest);
            }
            return DescribeSpotInstanceRequestsIterable.this.client.describeSpotInstanceRequests((DescribeSpotInstanceRequestsRequest)((Object)DescribeSpotInstanceRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

