/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InsideCidrBlocksStringListCopier;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTransitGatewayConnectPeerRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateTransitGatewayConnectPeerRequest> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::transitGatewayAttachmentId)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("TransitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAddress").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::transitGatewayAddress)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::transitGatewayAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAddress").unmarshallLocationName("TransitGatewayAddress").build()}).build();
    private static final SdkField<String> PEER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerAddress").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::peerAddress)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::peerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerAddress").unmarshallLocationName("PeerAddress").build()}).build();
    private static final SdkField<TransitGatewayConnectRequestBgpOptions> BGP_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BgpOptions").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::bgpOptions)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::bgpOptions)).constructor(TransitGatewayConnectRequestBgpOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BgpOptions").unmarshallLocationName("BgpOptions").build()}).build();
    private static final SdkField<List<String>> INSIDE_CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsideCidrBlocks").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::insideCidrBlocks)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::insideCidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsideCidrBlocks").unmarshallLocationName("InsideCidrBlocks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateTransitGatewayConnectPeerRequest.getter(CreateTransitGatewayConnectPeerRequest::tagSpecifications)).setter(CreateTransitGatewayConnectPeerRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, TRANSIT_GATEWAY_ADDRESS_FIELD, PEER_ADDRESS_FIELD, BGP_OPTIONS_FIELD, INSIDE_CIDR_BLOCKS_FIELD, TAG_SPECIFICATIONS_FIELD));
    private final String transitGatewayAttachmentId;
    private final String transitGatewayAddress;
    private final String peerAddress;
    private final TransitGatewayConnectRequestBgpOptions bgpOptions;
    private final List<String> insideCidrBlocks;
    private final List<TagSpecification> tagSpecifications;

    private CreateTransitGatewayConnectPeerRequest(BuilderImpl builder) {
        super(builder);
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.transitGatewayAddress = builder.transitGatewayAddress;
        this.peerAddress = builder.peerAddress;
        this.bgpOptions = builder.bgpOptions;
        this.insideCidrBlocks = builder.insideCidrBlocks;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final String transitGatewayAddress() {
        return this.transitGatewayAddress;
    }

    public final String peerAddress() {
        return this.peerAddress;
    }

    public final TransitGatewayConnectRequestBgpOptions bgpOptions() {
        return this.bgpOptions;
    }

    public final boolean hasInsideCidrBlocks() {
        return this.insideCidrBlocks != null && !(this.insideCidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<String> insideCidrBlocks() {
        return this.insideCidrBlocks;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.bgpOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTransitGatewayConnectPeerRequest)) {
            return false;
        }
        CreateTransitGatewayConnectPeerRequest other = (CreateTransitGatewayConnectPeerRequest)((Object)obj);
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.transitGatewayAddress(), other.transitGatewayAddress()) && Objects.equals(this.peerAddress(), other.peerAddress()) && Objects.equals(this.bgpOptions(), other.bgpOptions()) && this.hasInsideCidrBlocks() == other.hasInsideCidrBlocks() && Objects.equals(this.insideCidrBlocks(), other.insideCidrBlocks()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTransitGatewayConnectPeerRequest").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("TransitGatewayAddress", (Object)this.transitGatewayAddress()).add("PeerAddress", (Object)this.peerAddress()).add("BgpOptions", (Object)this.bgpOptions()).add("InsideCidrBlocks", this.hasInsideCidrBlocks() ? this.insideCidrBlocks() : null).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "TransitGatewayAddress": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAddress()));
            }
            case "PeerAddress": {
                return Optional.ofNullable(clazz.cast(this.peerAddress()));
            }
            case "BgpOptions": {
                return Optional.ofNullable(clazz.cast(this.bgpOptions()));
            }
            case "InsideCidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.insideCidrBlocks()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTransitGatewayConnectPeerRequest, T> g) {
        return obj -> g.apply((CreateTransitGatewayConnectPeerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String transitGatewayAddress;
        private String peerAddress;
        private TransitGatewayConnectRequestBgpOptions bgpOptions;
        private List<String> insideCidrBlocks = DefaultSdkAutoConstructList.getInstance();
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTransitGatewayConnectPeerRequest model) {
            super(model);
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.transitGatewayAddress(model.transitGatewayAddress);
            this.peerAddress(model.peerAddress);
            this.bgpOptions(model.bgpOptions);
            this.insideCidrBlocks(model.insideCidrBlocks);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getTransitGatewayAddress() {
            return this.transitGatewayAddress;
        }

        public final void setTransitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
        }

        @Override
        public final Builder transitGatewayAddress(String transitGatewayAddress) {
            this.transitGatewayAddress = transitGatewayAddress;
            return this;
        }

        public final String getPeerAddress() {
            return this.peerAddress;
        }

        public final void setPeerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
        }

        @Override
        public final Builder peerAddress(String peerAddress) {
            this.peerAddress = peerAddress;
            return this;
        }

        public final TransitGatewayConnectRequestBgpOptions.Builder getBgpOptions() {
            return this.bgpOptions != null ? this.bgpOptions.toBuilder() : null;
        }

        public final void setBgpOptions(TransitGatewayConnectRequestBgpOptions.BuilderImpl bgpOptions) {
            this.bgpOptions = bgpOptions != null ? bgpOptions.build() : null;
        }

        @Override
        public final Builder bgpOptions(TransitGatewayConnectRequestBgpOptions bgpOptions) {
            this.bgpOptions = bgpOptions;
            return this;
        }

        public final Collection<String> getInsideCidrBlocks() {
            if (this.insideCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.insideCidrBlocks;
        }

        public final void setInsideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
        }

        @Override
        public final Builder insideCidrBlocks(Collection<String> insideCidrBlocks) {
            this.insideCidrBlocks = InsideCidrBlocksStringListCopier.copy(insideCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insideCidrBlocks(String ... insideCidrBlocks) {
            this.insideCidrBlocks(Arrays.asList(insideCidrBlocks));
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTransitGatewayConnectPeerRequest build() {
            return new CreateTransitGatewayConnectPeerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTransitGatewayConnectPeerRequest> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder transitGatewayAddress(String var1);

        public Builder peerAddress(String var1);

        public Builder bgpOptions(TransitGatewayConnectRequestBgpOptions var1);

        default public Builder bgpOptions(Consumer<TransitGatewayConnectRequestBgpOptions.Builder> bgpOptions) {
            return this.bgpOptions((TransitGatewayConnectRequestBgpOptions)((TransitGatewayConnectRequestBgpOptions.Builder)TransitGatewayConnectRequestBgpOptions.builder().applyMutation(bgpOptions)).build());
        }

        public Builder insideCidrBlocks(Collection<String> var1);

        public Builder insideCidrBlocks(String ... var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

