/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.PathComponent;
import software.amazon.awssdk.services.ec2.model.PathComponentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessScopeAnalysisFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessScopeAnalysisFinding> {
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeAnalysisId").getter(AccessScopeAnalysisFinding.getter(AccessScopeAnalysisFinding::networkInsightsAccessScopeAnalysisId)).setter(AccessScopeAnalysisFinding.setter(Builder::networkInsightsAccessScopeAnalysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeAnalysisId").unmarshallLocationName("networkInsightsAccessScopeAnalysisId").build()}).build();
    private static final SdkField<String> NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInsightsAccessScopeId").getter(AccessScopeAnalysisFinding.getter(AccessScopeAnalysisFinding::networkInsightsAccessScopeId)).setter(AccessScopeAnalysisFinding.setter(Builder::networkInsightsAccessScopeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInsightsAccessScopeId").unmarshallLocationName("networkInsightsAccessScopeId").build()}).build();
    private static final SdkField<String> FINDING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FindingId").getter(AccessScopeAnalysisFinding.getter(AccessScopeAnalysisFinding::findingId)).setter(AccessScopeAnalysisFinding.setter(Builder::findingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingId").unmarshallLocationName("findingId").build()}).build();
    private static final SdkField<List<PathComponent>> FINDING_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingComponents").getter(AccessScopeAnalysisFinding.getter(AccessScopeAnalysisFinding::findingComponents)).setter(AccessScopeAnalysisFinding.setter(Builder::findingComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingComponentSet").unmarshallLocationName("findingComponentSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSIGHTS_ACCESS_SCOPE_ANALYSIS_ID_FIELD, NETWORK_INSIGHTS_ACCESS_SCOPE_ID_FIELD, FINDING_ID_FIELD, FINDING_COMPONENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkInsightsAccessScopeAnalysisId;
    private final String networkInsightsAccessScopeId;
    private final String findingId;
    private final List<PathComponent> findingComponents;

    private AccessScopeAnalysisFinding(BuilderImpl builder) {
        this.networkInsightsAccessScopeAnalysisId = builder.networkInsightsAccessScopeAnalysisId;
        this.networkInsightsAccessScopeId = builder.networkInsightsAccessScopeId;
        this.findingId = builder.findingId;
        this.findingComponents = builder.findingComponents;
    }

    public final String networkInsightsAccessScopeAnalysisId() {
        return this.networkInsightsAccessScopeAnalysisId;
    }

    public final String networkInsightsAccessScopeId() {
        return this.networkInsightsAccessScopeId;
    }

    public final String findingId() {
        return this.findingId;
    }

    public final boolean hasFindingComponents() {
        return this.findingComponents != null && !(this.findingComponents instanceof SdkAutoConstructList);
    }

    public final List<PathComponent> findingComponents() {
        return this.findingComponents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeAnalysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInsightsAccessScopeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingComponents() ? this.findingComponents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopeAnalysisFinding)) {
            return false;
        }
        AccessScopeAnalysisFinding other = (AccessScopeAnalysisFinding)obj;
        return Objects.equals(this.networkInsightsAccessScopeAnalysisId(), other.networkInsightsAccessScopeAnalysisId()) && Objects.equals(this.networkInsightsAccessScopeId(), other.networkInsightsAccessScopeId()) && Objects.equals(this.findingId(), other.findingId()) && this.hasFindingComponents() == other.hasFindingComponents() && Objects.equals(this.findingComponents(), other.findingComponents());
    }

    public final String toString() {
        return ToString.builder((String)"AccessScopeAnalysisFinding").add("NetworkInsightsAccessScopeAnalysisId", (Object)this.networkInsightsAccessScopeAnalysisId()).add("NetworkInsightsAccessScopeId", (Object)this.networkInsightsAccessScopeId()).add("FindingId", (Object)this.findingId()).add("FindingComponents", this.hasFindingComponents() ? this.findingComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInsightsAccessScopeAnalysisId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeAnalysisId()));
            }
            case "NetworkInsightsAccessScopeId": {
                return Optional.ofNullable(clazz.cast(this.networkInsightsAccessScopeId()));
            }
            case "FindingId": {
                return Optional.ofNullable(clazz.cast(this.findingId()));
            }
            case "FindingComponents": {
                return Optional.ofNullable(clazz.cast(this.findingComponents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessScopeAnalysisFinding, T> g) {
        return obj -> g.apply((AccessScopeAnalysisFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInsightsAccessScopeAnalysisId;
        private String networkInsightsAccessScopeId;
        private String findingId;
        private List<PathComponent> findingComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScopeAnalysisFinding model) {
            this.networkInsightsAccessScopeAnalysisId(model.networkInsightsAccessScopeAnalysisId);
            this.networkInsightsAccessScopeId(model.networkInsightsAccessScopeId);
            this.findingId(model.findingId);
            this.findingComponents(model.findingComponents);
        }

        public final String getNetworkInsightsAccessScopeAnalysisId() {
            return this.networkInsightsAccessScopeAnalysisId;
        }

        public final void setNetworkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
        }

        @Override
        public final Builder networkInsightsAccessScopeAnalysisId(String networkInsightsAccessScopeAnalysisId) {
            this.networkInsightsAccessScopeAnalysisId = networkInsightsAccessScopeAnalysisId;
            return this;
        }

        public final String getNetworkInsightsAccessScopeId() {
            return this.networkInsightsAccessScopeId;
        }

        public final void setNetworkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
        }

        @Override
        public final Builder networkInsightsAccessScopeId(String networkInsightsAccessScopeId) {
            this.networkInsightsAccessScopeId = networkInsightsAccessScopeId;
            return this;
        }

        public final String getFindingId() {
            return this.findingId;
        }

        public final void setFindingId(String findingId) {
            this.findingId = findingId;
        }

        @Override
        public final Builder findingId(String findingId) {
            this.findingId = findingId;
            return this;
        }

        public final List<PathComponent.Builder> getFindingComponents() {
            List<PathComponent.Builder> result = PathComponentListCopier.copyToBuilder(this.findingComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingComponents(Collection<PathComponent.BuilderImpl> findingComponents) {
            this.findingComponents = PathComponentListCopier.copyFromBuilder(findingComponents);
        }

        @Override
        public final Builder findingComponents(Collection<PathComponent> findingComponents) {
            this.findingComponents = PathComponentListCopier.copy(findingComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingComponents(PathComponent ... findingComponents) {
            this.findingComponents(Arrays.asList(findingComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingComponents(Consumer<PathComponent.Builder> ... findingComponents) {
            this.findingComponents(Stream.of(findingComponents).map(c -> (PathComponent)((PathComponent.Builder)PathComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AccessScopeAnalysisFinding build() {
            return new AccessScopeAnalysisFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessScopeAnalysisFinding> {
        public Builder networkInsightsAccessScopeAnalysisId(String var1);

        public Builder networkInsightsAccessScopeId(String var1);

        public Builder findingId(String var1);

        public Builder findingComponents(Collection<PathComponent> var1);

        public Builder findingComponents(PathComponent ... var1);

        public Builder findingComponents(Consumer<PathComponent.Builder> ... var1);
    }
}

