/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes logging options for an Amazon Web Services Verified Access instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VerifiedAccessInstanceLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VerifiedAccessInstanceLoggingConfiguration.Builder, VerifiedAccessInstanceLoggingConfiguration> {
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessInstanceId")
            .getter(getter(VerifiedAccessInstanceLoggingConfiguration::verifiedAccessInstanceId))
            .setter(setter(Builder::verifiedAccessInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId")
                    .unmarshallLocationName("verifiedAccessInstanceId").build()).build();

    private static final SdkField<VerifiedAccessLogs> ACCESS_LOGS_FIELD = SdkField
            .<VerifiedAccessLogs> builder(MarshallingType.SDK_POJO)
            .memberName("AccessLogs")
            .getter(getter(VerifiedAccessInstanceLoggingConfiguration::accessLogs))
            .setter(setter(Builder::accessLogs))
            .constructor(VerifiedAccessLogs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogs")
                    .unmarshallLocationName("accessLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_INSTANCE_ID_FIELD, ACCESS_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String verifiedAccessInstanceId;

    private final VerifiedAccessLogs accessLogs;

    private VerifiedAccessInstanceLoggingConfiguration(BuilderImpl builder) {
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.accessLogs = builder.accessLogs;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access instance.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access instance.
     */
    public final String verifiedAccessInstanceId() {
        return verifiedAccessInstanceId;
    }

    /**
     * <p>
     * Details about the logging options.
     * </p>
     * 
     * @return Details about the logging options.
     */
    public final VerifiedAccessLogs accessLogs() {
        return accessLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(accessLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceLoggingConfiguration)) {
            return false;
        }
        VerifiedAccessInstanceLoggingConfiguration other = (VerifiedAccessInstanceLoggingConfiguration) obj;
        return Objects.equals(verifiedAccessInstanceId(), other.verifiedAccessInstanceId())
                && Objects.equals(accessLogs(), other.accessLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VerifiedAccessInstanceLoggingConfiguration")
                .add("VerifiedAccessInstanceId", verifiedAccessInstanceId()).add("AccessLogs", accessLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessInstanceId":
            return Optional.ofNullable(clazz.cast(verifiedAccessInstanceId()));
        case "AccessLogs":
            return Optional.ofNullable(clazz.cast(accessLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceLoggingConfiguration, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VerifiedAccessInstanceLoggingConfiguration> {
        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access instance.
         * </p>
         * 
         * @param verifiedAccessInstanceId
         *        The ID of the Amazon Web Services Verified Access instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessInstanceId(String verifiedAccessInstanceId);

        /**
         * <p>
         * Details about the logging options.
         * </p>
         * 
         * @param accessLogs
         *        Details about the logging options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogs(VerifiedAccessLogs accessLogs);

        /**
         * <p>
         * Details about the logging options.
         * </p>
         * This is a convenience method that creates an instance of the {@link VerifiedAccessLogs.Builder} avoiding the
         * need to create one manually via {@link VerifiedAccessLogs#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VerifiedAccessLogs.Builder#build()} is called immediately and its
         * result is passed to {@link #accessLogs(VerifiedAccessLogs)}.
         * 
         * @param accessLogs
         *        a consumer that will call methods on {@link VerifiedAccessLogs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessLogs(VerifiedAccessLogs)
         */
        default Builder accessLogs(Consumer<VerifiedAccessLogs.Builder> accessLogs) {
            return accessLogs(VerifiedAccessLogs.builder().applyMutation(accessLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String verifiedAccessInstanceId;

        private VerifiedAccessLogs accessLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceLoggingConfiguration model) {
            verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            accessLogs(model.accessLogs);
        }

        public final String getVerifiedAccessInstanceId() {
            return verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final VerifiedAccessLogs.Builder getAccessLogs() {
            return accessLogs != null ? accessLogs.toBuilder() : null;
        }

        public final void setAccessLogs(VerifiedAccessLogs.BuilderImpl accessLogs) {
            this.accessLogs = accessLogs != null ? accessLogs.build() : null;
        }

        @Override
        public final Builder accessLogs(VerifiedAccessLogs accessLogs) {
            this.accessLogs = accessLogs;
            return this;
        }

        @Override
        public VerifiedAccessInstanceLoggingConfiguration build() {
            return new VerifiedAccessInstanceLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
