/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a placement group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementGroup implements SdkPojo, Serializable, ToCopyableBuilder<PlacementGroup.Builder, PlacementGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupName")
            .getter(getter(PlacementGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName")
                    .unmarshallLocationName("groupName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("State")
            .getter(getter(PlacementGroup::stateAsString))
            .setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State")
                    .unmarshallLocationName("state").build()).build();

    private static final SdkField<String> STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Strategy")
            .getter(getter(PlacementGroup::strategyAsString))
            .setter(setter(Builder::strategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy")
                    .unmarshallLocationName("strategy").build()).build();

    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PartitionCount")
            .getter(getter(PlacementGroup::partitionCount))
            .setter(setter(Builder::partitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionCount")
                    .unmarshallLocationName("partitionCount").build()).build();

    private static final SdkField<String> GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupId")
            .getter(getter(PlacementGroup::groupId))
            .setter(setter(Builder::groupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId")
                    .unmarshallLocationName("groupId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(PlacementGroup::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupArn")
            .getter(getter(PlacementGroup::groupArn))
            .setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn")
                    .unmarshallLocationName("groupArn").build()).build();

    private static final SdkField<String> SPREAD_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SpreadLevel")
            .getter(getter(PlacementGroup::spreadLevelAsString))
            .setter(setter(Builder::spreadLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpreadLevel")
                    .unmarshallLocationName("spreadLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, STATE_FIELD,
            STRATEGY_FIELD, PARTITION_COUNT_FIELD, GROUP_ID_FIELD, TAGS_FIELD, GROUP_ARN_FIELD, SPREAD_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String state;

    private final String strategy;

    private final Integer partitionCount;

    private final String groupId;

    private final List<Tag> tags;

    private final String groupArn;

    private final String spreadLevel;

    private PlacementGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.state = builder.state;
        this.strategy = builder.strategy;
        this.partitionCount = builder.partitionCount;
        this.groupId = builder.groupId;
        this.tags = builder.tags;
        this.groupArn = builder.groupArn;
        this.spreadLevel = builder.spreadLevel;
    }

    /**
     * <p>
     * The name of the placement group.
     * </p>
     * 
     * @return The name of the placement group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The state of the placement group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the placement group.
     * @see PlacementGroupState
     */
    public final PlacementGroupState state() {
        return PlacementGroupState.fromValue(state);
    }

    /**
     * <p>
     * The state of the placement group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link PlacementGroupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the placement group.
     * @see PlacementGroupState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public final PlacementStrategy strategy() {
        return PlacementStrategy.fromValue(strategy);
    }

    /**
     * <p>
     * The placement strategy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strategy} will
     * return {@link PlacementStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #strategyAsString}.
     * </p>
     * 
     * @return The placement strategy.
     * @see PlacementStrategy
     */
    public final String strategyAsString() {
        return strategy;
    }

    /**
     * <p>
     * The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
     * </p>
     * 
     * @return The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
     */
    public final Integer partitionCount() {
        return partitionCount;
    }

    /**
     * <p>
     * The ID of the placement group.
     * </p>
     * 
     * @return The ID of the placement group.
     */
    public final String groupId() {
        return groupId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags applied to the placement group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags applied to the placement group.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the placement group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the placement group.
     */
    public final String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across hosts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spreadLevel} will
     * return {@link SpreadLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spreadLevelAsString}.
     * </p>
     * 
     * @return The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across
     *         hosts.
     * @see SpreadLevel
     */
    public final SpreadLevel spreadLevel() {
        return SpreadLevel.fromValue(spreadLevel);
    }

    /**
     * <p>
     * The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across hosts.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spreadLevel} will
     * return {@link SpreadLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #spreadLevelAsString}.
     * </p>
     * 
     * @return The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across
     *         hosts.
     * @see SpreadLevel
     */
    public final String spreadLevelAsString() {
        return spreadLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(groupId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(spreadLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroup)) {
            return false;
        }
        PlacementGroup other = (PlacementGroup) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(strategyAsString(), other.strategyAsString())
                && Objects.equals(partitionCount(), other.partitionCount()) && Objects.equals(groupId(), other.groupId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(groupArn(), other.groupArn())
                && Objects.equals(spreadLevelAsString(), other.spreadLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlacementGroup").add("GroupName", groupName()).add("State", stateAsString())
                .add("Strategy", strategyAsString()).add("PartitionCount", partitionCount()).add("GroupId", groupId())
                .add("Tags", hasTags() ? tags() : null).add("GroupArn", groupArn()).add("SpreadLevel", spreadLevelAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Strategy":
            return Optional.ofNullable(clazz.cast(strategyAsString()));
        case "PartitionCount":
            return Optional.ofNullable(clazz.cast(partitionCount()));
        case "GroupId":
            return Optional.ofNullable(clazz.cast(groupId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "SpreadLevel":
            return Optional.ofNullable(clazz.cast(spreadLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroup, T> g) {
        return obj -> g.apply((PlacementGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementGroup> {
        /**
         * <p>
         * The name of the placement group.
         * </p>
         * 
         * @param groupName
         *        The name of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the placement group.
         * </p>
         * 
         * @param state
         *        The state of the placement group.
         * @see PlacementGroupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementGroupState
         */
        Builder state(PlacementGroupState state);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(String strategy);

        /**
         * <p>
         * The placement strategy.
         * </p>
         * 
         * @param strategy
         *        The placement strategy.
         * @see PlacementStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlacementStrategy
         */
        Builder strategy(PlacementStrategy strategy);

        /**
         * <p>
         * The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
         * </p>
         * 
         * @param partitionCount
         *        The number of partitions. Valid only if <b>strategy</b> is set to <code>partition</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionCount(Integer partitionCount);

        /**
         * <p>
         * The ID of the placement group.
         * </p>
         * 
         * @param groupId
         *        The ID of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupId(String groupId);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * 
         * @param tags
         *        Any tags applied to the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * 
         * @param tags
         *        Any tags applied to the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags applied to the placement group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the placement group.
         * </p>
         * 
         * @param groupArn
         *        The Amazon Resource Name (ARN) of the placement group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across hosts.
         * </p>
         * 
         * @param spreadLevel
         *        The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across
         *        hosts.
         * @see SpreadLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpreadLevel
         */
        Builder spreadLevel(String spreadLevel);

        /**
         * <p>
         * The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across hosts.
         * </p>
         * 
         * @param spreadLevel
         *        The spread level for the placement group. <i>Only</i> Outpost placement groups can be spread across
         *        hosts.
         * @see SpreadLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpreadLevel
         */
        Builder spreadLevel(SpreadLevel spreadLevel);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String state;

        private String strategy;

        private Integer partitionCount;

        private String groupId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String groupArn;

        private String spreadLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroup model) {
            groupName(model.groupName);
            state(model.state);
            strategy(model.strategy);
            partitionCount(model.partitionCount);
            groupId(model.groupId);
            tags(model.tags);
            groupArn(model.groupArn);
            spreadLevel(model.spreadLevel);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(PlacementGroupState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStrategy() {
            return strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(PlacementStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getPartitionCount() {
            return partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final String getGroupId() {
            return groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getSpreadLevel() {
            return spreadLevel;
        }

        public final void setSpreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
        }

        @Override
        public final Builder spreadLevel(String spreadLevel) {
            this.spreadLevel = spreadLevel;
            return this;
        }

        @Override
        public final Builder spreadLevel(SpreadLevel spreadLevel) {
            this.spreadLevel(spreadLevel == null ? null : spreadLevel.toString());
            return this;
        }

        @Override
        public PlacementGroup build() {
            return new PlacementGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
