/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVpcEndpointServicePayerResponsibilityRequest extends Ec2Request
        implements
        ToCopyableBuilder<ModifyVpcEndpointServicePayerResponsibilityRequest.Builder, ModifyVpcEndpointServicePayerResponsibilityRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceId")
            .getter(getter(ModifyVpcEndpointServicePayerResponsibilityRequest::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId")
                    .unmarshallLocationName("ServiceId").build()).build();

    private static final SdkField<String> PAYER_RESPONSIBILITY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PayerResponsibility")
            .getter(getter(ModifyVpcEndpointServicePayerResponsibilityRequest::payerResponsibilityAsString))
            .setter(setter(Builder::payerResponsibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayerResponsibility")
                    .unmarshallLocationName("PayerResponsibility").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD,
            PAYER_RESPONSIBILITY_FIELD));

    private final String serviceId;

    private final String payerResponsibility;

    private ModifyVpcEndpointServicePayerResponsibilityRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.payerResponsibility = builder.payerResponsibility;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer
     * responsibility to the service owner, you cannot set it back to the endpoint owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payerResponsibility} will return {@link PayerResponsibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payerResponsibilityAsString}.
     * </p>
     * 
     * @return The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the
     *         payer responsibility to the service owner, you cannot set it back to the endpoint owner.
     * @see PayerResponsibility
     */
    public final PayerResponsibility payerResponsibility() {
        return PayerResponsibility.fromValue(payerResponsibility);
    }

    /**
     * <p>
     * The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the payer
     * responsibility to the service owner, you cannot set it back to the endpoint owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #payerResponsibility} will return {@link PayerResponsibility#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #payerResponsibilityAsString}.
     * </p>
     * 
     * @return The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the
     *         payer responsibility to the service owner, you cannot set it back to the endpoint owner.
     * @see PayerResponsibility
     */
    public final String payerResponsibilityAsString() {
        return payerResponsibility;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(payerResponsibilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePayerResponsibilityRequest)) {
            return false;
        }
        ModifyVpcEndpointServicePayerResponsibilityRequest other = (ModifyVpcEndpointServicePayerResponsibilityRequest) obj;
        return Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(payerResponsibilityAsString(), other.payerResponsibilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVpcEndpointServicePayerResponsibilityRequest").add("ServiceId", serviceId())
                .add("PayerResponsibility", payerResponsibilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "PayerResponsibility":
            return Optional.ofNullable(clazz.cast(payerResponsibilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePayerResponsibilityRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePayerResponsibilityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyVpcEndpointServicePayerResponsibilityRequest> {
        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the
         * payer responsibility to the service owner, you cannot set it back to the endpoint owner.
         * </p>
         * 
         * @param payerResponsibility
         *        The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set
         *        the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
         * @see PayerResponsibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayerResponsibility
         */
        Builder payerResponsibility(String payerResponsibility);

        /**
         * <p>
         * The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set the
         * payer responsibility to the service owner, you cannot set it back to the endpoint owner.
         * </p>
         * 
         * @param payerResponsibility
         *        The entity that is responsible for the endpoint costs. The default is the endpoint owner. If you set
         *        the payer responsibility to the service owner, you cannot set it back to the endpoint owner.
         * @see PayerResponsibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PayerResponsibility
         */
        Builder payerResponsibility(PayerResponsibility payerResponsibility);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String serviceId;

        private String payerResponsibility;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePayerResponsibilityRequest model) {
            super(model);
            serviceId(model.serviceId);
            payerResponsibility(model.payerResponsibility);
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getPayerResponsibility() {
            return payerResponsibility;
        }

        public final void setPayerResponsibility(String payerResponsibility) {
            this.payerResponsibility = payerResponsibility;
        }

        @Override
        public final Builder payerResponsibility(String payerResponsibility) {
            this.payerResponsibility = payerResponsibility;
            return this;
        }

        @Override
        public final Builder payerResponsibility(PayerResponsibility payerResponsibility) {
            this.payerResponsibility(payerResponsibility == null ? null : payerResponsibility.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePayerResponsibilityRequest build() {
            return new ModifyVpcEndpointServicePayerResponsibilityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
