/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest extends Ec2Request
        implements
        ToCopyableBuilder<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest.Builder, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest> {
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId")
            .getter(getter(DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .setter(setter(Builder::localGatewayRouteTableVirtualInterfaceGroupAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId")
                    .unmarshallLocationName("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOCAL_GATEWAY_ROUTE_TABLE_VIRTUAL_INTERFACE_GROUP_ASSOCIATION_ID_FIELD));

    private final String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

    private DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = builder.localGatewayRouteTableVirtualInterfaceGroupAssociationId;
    }

    /**
     * <p>
     * The ID of the local gateway route table virtual interface group association.
     * </p>
     * 
     * @return The ID of the local gateway route table virtual interface group association.
     */
    public final String localGatewayRouteTableVirtualInterfaceGroupAssociationId() {
        return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTableVirtualInterfaceGroupAssociationId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest)) {
            return false;
        }
        DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest other = (DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest) obj;
        return Objects.equals(localGatewayRouteTableVirtualInterfaceGroupAssociationId(),
                other.localGatewayRouteTableVirtualInterfaceGroupAssociationId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest")
                .add("LocalGatewayRouteTableVirtualInterfaceGroupAssociationId",
                        localGatewayRouteTableVirtualInterfaceGroupAssociationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTableVirtualInterfaceGroupAssociationId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest, T> g) {
        return obj -> g.apply((DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest> {
        /**
         * <p>
         * The ID of the local gateway route table virtual interface group association.
         * </p>
         * 
         * @param localGatewayRouteTableVirtualInterfaceGroupAssociationId
         *        The ID of the local gateway route table virtual interface group association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String localGatewayRouteTableVirtualInterfaceGroupAssociationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest model) {
            super(model);
            localGatewayRouteTableVirtualInterfaceGroupAssociationId(model.localGatewayRouteTableVirtualInterfaceGroupAssociationId);
        }

        public final String getLocalGatewayRouteTableVirtualInterfaceGroupAssociationId() {
            return localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        public final void setLocalGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
        }

        @Override
        public final Builder localGatewayRouteTableVirtualInterfaceGroupAssociationId(
                String localGatewayRouteTableVirtualInterfaceGroupAssociationId) {
            this.localGatewayRouteTableVirtualInterfaceGroupAssociationId = localGatewayRouteTableVirtualInterfaceGroupAssociationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest build() {
            return new DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
