/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnTargetNetworksResponse;
import software.amazon.awssdk.services.ec2.model.TargetNetwork;

public class DescribeClientVpnTargetNetworksPublisher
implements SdkPublisher<DescribeClientVpnTargetNetworksResponse> {
    private final Ec2AsyncClient client;
    private final DescribeClientVpnTargetNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClientVpnTargetNetworksPublisher(Ec2AsyncClient client, DescribeClientVpnTargetNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClientVpnTargetNetworksPublisher(Ec2AsyncClient client, DescribeClientVpnTargetNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClientVpnTargetNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClientVpnTargetNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TargetNetwork> clientVpnTargetNetworks() {
        Function<DescribeClientVpnTargetNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientVpnTargetNetworks() != null) {
                return response.clientVpnTargetNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClientVpnTargetNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClientVpnTargetNetworksResponseFetcher
    implements AsyncPageFetcher<DescribeClientVpnTargetNetworksResponse> {
        private DescribeClientVpnTargetNetworksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnTargetNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClientVpnTargetNetworksResponse> nextPage(DescribeClientVpnTargetNetworksResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnTargetNetworksPublisher.this.client.describeClientVpnTargetNetworks(DescribeClientVpnTargetNetworksPublisher.this.firstRequest);
            }
            return DescribeClientVpnTargetNetworksPublisher.this.client.describeClientVpnTargetNetworks((DescribeClientVpnTargetNetworksRequest)((Object)DescribeClientVpnTargetNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

