/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.IpamCidrAuthorizationContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvisionIpamPoolCidrRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ProvisionIpamPoolCidrRequest> {
    private static final SdkField<String> IPAM_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolId").getter(ProvisionIpamPoolCidrRequest.getter(ProvisionIpamPoolCidrRequest::ipamPoolId)).setter(ProvisionIpamPoolCidrRequest.setter(Builder::ipamPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolId").unmarshallLocationName("IpamPoolId").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(ProvisionIpamPoolCidrRequest.getter(ProvisionIpamPoolCidrRequest::cidr)).setter(ProvisionIpamPoolCidrRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<IpamCidrAuthorizationContext> CIDR_AUTHORIZATION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CidrAuthorizationContext").getter(ProvisionIpamPoolCidrRequest.getter(ProvisionIpamPoolCidrRequest::cidrAuthorizationContext)).setter(ProvisionIpamPoolCidrRequest.setter(Builder::cidrAuthorizationContext)).constructor(IpamCidrAuthorizationContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAuthorizationContext").unmarshallLocationName("CidrAuthorizationContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POOL_ID_FIELD, CIDR_FIELD, CIDR_AUTHORIZATION_CONTEXT_FIELD));
    private final String ipamPoolId;
    private final String cidr;
    private final IpamCidrAuthorizationContext cidrAuthorizationContext;

    private ProvisionIpamPoolCidrRequest(BuilderImpl builder) {
        super(builder);
        this.ipamPoolId = builder.ipamPoolId;
        this.cidr = builder.cidr;
        this.cidrAuthorizationContext = builder.cidrAuthorizationContext;
    }

    public final String ipamPoolId() {
        return this.ipamPoolId;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final IpamCidrAuthorizationContext cidrAuthorizationContext() {
        return this.cidrAuthorizationContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrAuthorizationContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionIpamPoolCidrRequest)) {
            return false;
        }
        ProvisionIpamPoolCidrRequest other = (ProvisionIpamPoolCidrRequest)((Object)obj);
        return Objects.equals(this.ipamPoolId(), other.ipamPoolId()) && Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.cidrAuthorizationContext(), other.cidrAuthorizationContext());
    }

    public final String toString() {
        return ToString.builder((String)"ProvisionIpamPoolCidrRequest").add("IpamPoolId", (Object)this.ipamPoolId()).add("Cidr", (Object)this.cidr()).add("CidrAuthorizationContext", (Object)this.cidrAuthorizationContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpamPoolId": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolId()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "CidrAuthorizationContext": {
                return Optional.ofNullable(clazz.cast(this.cidrAuthorizationContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvisionIpamPoolCidrRequest, T> g) {
        return obj -> g.apply((ProvisionIpamPoolCidrRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String ipamPoolId;
        private String cidr;
        private IpamCidrAuthorizationContext cidrAuthorizationContext;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionIpamPoolCidrRequest model) {
            super(model);
            this.ipamPoolId(model.ipamPoolId);
            this.cidr(model.cidr);
            this.cidrAuthorizationContext(model.cidrAuthorizationContext);
        }

        public final String getIpamPoolId() {
            return this.ipamPoolId;
        }

        public final void setIpamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
        }

        @Override
        public final Builder ipamPoolId(String ipamPoolId) {
            this.ipamPoolId = ipamPoolId;
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final IpamCidrAuthorizationContext.Builder getCidrAuthorizationContext() {
            return this.cidrAuthorizationContext != null ? this.cidrAuthorizationContext.toBuilder() : null;
        }

        public final void setCidrAuthorizationContext(IpamCidrAuthorizationContext.BuilderImpl cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext != null ? cidrAuthorizationContext.build() : null;
        }

        @Override
        public final Builder cidrAuthorizationContext(IpamCidrAuthorizationContext cidrAuthorizationContext) {
            this.cidrAuthorizationContext = cidrAuthorizationContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvisionIpamPoolCidrRequest build() {
            return new ProvisionIpamPoolCidrRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvisionIpamPoolCidrRequest> {
        public Builder ipamPoolId(String var1);

        public Builder cidr(String var1);

        public Builder cidrAuthorizationContext(IpamCidrAuthorizationContext var1);

        default public Builder cidrAuthorizationContext(Consumer<IpamCidrAuthorizationContext.Builder> cidrAuthorizationContext) {
            return this.cidrAuthorizationContext((IpamCidrAuthorizationContext)((IpamCidrAuthorizationContext.Builder)IpamCidrAuthorizationContext.builder().applyMutation(cidrAuthorizationContext)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

