/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ebs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChecksumAggregationMethod {
    LINEAR("LINEAR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChecksumAggregationMethod> VALUE_MAP;
    private final String value;

    private ChecksumAggregationMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChecksumAggregationMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChecksumAggregationMethod> knownValues() {
        EnumSet<ChecksumAggregationMethod> knownValues = EnumSet.allOf(ChecksumAggregationMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChecksumAggregationMethod.class, ChecksumAggregationMethod::toString);
    }
}

