/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the auto scaling settings for a global table or global secondary index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingSettingsDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingSettingsDescription.Builder, AutoScalingSettingsDescription> {
    private static final SdkField<Long> MINIMUM_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MinimumUnits").getter(getter(AutoScalingSettingsDescription::minimumUnits))
            .setter(setter(Builder::minimumUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumUnits").build()).build();

    private static final SdkField<Long> MAXIMUM_UNITS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaximumUnits").getter(getter(AutoScalingSettingsDescription::maximumUnits))
            .setter(setter(Builder::maximumUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumUnits").build()).build();

    private static final SdkField<Boolean> AUTO_SCALING_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoScalingDisabled").getter(getter(AutoScalingSettingsDescription::autoScalingDisabled))
            .setter(setter(Builder::autoScalingDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingDisabled").build())
            .build();

    private static final SdkField<String> AUTO_SCALING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingRoleArn").getter(getter(AutoScalingSettingsDescription::autoScalingRoleArn))
            .setter(setter(Builder::autoScalingRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRoleArn").build())
            .build();

    private static final SdkField<List<AutoScalingPolicyDescription>> SCALING_POLICIES_FIELD = SdkField
            .<List<AutoScalingPolicyDescription>> builder(MarshallingType.LIST)
            .memberName("ScalingPolicies")
            .getter(getter(AutoScalingSettingsDescription::scalingPolicies))
            .setter(setter(Builder::scalingPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingPolicyDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingPolicyDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_UNITS_FIELD,
            MAXIMUM_UNITS_FIELD, AUTO_SCALING_DISABLED_FIELD, AUTO_SCALING_ROLE_ARN_FIELD, SCALING_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long minimumUnits;

    private final Long maximumUnits;

    private final Boolean autoScalingDisabled;

    private final String autoScalingRoleArn;

    private final List<AutoScalingPolicyDescription> scalingPolicies;

    private AutoScalingSettingsDescription(BuilderImpl builder) {
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.autoScalingRoleArn = builder.autoScalingRoleArn;
        this.scalingPolicies = builder.scalingPolicies;
    }

    /**
     * <p>
     * The minimum capacity units that a global table or global secondary index should be scaled down to.
     * </p>
     * 
     * @return The minimum capacity units that a global table or global secondary index should be scaled down to.
     */
    public final Long minimumUnits() {
        return minimumUnits;
    }

    /**
     * <p>
     * The maximum capacity units that a global table or global secondary index should be scaled up to.
     * </p>
     * 
     * @return The maximum capacity units that a global table or global secondary index should be scaled up to.
     */
    public final Long maximumUnits() {
        return maximumUnits;
    }

    /**
     * <p>
     * Disabled auto scaling for this global table or global secondary index.
     * </p>
     * 
     * @return Disabled auto scaling for this global table or global secondary index.
     */
    public final Boolean autoScalingDisabled() {
        return autoScalingDisabled;
    }

    /**
     * <p>
     * Role ARN used for configuring the auto scaling policy.
     * </p>
     * 
     * @return Role ARN used for configuring the auto scaling policy.
     */
    public final String autoScalingRoleArn() {
        return autoScalingRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingPolicies() {
        return scalingPolicies != null && !(scalingPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the scaling policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingPolicies} method.
     * </p>
     * 
     * @return Information about the scaling policies.
     */
    public final List<AutoScalingPolicyDescription> scalingPolicies() {
        return scalingPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingPolicies() ? scalingPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettingsDescription)) {
            return false;
        }
        AutoScalingSettingsDescription other = (AutoScalingSettingsDescription) obj;
        return Objects.equals(minimumUnits(), other.minimumUnits()) && Objects.equals(maximumUnits(), other.maximumUnits())
                && Objects.equals(autoScalingDisabled(), other.autoScalingDisabled())
                && Objects.equals(autoScalingRoleArn(), other.autoScalingRoleArn())
                && hasScalingPolicies() == other.hasScalingPolicies()
                && Objects.equals(scalingPolicies(), other.scalingPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingSettingsDescription").add("MinimumUnits", minimumUnits())
                .add("MaximumUnits", maximumUnits()).add("AutoScalingDisabled", autoScalingDisabled())
                .add("AutoScalingRoleArn", autoScalingRoleArn())
                .add("ScalingPolicies", hasScalingPolicies() ? scalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinimumUnits":
            return Optional.ofNullable(clazz.cast(minimumUnits()));
        case "MaximumUnits":
            return Optional.ofNullable(clazz.cast(maximumUnits()));
        case "AutoScalingDisabled":
            return Optional.ofNullable(clazz.cast(autoScalingDisabled()));
        case "AutoScalingRoleArn":
            return Optional.ofNullable(clazz.cast(autoScalingRoleArn()));
        case "ScalingPolicies":
            return Optional.ofNullable(clazz.cast(scalingPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinimumUnits", MINIMUM_UNITS_FIELD);
        map.put("MaximumUnits", MAXIMUM_UNITS_FIELD);
        map.put("AutoScalingDisabled", AUTO_SCALING_DISABLED_FIELD);
        map.put("AutoScalingRoleArn", AUTO_SCALING_ROLE_ARN_FIELD);
        map.put("ScalingPolicies", SCALING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSettingsDescription, T> g) {
        return obj -> g.apply((AutoScalingSettingsDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingSettingsDescription> {
        /**
         * <p>
         * The minimum capacity units that a global table or global secondary index should be scaled down to.
         * </p>
         * 
         * @param minimumUnits
         *        The minimum capacity units that a global table or global secondary index should be scaled down to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumUnits(Long minimumUnits);

        /**
         * <p>
         * The maximum capacity units that a global table or global secondary index should be scaled up to.
         * </p>
         * 
         * @param maximumUnits
         *        The maximum capacity units that a global table or global secondary index should be scaled up to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumUnits(Long maximumUnits);

        /**
         * <p>
         * Disabled auto scaling for this global table or global secondary index.
         * </p>
         * 
         * @param autoScalingDisabled
         *        Disabled auto scaling for this global table or global secondary index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingDisabled(Boolean autoScalingDisabled);

        /**
         * <p>
         * Role ARN used for configuring the auto scaling policy.
         * </p>
         * 
         * @param autoScalingRoleArn
         *        Role ARN used for configuring the auto scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingRoleArn(String autoScalingRoleArn);

        /**
         * <p>
         * Information about the scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        Information about the scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(Collection<AutoScalingPolicyDescription> scalingPolicies);

        /**
         * <p>
         * Information about the scaling policies.
         * </p>
         * 
         * @param scalingPolicies
         *        Information about the scaling policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(AutoScalingPolicyDescription... scalingPolicies);

        /**
         * <p>
         * Information about the scaling policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #scalingPolicies(List<AutoScalingPolicyDescription>)}.
         * 
         * @param scalingPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicies(java.util.Collection<AutoScalingPolicyDescription>)
         */
        Builder scalingPolicies(Consumer<AutoScalingPolicyDescription.Builder>... scalingPolicies);
    }

    static final class BuilderImpl implements Builder {
        private Long minimumUnits;

        private Long maximumUnits;

        private Boolean autoScalingDisabled;

        private String autoScalingRoleArn;

        private List<AutoScalingPolicyDescription> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettingsDescription model) {
            minimumUnits(model.minimumUnits);
            maximumUnits(model.maximumUnits);
            autoScalingDisabled(model.autoScalingDisabled);
            autoScalingRoleArn(model.autoScalingRoleArn);
            scalingPolicies(model.scalingPolicies);
        }

        public final Long getMinimumUnits() {
            return minimumUnits;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final Long getMaximumUnits() {
            return maximumUnits;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final Boolean getAutoScalingDisabled() {
            return autoScalingDisabled;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final String getAutoScalingRoleArn() {
            return autoScalingRoleArn;
        }

        public final void setAutoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
        }

        @Override
        public final Builder autoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
            return this;
        }

        public final List<AutoScalingPolicyDescription.Builder> getScalingPolicies() {
            List<AutoScalingPolicyDescription.Builder> result = AutoScalingPolicyDescriptionListCopier
                    .copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<AutoScalingPolicyDescription.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = AutoScalingPolicyDescriptionListCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<AutoScalingPolicyDescription> scalingPolicies) {
            this.scalingPolicies = AutoScalingPolicyDescriptionListCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(AutoScalingPolicyDescription... scalingPolicies) {
            scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<AutoScalingPolicyDescription.Builder>... scalingPolicies) {
            scalingPolicies(Stream.of(scalingPolicies).map(c -> AutoScalingPolicyDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutoScalingSettingsDescription build() {
            return new AutoScalingSettingsDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
