/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputOverride;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaGlobalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ReplicaStatus;
import software.amazon.awssdk.services.dynamodb.model.TableClassSummary;
import software.amazon.awssdk.services.dynamodb.model.TableWarmThroughputDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicaDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicaDescription> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ReplicaDescription.getter(ReplicaDescription::regionName)).setter(ReplicaDescription.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatus").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusAsString)).setter(ReplicaDescription.setter(Builder::replicaStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatus").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatusDescription").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusDescription)).setter(ReplicaDescription.setter(Builder::replicaStatusDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusDescription").build()}).build();
    private static final SdkField<String> REPLICA_STATUS_PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaStatusPercentProgress").getter(ReplicaDescription.getter(ReplicaDescription::replicaStatusPercentProgress)).setter(ReplicaDescription.setter(Builder::replicaStatusPercentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaStatusPercentProgress").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyId").getter(ReplicaDescription.getter(ReplicaDescription::kmsMasterKeyId)).setter(ReplicaDescription.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()}).build();
    private static final SdkField<ProvisionedThroughputOverride> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionedThroughputOverride").getter(ReplicaDescription.getter(ReplicaDescription::provisionedThroughputOverride)).setter(ReplicaDescription.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final SdkField<OnDemandThroughputOverride> ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDemandThroughputOverride").getter(ReplicaDescription.getter(ReplicaDescription::onDemandThroughputOverride)).setter(ReplicaDescription.setter(Builder::onDemandThroughputOverride)).constructor(OnDemandThroughputOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandThroughputOverride").build()}).build();
    private static final SdkField<TableWarmThroughputDescription> WARM_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmThroughput").getter(ReplicaDescription.getter(ReplicaDescription::warmThroughput)).setter(ReplicaDescription.setter(Builder::warmThroughput)).constructor(TableWarmThroughputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughput").build()}).build();
    private static final SdkField<List<ReplicaGlobalSecondaryIndexDescription>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalSecondaryIndexes").getter(ReplicaDescription.getter(ReplicaDescription::globalSecondaryIndexes)).setter(ReplicaDescription.setter(Builder::globalSecondaryIndexes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaGlobalSecondaryIndexDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> REPLICA_INACCESSIBLE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicaInaccessibleDateTime").getter(ReplicaDescription.getter(ReplicaDescription::replicaInaccessibleDateTime)).setter(ReplicaDescription.setter(Builder::replicaInaccessibleDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaInaccessibleDateTime").build()}).build();
    private static final SdkField<TableClassSummary> REPLICA_TABLE_CLASS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaTableClassSummary").getter(ReplicaDescription.getter(ReplicaDescription::replicaTableClassSummary)).setter(ReplicaDescription.setter(Builder::replicaTableClassSummary)).constructor(TableClassSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaTableClassSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, REPLICA_STATUS_FIELD, REPLICA_STATUS_DESCRIPTION_FIELD, REPLICA_STATUS_PERCENT_PROGRESS_FIELD, KMS_MASTER_KEY_ID_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD, ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD, WARM_THROUGHPUT_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, REPLICA_INACCESSIBLE_DATE_TIME_FIELD, REPLICA_TABLE_CLASS_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ReplicaDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String replicaStatus;
    private final String replicaStatusDescription;
    private final String replicaStatusPercentProgress;
    private final String kmsMasterKeyId;
    private final ProvisionedThroughputOverride provisionedThroughputOverride;
    private final OnDemandThroughputOverride onDemandThroughputOverride;
    private final TableWarmThroughputDescription warmThroughput;
    private final List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes;
    private final Instant replicaInaccessibleDateTime;
    private final TableClassSummary replicaTableClassSummary;

    private ReplicaDescription(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.replicaStatus = builder.replicaStatus;
        this.replicaStatusDescription = builder.replicaStatusDescription;
        this.replicaStatusPercentProgress = builder.replicaStatusPercentProgress;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
        this.onDemandThroughputOverride = builder.onDemandThroughputOverride;
        this.warmThroughput = builder.warmThroughput;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.replicaInaccessibleDateTime = builder.replicaInaccessibleDateTime;
        this.replicaTableClassSummary = builder.replicaTableClassSummary;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final ReplicaStatus replicaStatus() {
        return ReplicaStatus.fromValue(this.replicaStatus);
    }

    public final String replicaStatusAsString() {
        return this.replicaStatus;
    }

    public final String replicaStatusDescription() {
        return this.replicaStatusDescription;
    }

    public final String replicaStatusPercentProgress() {
        return this.replicaStatusPercentProgress;
    }

    public final String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public final ProvisionedThroughputOverride provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    public final OnDemandThroughputOverride onDemandThroughputOverride() {
        return this.onDemandThroughputOverride;
    }

    public final TableWarmThroughputDescription warmThroughput() {
        return this.warmThroughput;
    }

    public final boolean hasGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes != null && !(this.globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    public final List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public final Instant replicaInaccessibleDateTime() {
        return this.replicaInaccessibleDateTime;
    }

    public final TableClassSummary replicaTableClassSummary() {
        return this.replicaTableClassSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaStatusPercentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandThroughputOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaInaccessibleDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaTableClassSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicaDescription)) {
            return false;
        }
        ReplicaDescription other = (ReplicaDescription)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.replicaStatusAsString(), other.replicaStatusAsString()) && Objects.equals(this.replicaStatusDescription(), other.replicaStatusDescription()) && Objects.equals(this.replicaStatusPercentProgress(), other.replicaStatusPercentProgress()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride()) && Objects.equals(this.onDemandThroughputOverride(), other.onDemandThroughputOverride()) && Objects.equals(this.warmThroughput(), other.warmThroughput()) && this.hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes() && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.replicaInaccessibleDateTime(), other.replicaInaccessibleDateTime()) && Objects.equals(this.replicaTableClassSummary(), other.replicaTableClassSummary());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicaDescription").add("RegionName", (Object)this.regionName()).add("ReplicaStatus", (Object)this.replicaStatusAsString()).add("ReplicaStatusDescription", (Object)this.replicaStatusDescription()).add("ReplicaStatusPercentProgress", (Object)this.replicaStatusPercentProgress()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).add("OnDemandThroughputOverride", (Object)this.onDemandThroughputOverride()).add("WarmThroughput", (Object)this.warmThroughput()).add("GlobalSecondaryIndexes", this.hasGlobalSecondaryIndexes() ? this.globalSecondaryIndexes() : null).add("ReplicaInaccessibleDateTime", (Object)this.replicaInaccessibleDateTime()).add("ReplicaTableClassSummary", (Object)this.replicaTableClassSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "ReplicaStatus": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusAsString()));
            }
            case "ReplicaStatusDescription": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusDescription()));
            }
            case "ReplicaStatusPercentProgress": {
                return Optional.ofNullable(clazz.cast(this.replicaStatusPercentProgress()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
            case "OnDemandThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.onDemandThroughputOverride()));
            }
            case "WarmThroughput": {
                return Optional.ofNullable(clazz.cast(this.warmThroughput()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "ReplicaInaccessibleDateTime": {
                return Optional.ofNullable(clazz.cast(this.replicaInaccessibleDateTime()));
            }
            case "ReplicaTableClassSummary": {
                return Optional.ofNullable(clazz.cast(this.replicaTableClassSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("ReplicaStatus", REPLICA_STATUS_FIELD);
        map.put("ReplicaStatusDescription", REPLICA_STATUS_DESCRIPTION_FIELD);
        map.put("ReplicaStatusPercentProgress", REPLICA_STATUS_PERCENT_PROGRESS_FIELD);
        map.put("KMSMasterKeyId", KMS_MASTER_KEY_ID_FIELD);
        map.put("ProvisionedThroughputOverride", PROVISIONED_THROUGHPUT_OVERRIDE_FIELD);
        map.put("OnDemandThroughputOverride", ON_DEMAND_THROUGHPUT_OVERRIDE_FIELD);
        map.put("WarmThroughput", WARM_THROUGHPUT_FIELD);
        map.put("GlobalSecondaryIndexes", GLOBAL_SECONDARY_INDEXES_FIELD);
        map.put("ReplicaInaccessibleDateTime", REPLICA_INACCESSIBLE_DATE_TIME_FIELD);
        map.put("ReplicaTableClassSummary", REPLICA_TABLE_CLASS_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReplicaDescription, T> g) {
        return obj -> g.apply((ReplicaDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String replicaStatus;
        private String replicaStatusDescription;
        private String replicaStatusPercentProgress;
        private String kmsMasterKeyId;
        private ProvisionedThroughputOverride provisionedThroughputOverride;
        private OnDemandThroughputOverride onDemandThroughputOverride;
        private TableWarmThroughputDescription warmThroughput;
        private List<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();
        private Instant replicaInaccessibleDateTime;
        private TableClassSummary replicaTableClassSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicaDescription model) {
            this.regionName(model.regionName);
            this.replicaStatus(model.replicaStatus);
            this.replicaStatusDescription(model.replicaStatusDescription);
            this.replicaStatusPercentProgress(model.replicaStatusPercentProgress);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
            this.onDemandThroughputOverride(model.onDemandThroughputOverride);
            this.warmThroughput(model.warmThroughput);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.replicaInaccessibleDateTime(model.replicaInaccessibleDateTime);
            this.replicaTableClassSummary(model.replicaTableClassSummary);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getReplicaStatus() {
            return this.replicaStatus;
        }

        public final void setReplicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
        }

        @Override
        public final Builder replicaStatus(String replicaStatus) {
            this.replicaStatus = replicaStatus;
            return this;
        }

        @Override
        public final Builder replicaStatus(ReplicaStatus replicaStatus) {
            this.replicaStatus(replicaStatus == null ? null : replicaStatus.toString());
            return this;
        }

        public final String getReplicaStatusDescription() {
            return this.replicaStatusDescription;
        }

        public final void setReplicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
        }

        @Override
        public final Builder replicaStatusDescription(String replicaStatusDescription) {
            this.replicaStatusDescription = replicaStatusDescription;
            return this;
        }

        public final String getReplicaStatusPercentProgress() {
            return this.replicaStatusPercentProgress;
        }

        public final void setReplicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
        }

        @Override
        public final Builder replicaStatusPercentProgress(String replicaStatusPercentProgress) {
            this.replicaStatusPercentProgress = replicaStatusPercentProgress;
            return this;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final ProvisionedThroughputOverride.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughputOverride.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughputOverride provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final OnDemandThroughputOverride.Builder getOnDemandThroughputOverride() {
            return this.onDemandThroughputOverride != null ? this.onDemandThroughputOverride.toBuilder() : null;
        }

        public final void setOnDemandThroughputOverride(OnDemandThroughputOverride.BuilderImpl onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride != null ? onDemandThroughputOverride.build() : null;
        }

        @Override
        public final Builder onDemandThroughputOverride(OnDemandThroughputOverride onDemandThroughputOverride) {
            this.onDemandThroughputOverride = onDemandThroughputOverride;
            return this;
        }

        public final TableWarmThroughputDescription.Builder getWarmThroughput() {
            return this.warmThroughput != null ? this.warmThroughput.toBuilder() : null;
        }

        public final void setWarmThroughput(TableWarmThroughputDescription.BuilderImpl warmThroughput) {
            this.warmThroughput = warmThroughput != null ? warmThroughput.build() : null;
        }

        @Override
        public final Builder warmThroughput(TableWarmThroughputDescription warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        public final List<ReplicaGlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            List<ReplicaGlobalSecondaryIndexDescription.Builder> result = ReplicaGlobalSecondaryIndexDescriptionListCopier.copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = ReplicaGlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexDescription.Builder> ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Stream.of(globalSecondaryIndexes).map(c -> (ReplicaGlobalSecondaryIndexDescription)((ReplicaGlobalSecondaryIndexDescription.Builder)ReplicaGlobalSecondaryIndexDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getReplicaInaccessibleDateTime() {
            return this.replicaInaccessibleDateTime;
        }

        public final void setReplicaInaccessibleDateTime(Instant replicaInaccessibleDateTime) {
            this.replicaInaccessibleDateTime = replicaInaccessibleDateTime;
        }

        @Override
        public final Builder replicaInaccessibleDateTime(Instant replicaInaccessibleDateTime) {
            this.replicaInaccessibleDateTime = replicaInaccessibleDateTime;
            return this;
        }

        public final TableClassSummary.Builder getReplicaTableClassSummary() {
            return this.replicaTableClassSummary != null ? this.replicaTableClassSummary.toBuilder() : null;
        }

        public final void setReplicaTableClassSummary(TableClassSummary.BuilderImpl replicaTableClassSummary) {
            this.replicaTableClassSummary = replicaTableClassSummary != null ? replicaTableClassSummary.build() : null;
        }

        @Override
        public final Builder replicaTableClassSummary(TableClassSummary replicaTableClassSummary) {
            this.replicaTableClassSummary = replicaTableClassSummary;
            return this;
        }

        public ReplicaDescription build() {
            return new ReplicaDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicaDescription> {
        public Builder regionName(String var1);

        public Builder replicaStatus(String var1);

        public Builder replicaStatus(ReplicaStatus var1);

        public Builder replicaStatusDescription(String var1);

        public Builder replicaStatusPercentProgress(String var1);

        public Builder kmsMasterKeyId(String var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughputOverride var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughputOverride.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughputOverride)((ProvisionedThroughputOverride.Builder)ProvisionedThroughputOverride.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder onDemandThroughputOverride(OnDemandThroughputOverride var1);

        default public Builder onDemandThroughputOverride(Consumer<OnDemandThroughputOverride.Builder> onDemandThroughputOverride) {
            return this.onDemandThroughputOverride((OnDemandThroughputOverride)((OnDemandThroughputOverride.Builder)OnDemandThroughputOverride.builder().applyMutation(onDemandThroughputOverride)).build());
        }

        public Builder warmThroughput(TableWarmThroughputDescription var1);

        default public Builder warmThroughput(Consumer<TableWarmThroughputDescription.Builder> warmThroughput) {
            return this.warmThroughput((TableWarmThroughputDescription)((TableWarmThroughputDescription.Builder)TableWarmThroughputDescription.builder().applyMutation(warmThroughput)).build());
        }

        public Builder globalSecondaryIndexes(Collection<ReplicaGlobalSecondaryIndexDescription> var1);

        public Builder globalSecondaryIndexes(ReplicaGlobalSecondaryIndexDescription ... var1);

        public Builder globalSecondaryIndexes(Consumer<ReplicaGlobalSecondaryIndexDescription.Builder> ... var1);

        public Builder replicaInaccessibleDateTime(Instant var1);

        public Builder replicaTableClassSummary(TableClassSummary var1);

        default public Builder replicaTableClassSummary(Consumer<TableClassSummary.Builder> replicaTableClassSummary) {
            return this.replicaTableClassSummary((TableClassSummary)((TableClassSummary.Builder)TableClassSummary.builder().applyMutation(replicaTableClassSummary)).build());
        }
    }
}

