/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class KeyListCopier {
    static List<Map<String, AttributeValue>> copy(Collection<? extends Map<String, ? extends AttributeValue>> keyListParam) {
        List<Map<String, AttributeValue>> list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, AttributeValue>> modifiableList = new ArrayList<>(keyListParam.size());
            keyListParam.forEach(entry -> {
                Map<String, AttributeValue> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AttributeValue> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        modifiableMap.put(key, value);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, AttributeValue>> copyFromBuilder(
            Collection<? extends Map<String, ? extends AttributeValue.Builder>> keyListParam) {
        List<Map<String, AttributeValue>> list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, AttributeValue>> modifiableList = new ArrayList<>(keyListParam.size());
            keyListParam.forEach(entry -> {
                Map<String, AttributeValue> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AttributeValue> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        AttributeValue member = value == null ? null : value.build();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, AttributeValue.Builder>> copyToBuilder(
            Collection<? extends Map<String, ? extends AttributeValue>> keyListParam) {
        List<Map<String, AttributeValue.Builder>> list;
        if (keyListParam == null || keyListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, AttributeValue.Builder>> modifiableList = new ArrayList<>(keyListParam.size());
            keyListParam.forEach(entry -> {
                Map<String, AttributeValue.Builder> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, AttributeValue.Builder> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        AttributeValue.Builder member = value == null ? null : value.toBuilder();
                        modifiableMap.put(key, member);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
