/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3SseAlgorithm {
    AES256("AES256"),
    KMS("KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3SseAlgorithm> VALUE_MAP;
    private final String value;

    private S3SseAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3SseAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3SseAlgorithm> knownValues() {
        EnumSet<S3SseAlgorithm> knownValues = EnumSet.allOf(S3SseAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3SseAlgorithm.class, S3SseAlgorithm::toString);
    }
}

