/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.BackupStatus;
import software.amazon.awssdk.services.dynamodb.model.BackupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BackupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BackupDetails> {
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupArn").getter(BackupDetails.getter(BackupDetails::backupArn)).setter(BackupDetails.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BACKUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupName").getter(BackupDetails.getter(BackupDetails::backupName)).setter(BackupDetails.setter(Builder::backupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupName").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeBytes").getter(BackupDetails.getter(BackupDetails::backupSizeBytes)).setter(BackupDetails.setter(Builder::backupSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()}).build();
    private static final SdkField<String> BACKUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupStatus").getter(BackupDetails.getter(BackupDetails::backupStatusAsString)).setter(BackupDetails.setter(Builder::backupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupStatus").build()}).build();
    private static final SdkField<String> BACKUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupType").getter(BackupDetails.getter(BackupDetails::backupTypeAsString)).setter(BackupDetails.setter(Builder::backupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupType").build()}).build();
    private static final SdkField<Instant> BACKUP_CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BackupCreationDateTime").getter(BackupDetails.getter(BackupDetails::backupCreationDateTime)).setter(BackupDetails.setter(Builder::backupCreationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupCreationDateTime").build()}).build();
    private static final SdkField<Instant> BACKUP_EXPIRY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BackupExpiryDateTime").getter(BackupDetails.getter(BackupDetails::backupExpiryDateTime)).setter(BackupDetails.setter(Builder::backupExpiryDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupExpiryDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ARN_FIELD, BACKUP_NAME_FIELD, BACKUP_SIZE_BYTES_FIELD, BACKUP_STATUS_FIELD, BACKUP_TYPE_FIELD, BACKUP_CREATION_DATE_TIME_FIELD, BACKUP_EXPIRY_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String backupArn;
    private final String backupName;
    private final Long backupSizeBytes;
    private final String backupStatus;
    private final String backupType;
    private final Instant backupCreationDateTime;
    private final Instant backupExpiryDateTime;

    private BackupDetails(BuilderImpl builder) {
        this.backupArn = builder.backupArn;
        this.backupName = builder.backupName;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupStatus = builder.backupStatus;
        this.backupType = builder.backupType;
        this.backupCreationDateTime = builder.backupCreationDateTime;
        this.backupExpiryDateTime = builder.backupExpiryDateTime;
    }

    public final String backupArn() {
        return this.backupArn;
    }

    public final String backupName() {
        return this.backupName;
    }

    public final Long backupSizeBytes() {
        return this.backupSizeBytes;
    }

    public final BackupStatus backupStatus() {
        return BackupStatus.fromValue(this.backupStatus);
    }

    public final String backupStatusAsString() {
        return this.backupStatus;
    }

    public final BackupType backupType() {
        return BackupType.fromValue(this.backupType);
    }

    public final String backupTypeAsString() {
        return this.backupType;
    }

    public final Instant backupCreationDateTime() {
        return this.backupCreationDateTime;
    }

    public final Instant backupExpiryDateTime() {
        return this.backupExpiryDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupExpiryDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupDetails)) {
            return false;
        }
        BackupDetails other = (BackupDetails)obj;
        return Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.backupName(), other.backupName()) && Objects.equals(this.backupSizeBytes(), other.backupSizeBytes()) && Objects.equals(this.backupStatusAsString(), other.backupStatusAsString()) && Objects.equals(this.backupTypeAsString(), other.backupTypeAsString()) && Objects.equals(this.backupCreationDateTime(), other.backupCreationDateTime()) && Objects.equals(this.backupExpiryDateTime(), other.backupExpiryDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BackupDetails").add("BackupArn", (Object)this.backupArn()).add("BackupName", (Object)this.backupName()).add("BackupSizeBytes", (Object)this.backupSizeBytes()).add("BackupStatus", (Object)this.backupStatusAsString()).add("BackupType", (Object)this.backupTypeAsString()).add("BackupCreationDateTime", (Object)this.backupCreationDateTime()).add("BackupExpiryDateTime", (Object)this.backupExpiryDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BackupName": {
                return Optional.ofNullable(clazz.cast(this.backupName()));
            }
            case "BackupSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeBytes()));
            }
            case "BackupStatus": {
                return Optional.ofNullable(clazz.cast(this.backupStatusAsString()));
            }
            case "BackupType": {
                return Optional.ofNullable(clazz.cast(this.backupTypeAsString()));
            }
            case "BackupCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.backupCreationDateTime()));
            }
            case "BackupExpiryDateTime": {
                return Optional.ofNullable(clazz.cast(this.backupExpiryDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackupDetails, T> g) {
        return obj -> g.apply((BackupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupArn;
        private String backupName;
        private Long backupSizeBytes;
        private String backupStatus;
        private String backupType;
        private Instant backupCreationDateTime;
        private Instant backupExpiryDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupDetails model) {
            this.backupArn(model.backupArn);
            this.backupName(model.backupName);
            this.backupSizeBytes(model.backupSizeBytes);
            this.backupStatus(model.backupStatus);
            this.backupType(model.backupType);
            this.backupCreationDateTime(model.backupCreationDateTime);
            this.backupExpiryDateTime(model.backupExpiryDateTime);
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final String getBackupName() {
            return this.backupName;
        }

        public final void setBackupName(String backupName) {
            this.backupName = backupName;
        }

        @Override
        public final Builder backupName(String backupName) {
            this.backupName = backupName;
            return this;
        }

        public final Long getBackupSizeBytes() {
            return this.backupSizeBytes;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final String getBackupStatus() {
            return this.backupStatus;
        }

        public final void setBackupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
        }

        @Override
        public final Builder backupStatus(String backupStatus) {
            this.backupStatus = backupStatus;
            return this;
        }

        @Override
        public final Builder backupStatus(BackupStatus backupStatus) {
            this.backupStatus(backupStatus == null ? null : backupStatus.toString());
            return this;
        }

        public final String getBackupType() {
            return this.backupType;
        }

        public final void setBackupType(String backupType) {
            this.backupType = backupType;
        }

        @Override
        public final Builder backupType(String backupType) {
            this.backupType = backupType;
            return this;
        }

        @Override
        public final Builder backupType(BackupType backupType) {
            this.backupType(backupType == null ? null : backupType.toString());
            return this;
        }

        public final Instant getBackupCreationDateTime() {
            return this.backupCreationDateTime;
        }

        public final void setBackupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
        }

        @Override
        public final Builder backupCreationDateTime(Instant backupCreationDateTime) {
            this.backupCreationDateTime = backupCreationDateTime;
            return this;
        }

        public final Instant getBackupExpiryDateTime() {
            return this.backupExpiryDateTime;
        }

        public final void setBackupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
        }

        @Override
        public final Builder backupExpiryDateTime(Instant backupExpiryDateTime) {
            this.backupExpiryDateTime = backupExpiryDateTime;
            return this;
        }

        public BackupDetails build() {
            return new BackupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BackupDetails> {
        public Builder backupArn(String var1);

        public Builder backupName(String var1);

        public Builder backupSizeBytes(Long var1);

        public Builder backupStatus(String var1);

        public Builder backupStatus(BackupStatus var1);

        public Builder backupType(String var1);

        public Builder backupType(BackupType var1);

        public Builder backupCreationDateTime(Instant var1);

        public Builder backupExpiryDateTime(Instant var1);
    }
}

