/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.time.Duration;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetrySetting;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FullJitterBackoffStrategy;

@SdkInternalApi
final class DynamoDbRetryPolicy {
    private static final int MAX_ERROR_RETRY = 8;
    private static final Duration BASE_DELAY = Duration.ofMillis(25L);
    private static final BackoffStrategy BACKOFF_STRATEGY = FullJitterBackoffStrategy.builder().baseDelay(BASE_DELAY).maxBackoffTime(SdkDefaultRetrySetting.MAX_BACKOFF).build();

    private DynamoDbRetryPolicy() {
    }

    public static RetryPolicy resolveRetryPolicy(SdkClientConfiguration config) {
        RetryPolicy configuredRetryPolicy = (RetryPolicy)config.option((ClientOption)SdkClientOption.RETRY_POLICY);
        if (configuredRetryPolicy != null) {
            return configuredRetryPolicy;
        }
        RetryMode retryMode = RetryMode.resolver().profileFile((Supplier)config.option((ClientOption)SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).defaultRetryMode((RetryMode)config.option((ClientOption)SdkClientOption.DEFAULT_RETRY_MODE)).resolve();
        return AwsRetryPolicy.forRetryMode((RetryMode)retryMode).toBuilder().additionalRetryConditionsAllowed(false).numRetries(Integer.valueOf(8)).backoffStrategy(BACKOFF_STRATEGY).build();
    }
}

