/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
@ThreadSafe
public final class DefaultParameterizedType
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] arguments;

    private DefaultParameterizedType(Class<?> rawType, Type ... arguments) {
        Validate.notEmpty((Object[])arguments, (String)"Arguments must not be empty.", (Object[])new Object[0]);
        Validate.noNullElements((Object[])arguments, (String)"Arguments cannot contain null values.", (Object[])new Object[0]);
        this.rawType = (Class)Validate.paramNotNull(rawType, (String)"rawType");
        this.arguments = arguments;
    }

    public static ParameterizedType parameterizedType(Class<?> rawType, Type ... arguments) {
        return new DefaultParameterizedType(rawType, arguments);
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.arguments.clone();
    }

    @Override
    public Type getOwnerType() {
        return null;
    }
}

