/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.DefaultAttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ChainConverterProvider;

@SdkInternalApi
public final class ConverterProviderResolver {
    private static final AttributeConverterProvider DEFAULT_ATTRIBUTE_CONVERTER = DefaultAttributeConverterProvider.create();

    private ConverterProviderResolver() {
    }

    public static AttributeConverterProvider defaultConverterProvider() {
        return DEFAULT_ATTRIBUTE_CONVERTER;
    }

    public static AttributeConverterProvider resolveProviders(List<AttributeConverterProvider> providers) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return providers.get(0);
        }
        return ChainConverterProvider.create(providers);
    }
}

