/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.OptionalLong;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LongStringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class OptionalLongStringConverter
implements StringConverter<OptionalLong> {
    private static LongStringConverter LONG_CONVERTER = LongStringConverter.create();

    private OptionalLongStringConverter() {
    }

    public static OptionalLongStringConverter create() {
        return new OptionalLongStringConverter();
    }

    @Override
    public EnhancedType<OptionalLong> type() {
        return EnhancedType.of(OptionalLong.class);
    }

    @Override
    public String toString(OptionalLong object) {
        if (!object.isPresent()) {
            return null;
        }
        return LONG_CONVERTER.toString(object.getAsLong());
    }

    @Override
    public OptionalLong fromString(String string) {
        if (string == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(LONG_CONVERTER.fromString(string));
    }
}

