/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.HashMap;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalKeyValues;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class SingleKeyItemConditional
implements QueryConditional {
    private final Key key;
    private final String operator;

    public SingleKeyItemConditional(Key key, String operator) {
        this.key = key;
        this.operator = operator;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalKeyValues queryConditionalKeyValues = QueryConditionalKeyValues.from(this.key, tableSchema, indexName);
        if (queryConditionalKeyValues.sortValue().equals((Object)AttributeValues.nullAttributeValue())) {
            throw new IllegalArgumentException("Attempt to query using a relative condition operator against a null sort key.");
        }
        String partitionKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues.partitionKey());
        String partitionValueToken = EnhancedClientUtils.valueRef(queryConditionalKeyValues.partitionKey());
        String sortKeyToken = EnhancedClientUtils.keyRef(queryConditionalKeyValues.sortKey());
        String sortValueToken = EnhancedClientUtils.valueRef(queryConditionalKeyValues.sortKey());
        String queryExpression = String.format("%s = %s AND %s %s %s", partitionKeyToken, partitionValueToken, sortKeyToken, this.operator, sortValueToken);
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(partitionValueToken, queryConditionalKeyValues.partitionValue());
        expressionAttributeValues.put(sortValueToken, queryConditionalKeyValues.sortValue());
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(partitionKeyToken, queryConditionalKeyValues.partitionKey());
        expressionAttributeNames.put(sortKeyToken, queryConditionalKeyValues.sortKey());
        return Expression.builder().expression(queryExpression).expressionValues(expressionAttributeValues).expressionNames(expressionAttributeNames).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleKeyItemConditional that = (SingleKeyItemConditional)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return this.operator != null ? this.operator.equals(that.operator) : that.operator == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }
}

