/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.update;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateAction;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class RemoveAction
implements UpdateAction,
ToCopyableBuilder<Builder, RemoveAction> {
    private final String path;
    private final Map<String, String> expressionNames;

    private RemoveAction(Builder builder) {
        this.path = (String)Validate.paramNotNull((Object)builder.path, (String)"path");
        this.expressionNames = RemoveAction.wrapSecure(builder.expressionNames != null ? builder.expressionNames : new HashMap());
    }

    private static <T, U> Map<T, U> wrapSecure(Map<T, U> map) {
        return Collections.unmodifiableMap(new HashMap<T, U>(map));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return RemoveAction.builder().path(this.path).expressionNames(this.expressionNames);
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> expressionNames() {
        return this.expressionNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoveAction that = (RemoveAction)o;
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        return this.expressionNames != null ? this.expressionNames.equals(that.expressionNames) : that.expressionNames == null;
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.expressionNames != null ? this.expressionNames.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements CopyableBuilder<Builder, RemoveAction> {
        private String path;
        private Map<String, String> expressionNames;

        private Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder expressionNames(Map<String, String> expressionNames) {
            this.expressionNames = expressionNames == null ? null : new HashMap<String, String>(expressionNames);
            return this;
        }

        public Builder putExpressionName(String key, String value) {
            if (this.expressionNames == null) {
                this.expressionNames = new HashMap<String, String>();
            }
            this.expressionNames.put(key, value);
            return this;
        }

        public RemoveAction build() {
            return new RemoveAction(this);
        }
    }
}

