/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.DescribeTableEnhancedResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;

@SdkInternalApi
public class DescribeTableOperation<T>
implements TableOperation<T, DescribeTableRequest, DescribeTableResponse, DescribeTableEnhancedResponse> {
    public static <T> DescribeTableOperation<T> create() {
        return new DescribeTableOperation<T>();
    }

    @Override
    public OperationName operationName() {
        return OperationName.DESCRIBE_TABLE;
    }

    @Override
    public DescribeTableRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("DescribeTable cannot be executed against a secondary index.");
        }
        return (DescribeTableRequest)DescribeTableRequest.builder().tableName(operationContext.tableName()).build();
    }

    @Override
    public Function<DescribeTableRequest, DescribeTableResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).describeTable(arg_0);
    }

    @Override
    public Function<DescribeTableRequest, CompletableFuture<DescribeTableResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).describeTable(arg_0);
    }

    @Override
    public DescribeTableEnhancedResponse transformResponse(DescribeTableResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        return DescribeTableEnhancedResponse.builder().response(response).build();
    }
}

