/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class Key {
    private final AttributeValue partitionValue;
    private final AttributeValue sortValue;

    private Key(Builder builder) {
        Validate.isTrue((builder.partitionValue != null && !builder.partitionValue.equals((Object)AttributeValues.nullAttributeValue()) ? 1 : 0) != 0, (String)"partitionValue should not be null", (Object[])new Object[0]);
        this.partitionValue = builder.partitionValue;
        this.sortValue = builder.sortValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, AttributeValue> keyMap(TableSchema<?> tableSchema, String index) {
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        keyMap.put(tableSchema.tableMetadata().indexPartitionKey(index), this.partitionValue);
        if (this.sortValue != null) {
            keyMap.put(tableSchema.tableMetadata().indexSortKey(index).orElseThrow(() -> new IllegalArgumentException("A sort key value was supplied for an index that does not support one. Index: " + index)), this.sortValue);
        }
        return Collections.unmodifiableMap(keyMap);
    }

    public AttributeValue partitionKeyValue() {
        return this.partitionValue;
    }

    public Optional<AttributeValue> sortKeyValue() {
        return Optional.ofNullable(this.sortValue);
    }

    public Map<String, AttributeValue> primaryKeyMap(TableSchema<?> tableSchema) {
        return this.keyMap(tableSchema, TableMetadata.primaryIndexName());
    }

    public Builder toBuilder() {
        return new Builder().partitionValue(this.partitionValue).sortValue(this.sortValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.partitionValue != null ? !this.partitionValue.equals((Object)key.partitionValue) : key.partitionValue != null) {
            return false;
        }
        return this.sortValue != null ? this.sortValue.equals((Object)key.sortValue) : key.sortValue == null;
    }

    public int hashCode() {
        int result = this.partitionValue != null ? this.partitionValue.hashCode() : 0;
        result = 31 * result + (this.sortValue != null ? this.sortValue.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private AttributeValue partitionValue;
        private AttributeValue sortValue;

        private Builder() {
        }

        public Builder partitionValue(AttributeValue partitionValue) {
            this.partitionValue = partitionValue;
            return this;
        }

        public Builder partitionValue(String partitionValue) {
            this.partitionValue = AttributeValues.stringValue(partitionValue);
            return this;
        }

        public Builder partitionValue(Number partitionValue) {
            this.partitionValue = AttributeValues.numberValue(partitionValue);
            return this;
        }

        public Builder partitionValue(SdkBytes partitionValue) {
            this.partitionValue = AttributeValues.binaryValue(partitionValue);
            return this;
        }

        public Builder sortValue(AttributeValue sortValue) {
            this.sortValue = sortValue;
            return this;
        }

        public Builder sortValue(String sortValue) {
            this.sortValue = AttributeValues.stringValue(sortValue);
            return this;
        }

        public Builder sortValue(Number sortValue) {
            this.sortValue = AttributeValues.numberValue(sortValue);
            return this;
        }

        public Builder sortValue(SdkBytes sortValue) {
            this.sortValue = AttributeValues.binaryValue(sortValue);
            return this;
        }

        public Key build() {
            return new Key(this);
        }
    }
}

