/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launch action run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchActionRun implements SdkPojo, Serializable, ToCopyableBuilder<LaunchActionRun.Builder, LaunchActionRun> {
    private static final SdkField<LaunchAction> ACTION_FIELD = SdkField.<LaunchAction> builder(MarshallingType.SDK_POJO)
            .memberName("action").getter(getter(LaunchActionRun::action)).setter(setter(Builder::action))
            .constructor(LaunchAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(LaunchActionRun::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(LaunchActionRun::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LaunchActionRun::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            FAILURE_REASON_FIELD, RUN_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LaunchAction action;

    private final String failureReason;

    private final String runId;

    private final String status;

    private LaunchActionRun(BuilderImpl builder) {
        this.action = builder.action;
        this.failureReason = builder.failureReason;
        this.runId = builder.runId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Action.
     * </p>
     * 
     * @return Action.
     */
    public final LaunchAction action() {
        return action;
    }

    /**
     * <p>
     * Failure reason.
     * </p>
     * 
     * @return Failure reason.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Run Id.
     * </p>
     * 
     * @return Run Id.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * Run status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LaunchActionRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Run status.
     * @see LaunchActionRunStatus
     */
    public final LaunchActionRunStatus status() {
        return LaunchActionRunStatus.fromValue(status);
    }

    /**
     * <p>
     * Run status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LaunchActionRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Run status.
     * @see LaunchActionRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionRun)) {
            return false;
        }
        LaunchActionRun other = (LaunchActionRun) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(runId(), other.runId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchActionRun").add("Action", action()).add("FailureReason", failureReason())
                .add("RunId", runId()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchActionRun, T> g) {
        return obj -> g.apply((LaunchActionRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchActionRun> {
        /**
         * <p>
         * Action.
         * </p>
         * 
         * @param action
         *        Action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(LaunchAction action);

        /**
         * <p>
         * Action.
         * </p>
         * This is a convenience method that creates an instance of the {@link LaunchAction.Builder} avoiding the need
         * to create one manually via {@link LaunchAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LaunchAction.Builder#build()} is called immediately and its
         * result is passed to {@link #action(LaunchAction)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link LaunchAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(LaunchAction)
         */
        default Builder action(Consumer<LaunchAction.Builder> action) {
            return action(LaunchAction.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * Failure reason.
         * </p>
         * 
         * @param failureReason
         *        Failure reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Run Id.
         * </p>
         * 
         * @param runId
         *        Run Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * Run status.
         * </p>
         * 
         * @param status
         *        Run status.
         * @see LaunchActionRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Run status.
         * </p>
         * 
         * @param status
         *        Run status.
         * @see LaunchActionRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchActionRunStatus
         */
        Builder status(LaunchActionRunStatus status);
    }

    static final class BuilderImpl implements Builder {
        private LaunchAction action;

        private String failureReason;

        private String runId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchActionRun model) {
            action(model.action);
            failureReason(model.failureReason);
            runId(model.runId);
            status(model.status);
        }

        public final LaunchAction.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(LaunchAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(LaunchAction action) {
            this.action = action;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LaunchActionRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public LaunchActionRun build() {
            return new LaunchActionRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
