/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.drs.DrsClient;
import software.amazon.awssdk.services.drs.internal.UserAgentUtils;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.drs.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.drs.model.JobLog;

public class DescribeJobLogItemsIterable
implements SdkIterable<DescribeJobLogItemsResponse> {
    private final DrsClient client;
    private final DescribeJobLogItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeJobLogItemsIterable(DrsClient client, DescribeJobLogItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeJobLogItemsResponseFetcher();
    }

    public Iterator<DescribeJobLogItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<JobLog> items() {
        Function<DescribeJobLogItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeJobLogItemsResponseFetcher
    implements SyncPageFetcher<DescribeJobLogItemsResponse> {
        private DescribeJobLogItemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobLogItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeJobLogItemsResponse nextPage(DescribeJobLogItemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobLogItemsIterable.this.client.describeJobLogItems(DescribeJobLogItemsIterable.this.firstRequest);
            }
            return DescribeJobLogItemsIterable.this.client.describeJobLogItems((DescribeJobLogItemsRequest)((Object)DescribeJobLogItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

