/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.RecoveryLifeCycle;
import software.amazon.awssdk.services.drs.model.ReplicationStatus;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceNetwork
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceNetwork> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SourceNetwork.getter(SourceNetwork::arn)).setter(SourceNetwork.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CFN_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cfnStackName").getter(SourceNetwork.getter(SourceNetwork::cfnStackName)).setter(SourceNetwork.setter(Builder::cfnStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cfnStackName").build()}).build();
    private static final SdkField<RecoveryLifeCycle> LAST_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRecovery").getter(SourceNetwork.getter(SourceNetwork::lastRecovery)).setter(SourceNetwork.setter(Builder::lastRecovery)).constructor(RecoveryLifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRecovery").build()}).build();
    private static final SdkField<String> LAUNCHED_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchedVpcID").getter(SourceNetwork.getter(SourceNetwork::launchedVpcID)).setter(SourceNetwork.setter(Builder::launchedVpcID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedVpcID").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStatus").getter(SourceNetwork.getter(SourceNetwork::replicationStatusAsString)).setter(SourceNetwork.setter(Builder::replicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()}).build();
    private static final SdkField<String> REPLICATION_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStatusDetails").getter(SourceNetwork.getter(SourceNetwork::replicationStatusDetails)).setter(SourceNetwork.setter(Builder::replicationStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatusDetails").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccountID").getter(SourceNetwork.getter(SourceNetwork::sourceAccountID)).setter(SourceNetwork.setter(Builder::sourceAccountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountID").build()}).build();
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceNetworkID").getter(SourceNetwork.getter(SourceNetwork::sourceNetworkID)).setter(SourceNetwork.setter(Builder::sourceNetworkID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceRegion").getter(SourceNetwork.getter(SourceNetwork::sourceRegion)).setter(SourceNetwork.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()}).build();
    private static final SdkField<String> SOURCE_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVpcID").getter(SourceNetwork.getter(SourceNetwork::sourceVpcID)).setter(SourceNetwork.setter(Builder::sourceVpcID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVpcID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SourceNetwork.getter(SourceNetwork::tags)).setter(SourceNetwork.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CFN_STACK_NAME_FIELD, LAST_RECOVERY_FIELD, LAUNCHED_VPC_ID_FIELD, REPLICATION_STATUS_FIELD, REPLICATION_STATUS_DETAILS_FIELD, SOURCE_ACCOUNT_ID_FIELD, SOURCE_NETWORK_ID_FIELD, SOURCE_REGION_FIELD, SOURCE_VPC_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String cfnStackName;
    private final RecoveryLifeCycle lastRecovery;
    private final String launchedVpcID;
    private final String replicationStatus;
    private final String replicationStatusDetails;
    private final String sourceAccountID;
    private final String sourceNetworkID;
    private final String sourceRegion;
    private final String sourceVpcID;
    private final Map<String, String> tags;

    private SourceNetwork(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cfnStackName = builder.cfnStackName;
        this.lastRecovery = builder.lastRecovery;
        this.launchedVpcID = builder.launchedVpcID;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusDetails = builder.replicationStatusDetails;
        this.sourceAccountID = builder.sourceAccountID;
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceRegion = builder.sourceRegion;
        this.sourceVpcID = builder.sourceVpcID;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String cfnStackName() {
        return this.cfnStackName;
    }

    public final RecoveryLifeCycle lastRecovery() {
        return this.lastRecovery;
    }

    public final String launchedVpcID() {
        return this.launchedVpcID;
    }

    public final ReplicationStatus replicationStatus() {
        return ReplicationStatus.fromValue(this.replicationStatus);
    }

    public final String replicationStatusAsString() {
        return this.replicationStatus;
    }

    public final String replicationStatusDetails() {
        return this.replicationStatusDetails;
    }

    public final String sourceAccountID() {
        return this.sourceAccountID;
    }

    public final String sourceNetworkID() {
        return this.sourceNetworkID;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String sourceVpcID() {
        return this.sourceVpcID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cfnStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedVpcID());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVpcID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceNetwork)) {
            return false;
        }
        SourceNetwork other = (SourceNetwork)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cfnStackName(), other.cfnStackName()) && Objects.equals(this.lastRecovery(), other.lastRecovery()) && Objects.equals(this.launchedVpcID(), other.launchedVpcID()) && Objects.equals(this.replicationStatusAsString(), other.replicationStatusAsString()) && Objects.equals(this.replicationStatusDetails(), other.replicationStatusDetails()) && Objects.equals(this.sourceAccountID(), other.sourceAccountID()) && Objects.equals(this.sourceNetworkID(), other.sourceNetworkID()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceVpcID(), other.sourceVpcID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SourceNetwork").add("Arn", (Object)this.arn()).add("CfnStackName", (Object)(this.cfnStackName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastRecovery", (Object)this.lastRecovery()).add("LaunchedVpcID", (Object)this.launchedVpcID()).add("ReplicationStatus", (Object)this.replicationStatusAsString()).add("ReplicationStatusDetails", (Object)(this.replicationStatusDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceAccountID", (Object)this.sourceAccountID()).add("SourceNetworkID", (Object)this.sourceNetworkID()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceVpcID", (Object)this.sourceVpcID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "cfnStackName": {
                return Optional.ofNullable(clazz.cast(this.cfnStackName()));
            }
            case "lastRecovery": {
                return Optional.ofNullable(clazz.cast(this.lastRecovery()));
            }
            case "launchedVpcID": {
                return Optional.ofNullable(clazz.cast(this.launchedVpcID()));
            }
            case "replicationStatus": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusAsString()));
            }
            case "replicationStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.replicationStatusDetails()));
            }
            case "sourceAccountID": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountID()));
            }
            case "sourceNetworkID": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkID()));
            }
            case "sourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "sourceVpcID": {
                return Optional.ofNullable(clazz.cast(this.sourceVpcID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceNetwork, T> g) {
        return obj -> g.apply((SourceNetwork)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String cfnStackName;
        private RecoveryLifeCycle lastRecovery;
        private String launchedVpcID;
        private String replicationStatus;
        private String replicationStatusDetails;
        private String sourceAccountID;
        private String sourceNetworkID;
        private String sourceRegion;
        private String sourceVpcID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceNetwork model) {
            this.arn(model.arn);
            this.cfnStackName(model.cfnStackName);
            this.lastRecovery(model.lastRecovery);
            this.launchedVpcID(model.launchedVpcID);
            this.replicationStatus(model.replicationStatus);
            this.replicationStatusDetails(model.replicationStatusDetails);
            this.sourceAccountID(model.sourceAccountID);
            this.sourceNetworkID(model.sourceNetworkID);
            this.sourceRegion(model.sourceRegion);
            this.sourceVpcID(model.sourceVpcID);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCfnStackName() {
            return this.cfnStackName;
        }

        public final void setCfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
        }

        @Override
        public final Builder cfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
            return this;
        }

        public final RecoveryLifeCycle.Builder getLastRecovery() {
            return this.lastRecovery != null ? this.lastRecovery.toBuilder() : null;
        }

        public final void setLastRecovery(RecoveryLifeCycle.BuilderImpl lastRecovery) {
            this.lastRecovery = lastRecovery != null ? lastRecovery.build() : null;
        }

        @Override
        public final Builder lastRecovery(RecoveryLifeCycle lastRecovery) {
            this.lastRecovery = lastRecovery;
            return this;
        }

        public final String getLaunchedVpcID() {
            return this.launchedVpcID;
        }

        public final void setLaunchedVpcID(String launchedVpcID) {
            this.launchedVpcID = launchedVpcID;
        }

        @Override
        public final Builder launchedVpcID(String launchedVpcID) {
            this.launchedVpcID = launchedVpcID;
            return this;
        }

        public final String getReplicationStatus() {
            return this.replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(ReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getReplicationStatusDetails() {
            return this.replicationStatusDetails;
        }

        public final void setReplicationStatusDetails(String replicationStatusDetails) {
            this.replicationStatusDetails = replicationStatusDetails;
        }

        @Override
        public final Builder replicationStatusDetails(String replicationStatusDetails) {
            this.replicationStatusDetails = replicationStatusDetails;
            return this;
        }

        public final String getSourceAccountID() {
            return this.sourceAccountID;
        }

        public final void setSourceAccountID(String sourceAccountID) {
            this.sourceAccountID = sourceAccountID;
        }

        @Override
        public final Builder sourceAccountID(String sourceAccountID) {
            this.sourceAccountID = sourceAccountID;
            return this;
        }

        public final String getSourceNetworkID() {
            return this.sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceVpcID() {
            return this.sourceVpcID;
        }

        public final void setSourceVpcID(String sourceVpcID) {
            this.sourceVpcID = sourceVpcID;
        }

        @Override
        public final Builder sourceVpcID(String sourceVpcID) {
            this.sourceVpcID = sourceVpcID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public SourceNetwork build() {
            return new SourceNetwork(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceNetwork> {
        public Builder arn(String var1);

        public Builder cfnStackName(String var1);

        public Builder lastRecovery(RecoveryLifeCycle var1);

        default public Builder lastRecovery(Consumer<RecoveryLifeCycle.Builder> lastRecovery) {
            return this.lastRecovery((RecoveryLifeCycle)((RecoveryLifeCycle.Builder)RecoveryLifeCycle.builder().applyMutation(lastRecovery)).build());
        }

        public Builder launchedVpcID(String var1);

        public Builder replicationStatus(String var1);

        public Builder replicationStatus(ReplicationStatus var1);

        public Builder replicationStatusDetails(String var1);

        public Builder sourceAccountID(String var1);

        public Builder sourceNetworkID(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceVpcID(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

