/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a resource participating in an asynchronous Job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipatingResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipatingResource.Builder, ParticipatingResource> {
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchStatus").getter(getter(ParticipatingResource::launchStatusAsString))
            .setter(setter(Builder::launchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()).build();

    private static final SdkField<ParticipatingResourceID> PARTICIPATING_RESOURCE_ID_FIELD = SdkField
            .<ParticipatingResourceID> builder(MarshallingType.SDK_POJO).memberName("participatingResourceID")
            .getter(getter(ParticipatingResource::participatingResourceID)).setter(setter(Builder::participatingResourceID))
            .constructor(ParticipatingResourceID::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participatingResourceID").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_STATUS_FIELD,
            PARTICIPATING_RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchStatus;

    private final ParticipatingResourceID participatingResourceID;

    private ParticipatingResource(BuilderImpl builder) {
        this.launchStatus = builder.launchStatus;
        this.participatingResourceID = builder.participatingResourceID;
    }

    /**
     * <p>
     * The launch status of a participating resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of a participating resource.
     * @see LaunchStatus
     */
    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(launchStatus);
    }

    /**
     * <p>
     * The launch status of a participating resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return The launch status of a participating resource.
     * @see LaunchStatus
     */
    public final String launchStatusAsString() {
        return launchStatus;
    }

    /**
     * <p>
     * The ID of a participating resource.
     * </p>
     * 
     * @return The ID of a participating resource.
     */
    public final ParticipatingResourceID participatingResourceID() {
        return participatingResourceID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(participatingResourceID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingResource)) {
            return false;
        }
        ParticipatingResource other = (ParticipatingResource) obj;
        return Objects.equals(launchStatusAsString(), other.launchStatusAsString())
                && Objects.equals(participatingResourceID(), other.participatingResourceID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipatingResource").add("LaunchStatus", launchStatusAsString())
                .add("ParticipatingResourceID", participatingResourceID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchStatus":
            return Optional.ofNullable(clazz.cast(launchStatusAsString()));
        case "participatingResourceID":
            return Optional.ofNullable(clazz.cast(participatingResourceID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingResource, T> g) {
        return obj -> g.apply((ParticipatingResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipatingResource> {
        /**
         * <p>
         * The launch status of a participating resource.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of a participating resource.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(String launchStatus);

        /**
         * <p>
         * The launch status of a participating resource.
         * </p>
         * 
         * @param launchStatus
         *        The launch status of a participating resource.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(LaunchStatus launchStatus);

        /**
         * <p>
         * The ID of a participating resource.
         * </p>
         * 
         * @param participatingResourceID
         *        The ID of a participating resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder participatingResourceID(ParticipatingResourceID participatingResourceID);

        /**
         * <p>
         * The ID of a participating resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParticipatingResourceID.Builder} avoiding
         * the need to create one manually via {@link ParticipatingResourceID#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParticipatingResourceID.Builder#build()} is called immediately
         * and its result is passed to {@link #participatingResourceID(ParticipatingResourceID)}.
         * 
         * @param participatingResourceID
         *        a consumer that will call methods on {@link ParticipatingResourceID.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #participatingResourceID(ParticipatingResourceID)
         */
        default Builder participatingResourceID(Consumer<ParticipatingResourceID.Builder> participatingResourceID) {
            return participatingResourceID(ParticipatingResourceID.builder().applyMutation(participatingResourceID).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String launchStatus;

        private ParticipatingResourceID participatingResourceID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingResource model) {
            launchStatus(model.launchStatus);
            participatingResourceID(model.participatingResourceID);
        }

        public final String getLaunchStatus() {
            return launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final ParticipatingResourceID.Builder getParticipatingResourceID() {
            return participatingResourceID != null ? participatingResourceID.toBuilder() : null;
        }

        public final void setParticipatingResourceID(ParticipatingResourceID.BuilderImpl participatingResourceID) {
            this.participatingResourceID = participatingResourceID != null ? participatingResourceID.build() : null;
        }

        @Override
        public final Builder participatingResourceID(ParticipatingResourceID participatingResourceID) {
            this.participatingResourceID = participatingResourceID;
            return this;
        }

        @Override
        public ParticipatingResource build() {
            return new ParticipatingResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
