/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Account level Launch Configuration Template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchConfigurationTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchConfigurationTemplate.Builder, LaunchConfigurationTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(LaunchConfigurationTemplate::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(LaunchConfigurationTemplate::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(LaunchConfigurationTemplate::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<String> EXPORT_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportBucketArn").getter(getter(LaunchConfigurationTemplate::exportBucketArn))
            .setter(setter(Builder::exportBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportBucketArn").build()).build();

    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("launchConfigurationTemplateID")
            .getter(getter(LaunchConfigurationTemplate::launchConfigurationTemplateID))
            .setter(setter(Builder::launchConfigurationTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID")
                    .build()).build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(LaunchConfigurationTemplate::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(LaunchConfigurationTemplate::licensing)).setter(setter(Builder::licensing))
            .constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<Boolean> POST_LAUNCH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("postLaunchEnabled").getter(getter(LaunchConfigurationTemplate::postLaunchEnabled))
            .setter(setter(Builder::postLaunchEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchEnabled").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(LaunchConfigurationTemplate::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(LaunchConfigurationTemplate::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, EXPORT_BUCKET_ARN_FIELD, LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD,
            LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD, POST_LAUNCH_ENABLED_FIELD, TAGS_FIELD,
            TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final String exportBucketArn;

    private final String launchConfigurationTemplateID;

    private final String launchDisposition;

    private final Licensing licensing;

    private final Boolean postLaunchEnabled;

    private final Map<String, String> tags;

    private final String targetInstanceTypeRightSizingMethod;

    private LaunchConfigurationTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.exportBucketArn = builder.exportBucketArn;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.postLaunchEnabled = builder.postLaunchEnabled;
        this.tags = builder.tags;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * ARN of the Launch Configuration Template.
     * </p>
     * 
     * @return ARN of the Launch Configuration Template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Copy private IP.
     * </p>
     * 
     * @return Copy private IP.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Copy tags.
     * </p>
     * 
     * @return Copy tags.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * S3 bucket ARN to export Source Network templates.
     * </p>
     * 
     * @return S3 bucket ARN to export Source Network templates.
     */
    public final String exportBucketArn() {
        return exportBucketArn;
    }

    /**
     * <p>
     * ID of the Launch Configuration Template.
     * </p>
     * 
     * @return ID of the Launch Configuration Template.
     */
    public final String launchConfigurationTemplateID() {
        return launchConfigurationTemplateID;
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * Launch disposition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * <p>
     * Licensing.
     * </p>
     * 
     * @return Licensing.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * Post-launch actions activated.
     * </p>
     * 
     * @return Post-launch actions activated.
     */
    public final Boolean postLaunchEnabled() {
        return postLaunchEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags of the Launch Configuration Template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags of the Launch Configuration Template.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Target instance type right-sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Target instance type right-sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(exportBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(postLaunchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfigurationTemplate)) {
            return false;
        }
        LaunchConfigurationTemplate other = (LaunchConfigurationTemplate) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(exportBucketArn(), other.exportBucketArn())
                && Objects.equals(launchConfigurationTemplateID(), other.launchConfigurationTemplateID())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(postLaunchEnabled(), other.postLaunchEnabled())
                && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchConfigurationTemplate").add("Arn", arn()).add("CopyPrivateIp", copyPrivateIp())
                .add("CopyTags", copyTags()).add("ExportBucketArn", exportBucketArn())
                .add("LaunchConfigurationTemplateID", launchConfigurationTemplateID())
                .add("LaunchDisposition", launchDispositionAsString()).add("Licensing", licensing())
                .add("PostLaunchEnabled", postLaunchEnabled())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "exportBucketArn":
            return Optional.ofNullable(clazz.cast(exportBucketArn()));
        case "launchConfigurationTemplateID":
            return Optional.ofNullable(clazz.cast(launchConfigurationTemplateID()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "postLaunchEnabled":
            return Optional.ofNullable(clazz.cast(postLaunchEnabled()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfigurationTemplate, T> g) {
        return obj -> g.apply((LaunchConfigurationTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchConfigurationTemplate> {
        /**
         * <p>
         * ARN of the Launch Configuration Template.
         * </p>
         * 
         * @param arn
         *        ARN of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Copy private IP.
         * </p>
         * 
         * @param copyPrivateIp
         *        Copy private IP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Copy tags.
         * </p>
         * 
         * @param copyTags
         *        Copy tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * S3 bucket ARN to export Source Network templates.
         * </p>
         * 
         * @param exportBucketArn
         *        S3 bucket ARN to export Source Network templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportBucketArn(String exportBucketArn);

        /**
         * <p>
         * ID of the Launch Configuration Template.
         * </p>
         * 
         * @param launchConfigurationTemplateID
         *        ID of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationTemplateID(String launchConfigurationTemplateID);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * Launch disposition.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * <p>
         * Licensing.
         * </p>
         * 
         * @param licensing
         *        Licensing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * <p>
         * Licensing.
         * </p>
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * Post-launch actions activated.
         * </p>
         * 
         * @param postLaunchEnabled
         *        Post-launch actions activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchEnabled(Boolean postLaunchEnabled);

        /**
         * <p>
         * Tags of the Launch Configuration Template.
         * </p>
         * 
         * @param tags
         *        Tags of the Launch Configuration Template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Target instance type right-sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Target instance type right-sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private String exportBucketArn;

        private String launchConfigurationTemplateID;

        private String launchDisposition;

        private Licensing licensing;

        private Boolean postLaunchEnabled;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfigurationTemplate model) {
            arn(model.arn);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            exportBucketArn(model.exportBucketArn);
            launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            postLaunchEnabled(model.postLaunchEnabled);
            tags(model.tags);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getExportBucketArn() {
            return exportBucketArn;
        }

        public final void setExportBucketArn(String exportBucketArn) {
            this.exportBucketArn = exportBucketArn;
        }

        @Override
        public final Builder exportBucketArn(String exportBucketArn) {
            this.exportBucketArn = exportBucketArn;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final Boolean getPostLaunchEnabled() {
            return postLaunchEnabled;
        }

        public final void setPostLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
        }

        @Override
        public final Builder postLaunchEnabled(Boolean postLaunchEnabled) {
            this.postLaunchEnabled = postLaunchEnabled;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public LaunchConfigurationTemplate build() {
            return new LaunchConfigurationTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
