/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about Data Replication
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReplicationInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DataReplicationInfo.Builder, DataReplicationInfo> {
    private static final SdkField<DataReplicationError> DATA_REPLICATION_ERROR_FIELD = SdkField
            .<DataReplicationError> builder(MarshallingType.SDK_POJO).memberName("dataReplicationError")
            .getter(getter(DataReplicationInfo::dataReplicationError)).setter(setter(Builder::dataReplicationError))
            .constructor(DataReplicationError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationError").build())
            .build();

    private static final SdkField<DataReplicationInitiation> DATA_REPLICATION_INITIATION_FIELD = SdkField
            .<DataReplicationInitiation> builder(MarshallingType.SDK_POJO).memberName("dataReplicationInitiation")
            .getter(getter(DataReplicationInfo::dataReplicationInitiation)).setter(setter(Builder::dataReplicationInitiation))
            .constructor(DataReplicationInitiation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInitiation").build())
            .build();

    private static final SdkField<String> DATA_REPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataReplicationState").getter(getter(DataReplicationInfo::dataReplicationStateAsString))
            .setter(setter(Builder::dataReplicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationState").build())
            .build();

    private static final SdkField<String> ETA_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("etaDateTime").getter(getter(DataReplicationInfo::etaDateTime)).setter(setter(Builder::etaDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etaDateTime").build()).build();

    private static final SdkField<String> LAG_DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lagDuration").getter(getter(DataReplicationInfo::lagDuration)).setter(setter(Builder::lagDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagDuration").build()).build();

    private static final SdkField<List<DataReplicationInfoReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField
            .<List<DataReplicationInfoReplicatedDisk>> builder(MarshallingType.LIST)
            .memberName("replicatedDisks")
            .getter(getter(DataReplicationInfo::replicatedDisks))
            .setter(setter(Builder::replicatedDisks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataReplicationInfoReplicatedDisk> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataReplicationInfoReplicatedDisk::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STAGING_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stagingAvailabilityZone").getter(getter(DataReplicationInfo::stagingAvailabilityZone))
            .setter(setter(Builder::stagingAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAvailabilityZone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_REPLICATION_ERROR_FIELD,
            DATA_REPLICATION_INITIATION_FIELD, DATA_REPLICATION_STATE_FIELD, ETA_DATE_TIME_FIELD, LAG_DURATION_FIELD,
            REPLICATED_DISKS_FIELD, STAGING_AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataReplicationError dataReplicationError;

    private final DataReplicationInitiation dataReplicationInitiation;

    private final String dataReplicationState;

    private final String etaDateTime;

    private final String lagDuration;

    private final List<DataReplicationInfoReplicatedDisk> replicatedDisks;

    private final String stagingAvailabilityZone;

    private DataReplicationInfo(BuilderImpl builder) {
        this.dataReplicationError = builder.dataReplicationError;
        this.dataReplicationInitiation = builder.dataReplicationInitiation;
        this.dataReplicationState = builder.dataReplicationState;
        this.etaDateTime = builder.etaDateTime;
        this.lagDuration = builder.lagDuration;
        this.replicatedDisks = builder.replicatedDisks;
        this.stagingAvailabilityZone = builder.stagingAvailabilityZone;
    }

    /**
     * <p>
     * Error in data replication.
     * </p>
     * 
     * @return Error in data replication.
     */
    public final DataReplicationError dataReplicationError() {
        return dataReplicationError;
    }

    /**
     * <p>
     * Information about whether the data replication has been initiated.
     * </p>
     * 
     * @return Information about whether the data replication has been initiated.
     */
    public final DataReplicationInitiation dataReplicationInitiation() {
        return dataReplicationInitiation;
    }

    /**
     * <p>
     * The state of the data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link DataReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return The state of the data replication.
     * @see DataReplicationState
     */
    public final DataReplicationState dataReplicationState() {
        return DataReplicationState.fromValue(dataReplicationState);
    }

    /**
     * <p>
     * The state of the data replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataReplicationState} will return {@link DataReplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataReplicationStateAsString}.
     * </p>
     * 
     * @return The state of the data replication.
     * @see DataReplicationState
     */
    public final String dataReplicationStateAsString() {
        return dataReplicationState;
    }

    /**
     * <p>
     * An estimate of when the data replication will be completed.
     * </p>
     * 
     * @return An estimate of when the data replication will be completed.
     */
    public final String etaDateTime() {
        return etaDateTime;
    }

    /**
     * <p>
     * Data replication lag duration.
     * </p>
     * 
     * @return Data replication lag duration.
     */
    public final String lagDuration() {
        return lagDuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicatedDisks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplicatedDisks() {
        return replicatedDisks != null && !(replicatedDisks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The disks that should be replicated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicatedDisks} method.
     * </p>
     * 
     * @return The disks that should be replicated.
     */
    public final List<DataReplicationInfoReplicatedDisk> replicatedDisks() {
        return replicatedDisks;
    }

    /**
     * <p>
     * AWS Availability zone into which data is being replicated.
     * </p>
     * 
     * @return AWS Availability zone into which data is being replicated.
     */
    public final String stagingAvailabilityZone() {
        return stagingAvailabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationError());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationInitiation());
        hashCode = 31 * hashCode + Objects.hashCode(dataReplicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(etaDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lagDuration());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicatedDisks() ? replicatedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stagingAvailabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInfo)) {
            return false;
        }
        DataReplicationInfo other = (DataReplicationInfo) obj;
        return Objects.equals(dataReplicationError(), other.dataReplicationError())
                && Objects.equals(dataReplicationInitiation(), other.dataReplicationInitiation())
                && Objects.equals(dataReplicationStateAsString(), other.dataReplicationStateAsString())
                && Objects.equals(etaDateTime(), other.etaDateTime()) && Objects.equals(lagDuration(), other.lagDuration())
                && hasReplicatedDisks() == other.hasReplicatedDisks()
                && Objects.equals(replicatedDisks(), other.replicatedDisks())
                && Objects.equals(stagingAvailabilityZone(), other.stagingAvailabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReplicationInfo").add("DataReplicationError", dataReplicationError())
                .add("DataReplicationInitiation", dataReplicationInitiation())
                .add("DataReplicationState", dataReplicationStateAsString()).add("EtaDateTime", etaDateTime())
                .add("LagDuration", lagDuration()).add("ReplicatedDisks", hasReplicatedDisks() ? replicatedDisks() : null)
                .add("StagingAvailabilityZone", stagingAvailabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataReplicationError":
            return Optional.ofNullable(clazz.cast(dataReplicationError()));
        case "dataReplicationInitiation":
            return Optional.ofNullable(clazz.cast(dataReplicationInitiation()));
        case "dataReplicationState":
            return Optional.ofNullable(clazz.cast(dataReplicationStateAsString()));
        case "etaDateTime":
            return Optional.ofNullable(clazz.cast(etaDateTime()));
        case "lagDuration":
            return Optional.ofNullable(clazz.cast(lagDuration()));
        case "replicatedDisks":
            return Optional.ofNullable(clazz.cast(replicatedDisks()));
        case "stagingAvailabilityZone":
            return Optional.ofNullable(clazz.cast(stagingAvailabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInfo, T> g) {
        return obj -> g.apply((DataReplicationInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReplicationInfo> {
        /**
         * <p>
         * Error in data replication.
         * </p>
         * 
         * @param dataReplicationError
         *        Error in data replication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationError(DataReplicationError dataReplicationError);

        /**
         * <p>
         * Error in data replication.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationError.Builder} avoiding
         * the need to create one manually via {@link DataReplicationError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationError.Builder#build()} is called immediately and
         * its result is passed to {@link #dataReplicationError(DataReplicationError)}.
         * 
         * @param dataReplicationError
         *        a consumer that will call methods on {@link DataReplicationError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationError(DataReplicationError)
         */
        default Builder dataReplicationError(Consumer<DataReplicationError.Builder> dataReplicationError) {
            return dataReplicationError(DataReplicationError.builder().applyMutation(dataReplicationError).build());
        }

        /**
         * <p>
         * Information about whether the data replication has been initiated.
         * </p>
         * 
         * @param dataReplicationInitiation
         *        Information about whether the data replication has been initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataReplicationInitiation(DataReplicationInitiation dataReplicationInitiation);

        /**
         * <p>
         * Information about whether the data replication has been initiated.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataReplicationInitiation.Builder}
         * avoiding the need to create one manually via {@link DataReplicationInitiation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataReplicationInitiation.Builder#build()} is called immediately
         * and its result is passed to {@link #dataReplicationInitiation(DataReplicationInitiation)}.
         * 
         * @param dataReplicationInitiation
         *        a consumer that will call methods on {@link DataReplicationInitiation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataReplicationInitiation(DataReplicationInitiation)
         */
        default Builder dataReplicationInitiation(Consumer<DataReplicationInitiation.Builder> dataReplicationInitiation) {
            return dataReplicationInitiation(DataReplicationInitiation.builder().applyMutation(dataReplicationInitiation).build());
        }

        /**
         * <p>
         * The state of the data replication.
         * </p>
         * 
         * @param dataReplicationState
         *        The state of the data replication.
         * @see DataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationState
         */
        Builder dataReplicationState(String dataReplicationState);

        /**
         * <p>
         * The state of the data replication.
         * </p>
         * 
         * @param dataReplicationState
         *        The state of the data replication.
         * @see DataReplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataReplicationState
         */
        Builder dataReplicationState(DataReplicationState dataReplicationState);

        /**
         * <p>
         * An estimate of when the data replication will be completed.
         * </p>
         * 
         * @param etaDateTime
         *        An estimate of when the data replication will be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etaDateTime(String etaDateTime);

        /**
         * <p>
         * Data replication lag duration.
         * </p>
         * 
         * @param lagDuration
         *        Data replication lag duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lagDuration(String lagDuration);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        The disks that should be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> replicatedDisks);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * 
         * @param replicatedDisks
         *        The disks that should be replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicatedDisks(DataReplicationInfoReplicatedDisk... replicatedDisks);

        /**
         * <p>
         * The disks that should be replicated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.drs.model.DataReplicationInfoReplicatedDisk.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.drs.model.DataReplicationInfoReplicatedDisk#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.drs.model.DataReplicationInfoReplicatedDisk.Builder#build()} is called
         * immediately and its result is passed to {@link #replicatedDisks(List<DataReplicationInfoReplicatedDisk>)}.
         * 
         * @param replicatedDisks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.drs.model.DataReplicationInfoReplicatedDisk.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicatedDisks(java.util.Collection<DataReplicationInfoReplicatedDisk>)
         */
        Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder>... replicatedDisks);

        /**
         * <p>
         * AWS Availability zone into which data is being replicated.
         * </p>
         * 
         * @param stagingAvailabilityZone
         *        AWS Availability zone into which data is being replicated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingAvailabilityZone(String stagingAvailabilityZone);
    }

    static final class BuilderImpl implements Builder {
        private DataReplicationError dataReplicationError;

        private DataReplicationInitiation dataReplicationInitiation;

        private String dataReplicationState;

        private String etaDateTime;

        private String lagDuration;

        private List<DataReplicationInfoReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();

        private String stagingAvailabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInfo model) {
            dataReplicationError(model.dataReplicationError);
            dataReplicationInitiation(model.dataReplicationInitiation);
            dataReplicationState(model.dataReplicationState);
            etaDateTime(model.etaDateTime);
            lagDuration(model.lagDuration);
            replicatedDisks(model.replicatedDisks);
            stagingAvailabilityZone(model.stagingAvailabilityZone);
        }

        public final DataReplicationError.Builder getDataReplicationError() {
            return dataReplicationError != null ? dataReplicationError.toBuilder() : null;
        }

        public final void setDataReplicationError(DataReplicationError.BuilderImpl dataReplicationError) {
            this.dataReplicationError = dataReplicationError != null ? dataReplicationError.build() : null;
        }

        @Override
        public final Builder dataReplicationError(DataReplicationError dataReplicationError) {
            this.dataReplicationError = dataReplicationError;
            return this;
        }

        public final DataReplicationInitiation.Builder getDataReplicationInitiation() {
            return dataReplicationInitiation != null ? dataReplicationInitiation.toBuilder() : null;
        }

        public final void setDataReplicationInitiation(DataReplicationInitiation.BuilderImpl dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation != null ? dataReplicationInitiation.build() : null;
        }

        @Override
        public final Builder dataReplicationInitiation(DataReplicationInitiation dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation;
            return this;
        }

        public final String getDataReplicationState() {
            return dataReplicationState;
        }

        public final void setDataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
        }

        @Override
        public final Builder dataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
            return this;
        }

        @Override
        public final Builder dataReplicationState(DataReplicationState dataReplicationState) {
            this.dataReplicationState(dataReplicationState == null ? null : dataReplicationState.toString());
            return this;
        }

        public final String getEtaDateTime() {
            return etaDateTime;
        }

        public final void setEtaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
        }

        @Override
        public final Builder etaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
            return this;
        }

        public final String getLagDuration() {
            return lagDuration;
        }

        public final void setLagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
        }

        @Override
        public final Builder lagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
            return this;
        }

        public final List<DataReplicationInfoReplicatedDisk.Builder> getReplicatedDisks() {
            List<DataReplicationInfoReplicatedDisk.Builder> result = DataReplicationInfoReplicatedDisksCopier
                    .copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(Collection<DataReplicationInfoReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public final Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(DataReplicationInfoReplicatedDisk... replicatedDisks) {
            replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder>... replicatedDisks) {
            replicatedDisks(Stream.of(replicatedDisks)
                    .map(c -> DataReplicationInfoReplicatedDisk.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStagingAvailabilityZone() {
            return stagingAvailabilityZone;
        }

        public final void setStagingAvailabilityZone(String stagingAvailabilityZone) {
            this.stagingAvailabilityZone = stagingAvailabilityZone;
        }

        @Override
        public final Builder stagingAvailabilityZone(String stagingAvailabilityZone) {
            this.stagingAvailabilityZone = stagingAvailabilityZone;
            return this;
        }

        @Override
        public DataReplicationInfo build() {
            return new DataReplicationInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
