/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.docdb.DocDbAsyncClient;
import software.amazon.awssdk.services.docdb.model.DBInstance;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbInstancesResponse;

public class DescribeDBInstancesPublisher
implements SdkPublisher<DescribeDbInstancesResponse> {
    private final DocDbAsyncClient client;
    private final DescribeDbInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBInstancesPublisher(DocDbAsyncClient client, DescribeDbInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBInstancesPublisher(DocDbAsyncClient client, DescribeDbInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DBInstance> dbInstances() {
        Function<DescribeDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbInstances() != null) {
                return response.dbInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDbInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeDbInstancesResponse> {
        private DescribeDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeDbInstancesResponse> nextPage(DescribeDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBInstancesPublisher.this.client.describeDBInstances(DescribeDBInstancesPublisher.this.firstRequest);
            }
            return DescribeDBInstancesPublisher.this.client.describeDBInstances((DescribeDbInstancesRequest)((Object)DescribeDBInstancesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

