/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Snapshot and AMI policies only]</b> Specifies a cross-Region copy rule for snapshot and AMI policies.
 * </p>
 * <note>
 * <p>
 * To specify a cross-Region copy action for event-based polices, use <a>CrossRegionCopyAction</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CrossRegionCopyRule implements SdkPojo, Serializable,
        ToCopyableBuilder<CrossRegionCopyRule.Builder, CrossRegionCopyRule> {
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetRegion").getter(getter(CrossRegionCopyRule::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRegion").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(CrossRegionCopyRule::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(CrossRegionCopyRule::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> CMK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CmkArn")
            .getter(getter(CrossRegionCopyRule::cmkArn)).setter(setter(Builder::cmkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkArn").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTags").getter(getter(CrossRegionCopyRule::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()).build();

    private static final SdkField<CrossRegionCopyRetainRule> RETAIN_RULE_FIELD = SdkField
            .<CrossRegionCopyRetainRule> builder(MarshallingType.SDK_POJO).memberName("RetainRule")
            .getter(getter(CrossRegionCopyRule::retainRule)).setter(setter(Builder::retainRule))
            .constructor(CrossRegionCopyRetainRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()).build();

    private static final SdkField<CrossRegionCopyDeprecateRule> DEPRECATE_RULE_FIELD = SdkField
            .<CrossRegionCopyDeprecateRule> builder(MarshallingType.SDK_POJO).memberName("DeprecateRule")
            .getter(getter(CrossRegionCopyRule::deprecateRule)).setter(setter(Builder::deprecateRule))
            .constructor(CrossRegionCopyDeprecateRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecateRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_REGION_FIELD,
            TARGET_FIELD, ENCRYPTED_FIELD, CMK_ARN_FIELD, COPY_TAGS_FIELD, RETAIN_RULE_FIELD, DEPRECATE_RULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetRegion;

    private final String target;

    private final Boolean encrypted;

    private final String cmkArn;

    private final Boolean copyTags;

    private final CrossRegionCopyRetainRule retainRule;

    private final CrossRegionCopyDeprecateRule deprecateRule;

    private CrossRegionCopyRule(BuilderImpl builder) {
        this.targetRegion = builder.targetRegion;
        this.target = builder.target;
        this.encrypted = builder.encrypted;
        this.cmkArn = builder.cmkArn;
        this.copyTags = builder.copyTags;
        this.retainRule = builder.retainRule;
        this.deprecateRule = builder.deprecateRule;
    }

    /**
     * <note>
     * <p>
     * Avoid using this parameter when creating new policies. Instead, use <b>Target</b> to specify a target Region or a
     * target Outpost for snapshot copies.
     * </p>
     * <p>
     * For policies created before the <b>Target</b> parameter was introduced, this parameter indicates the target
     * Region for snapshot copies.
     * </p>
     * </note>
     * 
     * @return <p>
     *         Avoid using this parameter when creating new policies. Instead, use <b>Target</b> to specify a target
     *         Region or a target Outpost for snapshot copies.
     *         </p>
     *         <p>
     *         For policies created before the <b>Target</b> parameter was introduced, this parameter indicates the
     *         target Region for snapshot copies.
     *         </p>
     */
    public final String targetRegion() {
        return targetRegion;
    }

    /**
     * <p>
     * The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
     * </p>
     * <p>
     * Use this parameter instead of <b>TargetRegion</b>. Do not specify both.
     * </p>
     * 
     * @return The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.</p>
     *         <p>
     *         Use this parameter instead of <b>TargetRegion</b>. Do not specify both.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using
     * this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption by
     * default is not enabled.
     * </p>
     * 
     * @return To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption
     *         using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if
     *         encryption by default is not enabled.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified, the
     * default KMS key for the account is used.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not
     *         specified, the default KMS key for the account is used.
     */
    public final String cmkArn() {
        return cmkArn;
    }

    /**
     * <p>
     * Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
     * </p>
     * 
     * @return Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the
     * destination Region.
     * </p>
     * 
     * @return The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in
     *         the destination Region.
     */
    public final CrossRegionCopyRetainRule retainRule() {
        return retainRule;
    }

    /**
     * <p>
     * <b>[AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.
     * </p>
     * 
     * @return <b>[AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.
     */
    public final CrossRegionCopyDeprecateRule deprecateRule() {
        return deprecateRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(cmkArn());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(retainRule());
        hashCode = 31 * hashCode + Objects.hashCode(deprecateRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyRule)) {
            return false;
        }
        CrossRegionCopyRule other = (CrossRegionCopyRule) obj;
        return Objects.equals(targetRegion(), other.targetRegion()) && Objects.equals(target(), other.target())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(cmkArn(), other.cmkArn())
                && Objects.equals(copyTags(), other.copyTags()) && Objects.equals(retainRule(), other.retainRule())
                && Objects.equals(deprecateRule(), other.deprecateRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CrossRegionCopyRule").add("TargetRegion", targetRegion()).add("Target", target())
                .add("Encrypted", encrypted()).add("CmkArn", cmkArn()).add("CopyTags", copyTags())
                .add("RetainRule", retainRule()).add("DeprecateRule", deprecateRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "CmkArn":
            return Optional.ofNullable(clazz.cast(cmkArn()));
        case "CopyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "RetainRule":
            return Optional.ofNullable(clazz.cast(retainRule()));
        case "DeprecateRule":
            return Optional.ofNullable(clazz.cast(deprecateRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyRule, T> g) {
        return obj -> g.apply((CrossRegionCopyRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CrossRegionCopyRule> {
        /**
         * <note>
         * <p>
         * Avoid using this parameter when creating new policies. Instead, use <b>Target</b> to specify a target Region
         * or a target Outpost for snapshot copies.
         * </p>
         * <p>
         * For policies created before the <b>Target</b> parameter was introduced, this parameter indicates the target
         * Region for snapshot copies.
         * </p>
         * </note>
         * 
         * @param targetRegion
         *        <p>
         *        Avoid using this parameter when creating new policies. Instead, use <b>Target</b> to specify a target
         *        Region or a target Outpost for snapshot copies.
         *        </p>
         *        <p>
         *        For policies created before the <b>Target</b> parameter was introduced, this parameter indicates the
         *        target Region for snapshot copies.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);

        /**
         * <p>
         * The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.
         * </p>
         * <p>
         * Use this parameter instead of <b>TargetRegion</b>. Do not specify both.
         * </p>
         * 
         * @param target
         *        The target Region or the Amazon Resource Name (ARN) of the target Outpost for the snapshot copies.</p>
         *        <p>
         *        Use this parameter instead of <b>TargetRegion</b>. Do not specify both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable encryption using
         * this parameter. Copies of encrypted snapshots are encrypted, even if this parameter is false or if encryption
         * by default is not enabled.
         * </p>
         * 
         * @param encrypted
         *        To encrypt a copy of an unencrypted snapshot if encryption by default is not enabled, enable
         *        encryption using this parameter. Copies of encrypted snapshots are encrypted, even if this parameter
         *        is false or if encryption by default is not enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not specified,
         * the default KMS key for the account is used.
         * </p>
         * 
         * @param cmkArn
         *        The Amazon Resource Name (ARN) of the KMS key to use for EBS encryption. If this parameter is not
         *        specified, the default KMS key for the account is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmkArn(String cmkArn);

        /**
         * <p>
         * Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region copy.
         * </p>
         * 
         * @param copyTags
         *        Indicates whether to copy all user-defined tags from the source snapshot or AMI to the cross-Region
         *        copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the
         * destination Region.
         * </p>
         * 
         * @param retainRule
         *        The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained
         *        in the destination Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retainRule(CrossRegionCopyRetainRule retainRule);

        /**
         * <p>
         * The retention rule that indicates how long the cross-Region snapshot or AMI copies are to be retained in the
         * destination Region.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrossRegionCopyRetainRule.Builder}
         * avoiding the need to create one manually via {@link CrossRegionCopyRetainRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrossRegionCopyRetainRule.Builder#build()} is called immediately
         * and its result is passed to {@link #retainRule(CrossRegionCopyRetainRule)}.
         * 
         * @param retainRule
         *        a consumer that will call methods on {@link CrossRegionCopyRetainRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retainRule(CrossRegionCopyRetainRule)
         */
        default Builder retainRule(Consumer<CrossRegionCopyRetainRule.Builder> retainRule) {
            return retainRule(CrossRegionCopyRetainRule.builder().applyMutation(retainRule).build());
        }

        /**
         * <p>
         * <b>[AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.
         * </p>
         * 
         * @param deprecateRule
         *        <b>[AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecateRule(CrossRegionCopyDeprecateRule deprecateRule);

        /**
         * <p>
         * <b>[AMI policies only]</b> The AMI deprecation rule for cross-Region AMI copies created by the rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link CrossRegionCopyDeprecateRule.Builder}
         * avoiding the need to create one manually via {@link CrossRegionCopyDeprecateRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CrossRegionCopyDeprecateRule.Builder#build()} is called
         * immediately and its result is passed to {@link #deprecateRule(CrossRegionCopyDeprecateRule)}.
         * 
         * @param deprecateRule
         *        a consumer that will call methods on {@link CrossRegionCopyDeprecateRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deprecateRule(CrossRegionCopyDeprecateRule)
         */
        default Builder deprecateRule(Consumer<CrossRegionCopyDeprecateRule.Builder> deprecateRule) {
            return deprecateRule(CrossRegionCopyDeprecateRule.builder().applyMutation(deprecateRule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String targetRegion;

        private String target;

        private Boolean encrypted;

        private String cmkArn;

        private Boolean copyTags;

        private CrossRegionCopyRetainRule retainRule;

        private CrossRegionCopyDeprecateRule deprecateRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyRule model) {
            targetRegion(model.targetRegion);
            target(model.target);
            encrypted(model.encrypted);
            cmkArn(model.cmkArn);
            copyTags(model.copyTags);
            retainRule(model.retainRule);
            deprecateRule(model.deprecateRule);
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getCmkArn() {
            return cmkArn;
        }

        public final void setCmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
        }

        @Override
        public final Builder cmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final CrossRegionCopyRetainRule.Builder getRetainRule() {
            return retainRule != null ? retainRule.toBuilder() : null;
        }

        public final void setRetainRule(CrossRegionCopyRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        public final Builder retainRule(CrossRegionCopyRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final CrossRegionCopyDeprecateRule.Builder getDeprecateRule() {
            return deprecateRule != null ? deprecateRule.toBuilder() : null;
        }

        public final void setDeprecateRule(CrossRegionCopyDeprecateRule.BuilderImpl deprecateRule) {
            this.deprecateRule = deprecateRule != null ? deprecateRule.build() : null;
        }

        @Override
        public final Builder deprecateRule(CrossRegionCopyDeprecateRule deprecateRule) {
            this.deprecateRule = deprecateRule;
            return this;
        }

        @Override
        public CrossRegionCopyRule build() {
            return new CrossRegionCopyRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
