/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.directory.DefaultDirectoryBaseClientBuilder;
import software.amazon.awssdk.services.directory.DefaultDirectoryClient;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.DirectoryClientBuilder;
import software.amazon.awssdk.services.directory.DirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.directory.endpoints.DirectoryEndpointProvider;

@SdkInternalApi
final class DefaultDirectoryClientBuilder
extends DefaultDirectoryBaseClientBuilder<DirectoryClientBuilder, DirectoryClient>
implements DirectoryClientBuilder {
    DefaultDirectoryClientBuilder() {
    }

    @Override
    public DefaultDirectoryClientBuilder endpointProvider(DirectoryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DirectoryClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDirectoryClientBuilder.validateClientOptions(clientConfiguration);
        DirectoryServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDirectoryClient client = new DefaultDirectoryClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DirectoryServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DirectoryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

