/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmClient;
import software.amazon.awssdk.services.devicefarm.internal.UserAgentUtils;
import software.amazon.awssdk.services.devicefarm.model.DevicePool;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListDevicePoolsResponse;

public class ListDevicePoolsIterable
implements SdkIterable<ListDevicePoolsResponse> {
    private final DeviceFarmClient client;
    private final ListDevicePoolsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicePoolsIterable(DeviceFarmClient client, ListDevicePoolsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevicePoolsResponseFetcher();
    }

    public Iterator<ListDevicePoolsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DevicePool> devicePools() {
        Function<ListDevicePoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.devicePools() != null) {
                return response.devicePools().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevicePoolsResponseFetcher
    implements SyncPageFetcher<ListDevicePoolsResponse> {
        private ListDevicePoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicePoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicePoolsResponse nextPage(ListDevicePoolsResponse previousPage) {
            if (previousPage == null) {
                return ListDevicePoolsIterable.this.client.listDevicePools(ListDevicePoolsIterable.this.firstRequest);
            }
            return ListDevicePoolsIterable.this.client.listDevicePools((ListDevicePoolsRequest)((Object)ListDevicePoolsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

