/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InteractionMode {
    INTERACTIVE("INTERACTIVE"),
    NO_VIDEO("NO_VIDEO"),
    VIDEO_ONLY("VIDEO_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InteractionMode> VALUE_MAP;
    private final String value;

    private InteractionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InteractionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InteractionMode> knownValues() {
        EnumSet<InteractionMode> knownValues = EnumSet.allOf(InteractionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InteractionMode.class, InteractionMode::toString);
    }
}

